/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.xml.counters;

import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.utility.ClusterNameUtils;
import com.arm.streamline.common.utility.Ternary;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.counters.BadXmlException;
import com.arm.streamline.common.xml.counters.Category;
import com.arm.streamline.common.xml.counters.CounterSet;
import com.arm.streamline.common.xml.counters.IAvailableEvent;
import com.arm.streamline.common.xml.counters.Option;
import com.arm.streamline.common.xml.counters.OptionSet;
import com.arm.streamline.common.xml.counters.TargetCounter;
import com.arm.utils.MapUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.ObjIntPair;
import com.arm.utils.text.NumericStringComparator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StockCounter
implements Comparable<StockCounter>,
IAvailableEvent {
    private static final String ATTR_ACTIVITY = "activity";
    private static final String ATTR_ACTIVITY_COLOR = "activity_color";
    private static final String ATTR_ADVANCED = "advanced";
    private static final String ATTR_ARG = "arg";
    private static final String ATTR_AVERAGE_CORES = "average_cores";
    private static final String ATTR_AVERAGE_SELECTION = "average_selection";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_COLOR = "color";
    private static final String ATTR_CORES = "cores";
    private static final String ATTR_COUNTER = "counter";
    private static final String ATTR_DERIVED = "derived";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_DISPLAY = "display";
    private static final String ATTR_EVENT = "event";
    private static final String ATTR_METRIC = "metric";
    private static final String ATTR_METRIC_CPU_COUNTER_SET = "metric_cpu_counter_set";
    private static final String ATTR_METRIC_NUM_EVENTS = "metric_num_events";
    private static final String ATTR_METRIC_USES_CYCLES = "metric_uses_cycles";
    private static final String ATTR_MODIFIER = "modifier";
    private static final String ATTR_MULTIPLIER = "multiplier";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_OPTION_SET = "option_set";
    private static final String ATTR_PER_CPU = "per_cpu";
    private static final String ATTR_PERCENTAGE = "percentage";
    private static final String ATTR_PROC = "proc";
    private static final String ATTR_REGEX = "regex";
    private static final String ATTR_RENDERING_TYPE = "rendering_type";
    private static final String ATTR_SERIES_COMPOSITION = "series_composition";
    private static final String ATTR_SUPPORTS_EVENT_BASED_SAMPLING = "supports_event_based_sampling";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_TRACEPOINT = "tracepoint";
    private static final String ATTR_UNITS = "units";
    private final @Nullable CounterSet cyclesCounterSet;
    private final @NonNull List<@NonNull String> mActivity = new ArrayList<String>();
    private final @NonNull TIntArrayList mActivityColor = new TIntArrayList();
    private final boolean mAdvanced;
    private final String mArg;
    private final boolean mAverageCores;
    private boolean mAverageSelection;
    private final @NonNull Category mCategory;
    private final String mClass;
    private final boolean mUseClusterForCounter;
    private final @Nullable ObjIntPair<@NonNull String> mClusterProperties;
    private Integer mColor;
    private final int mCores;
    private final @Nullable String mCounterName;
    private boolean mDerived;
    private final @NonNull String mDescription;
    private final @NonNull String mDisplay;
    private final @Nullable MetricProperties metricProperties;
    private final @Nullable Long mEvent;
    private double mMultiplier;
    private final @NonNull String mName;
    private final @Nullable OptionSet mOptionSet;
    private boolean mPercentage;
    private final boolean mPerCPU;
    private final @NonNull Ternary mProc;
    private final String mRegex;
    private String mRenderingType;
    private final String mSeriesComposition;
    private final boolean mSupportsEventBasedSampling;
    private @NonNull String mTitle;
    private final String mTracepoint;
    private final String mUnits;

    public StockCounter(@NonNull Category category, @Nullable String counterName, long event, @NonNull String title, @NonNull String name, boolean perCpu, @NonNull String description, String clazz, String units, String composition, boolean averageCores) {
        this(category, counterName, (Long)event, title, name, perCpu, description, clazz, units, composition, averageCores, (ObjIntPair<String>)null);
    }

    public StockCounter(@NonNull Category category, @Nullable String counterName, long event, @NonNull String title, @NonNull String name, boolean perCpu, @NonNull String description, String clazz, String units, String composition, boolean averageCores, @Nullable ObjIntPair<@NonNull String> clusterProperties) {
        this(category, counterName, (Long)event, title, name, perCpu, description, clazz, units, composition, averageCores, clusterProperties);
    }

    public StockCounter(@NonNull Category category, @NonNull String counterName, @NonNull String title, @NonNull String name, boolean perCpu, @NonNull String description, String clazz, String units, String composition, boolean averageCores) {
        this(category, counterName, null, title, name, perCpu, description, clazz, units, composition, averageCores, null);
    }

    public StockCounter(@NonNull Category category, @NonNull String counterName, @NonNull String title, @NonNull String name, boolean perCpu, @NonNull String description, String clazz, String units, String composition, boolean averageCores, @Nullable ObjIntPair<@NonNull String> clusterProperties) {
        this(category, counterName, null, title, name, perCpu, description, clazz, units, composition, averageCores, clusterProperties);
    }

    public StockCounter(XMLParser in, @NonNull Category category, @NonNull TIntObjectMap<String> clusterNames, @NonNull Function<@NonNull String, @Nullable CounterSet> counterSetLookup) throws IOException, BadXmlException {
        Predicate<String> matchesCluster;
        String counterName;
        this.mCounterName = counterName = in.getAttribute(ATTR_COUNTER);
        this.mEvent = in.hasAttribute(ATTR_EVENT) ? Long.valueOf(in.getLongAttribute(ATTR_EVENT)) : null;
        this.mCategory = category;
        this.mOptionSet = this.mCategory.getOptionSet(in.getAttribute(ATTR_OPTION_SET));
        this.mDescription = in.getAttribute(ATTR_DESCRIPTION, "");
        this.mTitle = in.getAttribute(ATTR_TITLE, "");
        this.mName = in.getAttribute(ATTR_NAME, "");
        this.mClass = in.getAttribute(ATTR_CLASS, "");
        this.mDisplay = in.getAttribute(ATTR_DISPLAY, "");
        this.mUnits = in.getAttribute(ATTR_UNITS, "");
        boolean metric = in.isAttributeSet(ATTR_METRIC);
        boolean metricUsesCycles = in.isAttributeSet(ATTR_METRIC_USES_CYCLES);
        int metricNumEvents = in.getIntegerAttribute(ATTR_METRIC_NUM_EVENTS, 0);
        String metricCounterSet = in.getAttribute(ATTR_METRIC_CPU_COUNTER_SET);
        this.metricProperties = metric ? new MetricProperties(metricUsesCycles, metricNumEvents, metricCounterSet != null ? counterSetLookup.apply(metricCounterSet) : null) : null;
        this.cyclesCounterSet = counterName != null && counterName.endsWith("_ccnt") ? counterSetLookup.apply(counterName.substring(0, counterName.length() - 5)) : null;
        int modifier = in.getIntegerAttribute(ATTR_MODIFIER, 1);
        double multiplier = in.getDoubleAttribute(ATTR_MULTIPLIER, 1.0);
        this.mMultiplier = Double.compare(multiplier, 1.0) == 0 ? 1.0 / (double)modifier : multiplier;
        this.mCores = in.getIntegerAttribute(ATTR_CORES, ATTR_ACTIVITY.equals(this.mClass) ? 1 : -1);
        this.mColor = in.hasAttribute(ATTR_COLOR) ? Integer.valueOf(in.getIntegerAttribute(ATTR_COLOR, 0)) : null;
        this.mPerCPU = in.isAttributeSet(ATTR_PER_CPU, in.isAttributeSet("per_core", category.isPerCPU()));
        this.mSeriesComposition = in.getAttribute(ATTR_SERIES_COMPOSITION, "");
        this.mRenderingType = in.getAttribute(ATTR_RENDERING_TYPE, "");
        this.mRegex = in.getAttribute(ATTR_REGEX);
        this.mTracepoint = in.getAttribute(ATTR_TRACEPOINT);
        this.mArg = in.getAttribute(ATTR_ARG);
        this.mDerived = in.isAttributeSet(ATTR_DERIVED, false);
        this.mProc = in.getAttribute(ATTR_PROC, Ternary.MAYBE);
        this.mAverageSelection = in.isAttributeSet(ATTR_AVERAGE_SELECTION, false);
        this.mAverageCores = in.isAttributeSet(ATTR_AVERAGE_CORES, false);
        this.mPercentage = in.isAttributeSet(ATTR_PERCENTAGE, false);
        this.mAdvanced = in.isAttributeSet(ATTR_ADVANCED, false);
        int activityId = 1;
        while (in.hasAttribute(ATTR_ACTIVITY + activityId)) {
            this.mActivity.add(in.getAttribute(ATTR_ACTIVITY + activityId, "#" + activityId));
            ++activityId;
        }
        activityId = 1;
        while (in.hasAttribute(ATTR_ACTIVITY_COLOR + activityId)) {
            this.mActivityColor.add(in.getIntegerAttribute(ATTR_ACTIVITY_COLOR + activityId));
            ++activityId;
        }
        this.mSupportsEventBasedSampling = in.isAttributeSet(ATTR_SUPPORTS_EVENT_BASED_SAMPLING, category.supportsEventBasedSampling());
        in.skip();
        if (this.mEvent == null) {
            if (this.mCounterName == null) {
                throw new BadXmlException("missing attributes counter or event");
            }
            if (this.mOptionSet != null) {
                throw new BadXmlException("option_set was given but event was missing");
            }
        }
        if (!clusterNames.isEmpty()) {
            String clusterName = (String)NullChecking.applyIfNonNull((Object)category.getCounterSetAttribute(), CounterSet::toPmuId);
            if (clusterName != null) {
                matchesCluster = clusterName::equals;
            } else if (counterName != null) {
                int metricPos = counterName.indexOf("_metric_");
                String metricPrefix = metricPos > 0 ? counterName.substring(0, metricPos) : null;
                String metricClusterName = metricPrefix != null ? ClusterNameUtils.getPrettyName(metricPrefix, true) : null;
                matchesCluster = c -> {
                    if (counterName.startsWith(c + "_")) {
                        return true;
                    }
                    if (metricClusterName != null && c.contentEquals(metricClusterName)) {
                        return true;
                    }
                    return metricClusterName != null && NullChecking.equalsNullable((Object)metricClusterName, (Object)ClusterNameUtils.getPrettyName(c, true));
                };
            } else {
                matchesCluster = cluster -> false;
            }
        } else {
            matchesCluster = cluster -> false;
        }
        ObjIntPair idAndPrettyClusterName = MapUtils.stream(clusterNames).filter(e -> matchesCluster.test((String)NullChecking.neverNull((Object)((String)e.first)))).findAny().map(e -> new ObjIntPair((Object)((String)NullChecking.neverNullOr((Object)ClusterNameUtils.getPrettyName((String)e.first), (Object)((String)e.first))), e.second)).orElse(null);
        assert (idAndPrettyClusterName != null || this.metricProperties == null || clusterNames.size() <= 1);
        this.mClusterProperties = idAndPrettyClusterName;
        this.mUseClusterForCounter = clusterNames.size() > 1;
    }

    private StockCounter(@NonNull Category category, @Nullable String counterName, @Nullable Long event, @NonNull String title, @NonNull String name, boolean perCpu, @NonNull String description, String clazz, String units, String composition, boolean averageCores, @Nullable ObjIntPair<@NonNull String> clusterProperties) {
        this.mCounterName = counterName;
        this.mEvent = event;
        this.mCategory = category;
        this.mTitle = title;
        this.mName = name;
        this.mPerCPU = perCpu;
        this.mDescription = description;
        this.metricProperties = null;
        this.cyclesCounterSet = null;
        this.mOptionSet = null;
        this.mClass = clazz != null ? clazz : "";
        this.mDisplay = "";
        this.mUnits = units != null ? units : "";
        this.mMultiplier = 1.0;
        this.mCores = -1;
        this.mColor = null;
        this.mSeriesComposition = composition != null ? composition : "";
        this.mRenderingType = "";
        this.mRegex = null;
        this.mTracepoint = null;
        this.mArg = null;
        this.mDerived = false;
        this.mProc = Ternary.MAYBE;
        this.mAverageSelection = false;
        this.mAverageCores = averageCores;
        this.mPercentage = false;
        this.mAdvanced = false;
        this.mSupportsEventBasedSampling = category.supportsEventBasedSampling();
        this.mClusterProperties = clusterProperties;
        this.mUseClusterForCounter = clusterProperties != null;
    }

    public void addAdditionalAttributes(@NonNull XMLGenerator xml) throws IOException {
        if (this.mCores > 0) {
            xml.addAttribute(ATTR_CORES, this.mCores);
        }
    }

    @Override
    public int compareTo(StockCounter other) {
        int result = NumericStringComparator.caselessCompareStrings((String)this.getTitle(), (String)other.getTitle());
        if (result == 0) {
            result = NumericStringComparator.caselessCompareStrings((String)this.getName(), (String)other.getName());
        }
        return result;
    }

    public @NonNull List<@NonNull String> getActivity() {
        return this.mActivity;
    }

    public @NonNull Set<@NonNull String> getActivityAliases(boolean ignoreCluster) {
        return this.mActivity.stream().map(a -> {
            ObjIntPair<String> cp = this.getClusterProperties(true);
            Integer cluster = cp != null && !ignoreCluster ? Integer.valueOf(cp.second) : null;
            return CounterRecord.getAlias(this.getTitle(), a, cluster, this.getDeviceInstance());
        }).collect(Collectors.toSet());
    }

    public @NonNull TIntArrayList getActivityColor() {
        return this.mActivityColor;
    }

    public @NonNull Stream<@NonNull Combination> getAllCombinations() {
        return this.getAllCounterSets().stream().flatMap(counterSet -> this.getAllOptions().stream().map(option -> new Combination(this, (Option)option, (CounterSet)counterSet)));
    }

    public @NonNull Stream<@NonNull ? extends Collection<@NonNull String>> getAllCounterNamesInSets() {
        String counterName = this.getCounterName();
        if (counterName == null) {
            return this.getCategory().getCounterSets().stream();
        }
        return Stream.of(Collections.singleton(counterName));
    }

    public @NonNull Collection<? extends @Nullable CounterSet> getAllCounterSets() {
        if (this.mCounterName != null) {
            return Collections.singleton(null);
        }
        return this.getCategory().getCounterSets();
    }

    public @NonNull Collection<? extends @Nullable Option> getAllOptions() {
        @Nullable OptionSet optionSet = this.getOptionSet();
        if (optionSet != null) {
            return optionSet.getOptions();
        }
        return Collections.singleton(null);
    }

    public @NonNull Set<@NonNull String> getAllTargetCountersKeys() {
        @NonNull HashSet<@NonNull String> keys = new HashSet<String>();
        @Nullable String counterName = this.mCounterName;
        @Nullable Long event = this.mEvent;
        if (counterName != null) {
            keys.add(TargetCounter.computeKey(counterName));
        } else if (event != null) {
            for (CounterSet set : this.mCategory.getCounterSets()) {
                for (String one : set) {
                    @Nullable OptionSet optionSet = this.mOptionSet;
                    if (optionSet != null) {
                        for (Option option : optionSet.getOptions()) {
                            keys.add(TargetCounter.computeKey(one, option.calculateEventCode(event)));
                        }
                        continue;
                    }
                    keys.add(TargetCounter.computeKey(one, (long)event));
                }
            }
        }
        return keys;
    }

    public String getArg() {
        return this.mArg;
    }

    public @NonNull Category getCategory() {
        return this.mCategory;
    }

    public @Nullable ObjIntPair<@NonNull String> getClusterProperties(boolean forCounterUse) {
        if (forCounterUse && !this.mUseClusterForCounter) {
            return null;
        }
        return this.mClusterProperties;
    }

    public Integer getColor() {
        return this.mColor;
    }

    public int getCores() {
        return this.mCores;
    }

    public String getCounterClass() {
        return this.mClass;
    }

    public @Nullable String getCounterName() {
        return this.mCounterName;
    }

    public @NonNull Stream<@NonNull String> getCounterNames(@Nullable CounterSet counterSet) {
        String counterName = this.getCounterName();
        if (counterSet != null) {
            return counterSet.stream();
        }
        if (counterName != null) {
            return Stream.of(counterName);
        }
        return Stream.empty();
    }

    public @Nullable CounterSet getCyclesCounterSet() {
        return this.cyclesCounterSet;
    }

    @Override
    public @NonNull String getDescription() {
        return this.mDescription;
    }

    public @Nullable String getDeviceInstance() {
        return this.mCategory.getDeviceInstance();
    }

    public @NonNull String getDisplay() {
        return this.mDisplay;
    }

    public @NonNull String getDisplayTitle() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getTitle());
        buffer.append(": ");
        buffer.append(this.getName());
        return buffer.toString();
    }

    public @Nullable Long getEvent() {
        return this.mEvent;
    }

    public @Nullable MetricProperties getMetricProperties() {
        return this.metricProperties;
    }

    public double getMultiplier() {
        return this.mMultiplier;
    }

    public @NonNull String getName() {
        return this.mName;
    }

    public @Nullable OptionSet getOptionSet() {
        return this.mOptionSet;
    }

    public @NonNull String getQualifiedName(@Nullable Option option, @Nullable CounterSet counterSet) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getName());
        if (option != null) {
            buffer.append(" (");
            buffer.append(option.getName());
            buffer.append(")");
        }
        if (counterSet != null && this.mCategory.getCounterSets().size() > 1) {
            buffer.append(" (");
            buffer.append(counterSet.getTitle());
            buffer.append(")");
        }
        return buffer.toString();
    }

    public String getRegex() {
        return this.mRegex;
    }

    public String getRenderingType() {
        return this.mRenderingType;
    }

    public String getSeriesComposition() {
        return this.mSeriesComposition;
    }

    public @NonNull String getTitle() {
        return this.mTitle;
    }

    @Override
    public @NonNull String getTitleNameEvent() {
        StringBuilder buffer = new StringBuilder(this.mTitle + ": " + this.mName);
        if (this.mEvent != null) {
            buffer.append(String.format(" (0x%02x)", this.mEvent));
        }
        return buffer.toString();
    }

    public String getTracepoint() {
        return this.mTracepoint;
    }

    public @NonNull String getUniqueSourceName(@Nullable Option option, @Nullable CounterSet counterSet, boolean ignoreCluster) {
        ObjIntPair<String> cp = this.getClusterProperties(true);
        Integer cluster = cp != null && !ignoreCluster ? Integer.valueOf(cp.second) : null;
        return CounterRecord.getAlias(this.getTitle(), this.getQualifiedName(option, counterSet), cluster, this.getDeviceInstance());
    }

    public String getUnits() {
        return this.mUnits;
    }

    public boolean isAdvanced() {
        return this.mAdvanced;
    }

    public boolean isAverageCores() {
        return this.mAverageCores;
    }

    public boolean isAverageSelection() {
        return this.mAverageSelection;
    }

    public boolean isDerived() {
        return this.mDerived;
    }

    public boolean isDynamic() {
        return this.mCategory.isDynamic();
    }

    public boolean isPercentage() {
        return this.mPercentage;
    }

    public boolean isPerCPU() {
        return this.mPerCPU;
    }

    public @NonNull Ternary isProc() {
        return this.mProc;
    }

    public boolean isValid(@NonNull Predicate<@NonNull String> validCounterPredicate) {
        if (this.mCounterName != null && validCounterPredicate.test(this.mCounterName)) {
            return true;
        }
        for (CounterSet set : this.mCategory.getCounterSets()) {
            for (String one : set) {
                if (!validCounterPredicate.test(one)) continue;
                return true;
            }
        }
        return false;
    }

    public void setAverageSelection(boolean averageSelection) {
        this.mAverageSelection = averageSelection;
    }

    public void setColor(int color) {
        this.mColor = color;
    }

    public void setDerived(boolean derived) {
        this.mDerived = derived;
    }

    public void setMultiplier(double multiplier) {
        this.mMultiplier = multiplier;
    }

    public void setPercentage(boolean percentage) {
        this.mPercentage = percentage;
    }

    public void setRenderingType(String renderingType) {
        this.mRenderingType = renderingType;
    }

    public boolean supportsEventBasedSampling() {
        return this.mSupportsEventBasedSampling;
    }

    public String toString() {
        return this.getTitleNameEvent();
    }

    public static class Combination {
        public final @Nullable CounterSet counterSet;
        public final @Nullable Option option;
        public final @NonNull StockCounter stockCounter;

        public Combination(@NonNull StockCounter stockCounter, @Nullable Option option, @Nullable CounterSet counterSet) {
            this.stockCounter = stockCounter;
            this.option = option;
            this.counterSet = counterSet;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Combination other = (Combination)obj;
            if (!NullChecking.equalsNullable((Object)this.counterSet, (Object)other.counterSet)) {
                return false;
            }
            if (!NullChecking.equalsNullable((Object)this.option, (Object)other.option)) {
                return false;
            }
            return this.stockCounter.equals(other.stockCounter);
        }

        public @NonNull Set<@NonNull String> getActivityAliases() {
            return Collections.unmodifiableSet(this.stockCounter.getActivityAliases(false));
        }

        public @NonNull String getUniqueSourceName() {
            return this.stockCounter.getUniqueSourceName(this.option, this.counterSet, false);
        }

        public @NonNull String getUniqueSourceNameIgnoringCluster() {
            return this.stockCounter.getUniqueSourceName(this.option, this.counterSet, true);
        }

        public @NonNull String getUniqueSourceNameWithFriendlyClusterName() {
            ObjIntPair<String> cp = this.stockCounter.getClusterProperties(true);
            String cluster = cp != null ? (String)cp.first : null;
            return this.stockCounter.getUniqueSourceName(this.option, this.counterSet, cluster != null) + (cluster != null ? String.format(" (%s)", cluster) : "");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.counterSet != null ? this.counterSet.hashCode() : 0);
            result = 31 * result + (this.option != null ? this.option.hashCode() : 0);
            result = 31 * result + this.stockCounter.hashCode();
            return result;
        }

        public String toString() {
            return "Combination [counterSet=" + String.valueOf(this.counterSet) + ", option=" + String.valueOf(this.option) + ", stockCounter=" + String.valueOf(this.stockCounter) + "]";
        }
    }

    public record MetricProperties(boolean usesCycles, int numEvents, @Nullable CounterSet counterSet) {
    }
}

