/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.xml.counters;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.ClusterNameUtils;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.counters.BadXmlException;
import com.arm.streamline.common.xml.counters.CounterSet;
import com.arm.streamline.common.xml.counters.OptionSet;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.ObjBoolPair;
import com.arm.utils.collections.ObjIntPair;
import com.arm.utils.text.NumericStringComparator;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Category
extends ArrayList<StockCounter>
implements Comparable<Category> {
    private static final String TAG_EVENT = "event";
    private static final String TAG_COUNTER_SET = "counter_set";
    private static final String TAG_OPTION_SET = "option_set";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_COUNTER = "counter";
    private static final String ATTR_COUNTER_SET = "counter_set";
    private static final String ATTR_PER_CPU = "per_cpu";
    private static final String ATTR_SUPPORTS_EVENT_BASED_SAMPLING = "supports_event_based_sampling";
    private static final String ATTR_DEVICE_INSTANCE = "device_instance";
    private static final String ATTR_DDK_VERSION = "ddk_version";
    private static final Set<String> mExclude = new HashSet<String>();
    private static final @NonNull Pattern DYNAMIC_PATTERN = Pattern.compile("(Atrace|Ttrace)");
    private static final String GPU_TIMELINE_COUNTER_NAME = "MaliTimeline_Perfetto";
    private final @NonNull String mName;
    private final @Nullable String mDeviceInstance;
    private final @Nullable String mCounterSet;
    private final @NonNull List<@NonNull CounterSet> mCounterSets = new ArrayList<CounterSet>();
    private final @NonNull Map<@NonNull String, @NonNull OptionSet> mOptionSets = new HashMap<String, OptionSet>();
    private final boolean mPerCPU;
    private final boolean mSupportsEventBasedSampling;
    private final boolean mIsDynamic;
    private @Nullable String mMaliDdkVersion;
    private final @Nullable ObjIntPair<@NonNull String> clusterProperties;

    static {
        mExclude.add("Linux_meminfo_memused2");
        mExclude.add("ARM_Mali-Midgard_Filmstrip2_cnt0");
        mExclude.add("ARM_Mali-Midgard_FRAG_QUADS_LZS_TEST");
        mExclude.add("ARM_Mali-Midgard_FRAG_QUADS_LZS_KILLED");
        mExclude.add("ARM_Mali-Midgard_FRAG_PRIMATIVES");
        mExclude.add("ARM_Mali-Midgard_FRAG_PRIMATIVES_DROPPED");
    }

    public Category(@NonNull String name, boolean perCpu, boolean supportsEventBasedSampling) {
        this(name, perCpu, supportsEventBasedSampling, null, null);
    }

    public Category(@NonNull String name, boolean perCpu, boolean supportsEventBasedSampling, @Nullable CounterSet counterSet, @Nullable String deviceInstance) {
        this.mName = name;
        this.mDeviceInstance = deviceInstance;
        if (counterSet != null) {
            this.mCounterSet = counterSet.getName();
            this.mCounterSets.add(counterSet);
        } else {
            this.mCounterSet = null;
        }
        this.mPerCPU = perCpu;
        this.mSupportsEventBasedSampling = supportsEventBasedSampling;
        this.mIsDynamic = false;
        this.clusterProperties = null;
    }

    public Category(@NonNull XMLParser in, @Nullable Predicate<@NonNull String> validCounterPredicate, @NonNull Map<String, CounterSet> globalCounterSets, @NonNull TIntObjectMap<String> clusters) throws IOException {
        String tag;
        HashSet<String> names = new HashSet<String>();
        this.mName = in.getAttribute(ATTR_NAME, "");
        this.mDeviceInstance = NullChecking.nullIfBlank((String)in.getAttribute(ATTR_DEVICE_INSTANCE));
        if (in.hasAttribute("counter_set")) {
            this.mCounterSet = in.getAttribute("counter_set");
            CounterSet set = globalCounterSets.get(this.mCounterSet);
            if (set != null) {
                this.mCounterSets.add(set);
            }
        } else {
            this.mCounterSet = null;
        }
        this.mPerCPU = in.isAttributeSet(ATTR_PER_CPU, false);
        this.mSupportsEventBasedSampling = in.isAttributeSet(ATTR_SUPPORTS_EVENT_BASED_SAMPLING, false);
        this.mIsDynamic = DYNAMIC_PATTERN.matcher(this.mName).matches();
        String marker = in.getMarker();
        while ((tag = in.nextTag(marker)) != null) {
            try {
                Object set;
                if ("counter_set".equals(tag)) {
                    set = new CounterSet(in, validCounterPredicate);
                    this.mCounterSets.add((CounterSet)set);
                    continue;
                }
                if (TAG_OPTION_SET.equals(tag)) {
                    set = new OptionSet(in);
                    this.mOptionSets.put(((OptionSet)set).getName(), (OptionSet)set);
                    continue;
                }
                if (TAG_EVENT.equals(tag)) {
                    String counterAttr;
                    String string = counterAttr = in.hasAttribute(ATTR_COUNTER) ? in.getAttribute(ATTR_COUNTER) : null;
                    if (counterAttr != null && counterAttr.equals(GPU_TIMELINE_COUNTER_NAME) && in.hasAttribute(ATTR_DDK_VERSION)) {
                        this.mMaliDdkVersion = in.getAttribute(ATTR_DDK_VERSION);
                    }
                    StockCounter counter = new StockCounter(in, this, clusters, id -> {
                        if (!((String)id).endsWith("_cnt")) {
                            id = (String)id + "_cnt";
                        }
                        for (CounterSet cs : this.mCounterSets) {
                            if (!((String)id).contentEquals(cs.getName())) continue;
                            return cs;
                        }
                        return (CounterSet)globalCounterSets.get(id);
                    });
                    if (validCounterPredicate == null || counter.isValid(validCounterPredicate)) {
                        this.add(counter);
                    }
                    this.checkForDupes(names, counter);
                    continue;
                }
                in.skip();
            }
            catch (BadXmlException exception) {
                CommonPlugin.error(exception);
            }
        }
        ObjIntPair matchingClusterProperties = null;
        if (!clusters.isEmpty()) {
            String clusterNameFromAttrib = (String)NullChecking.applyIfNonNull((Object)this.mCounterSet, CounterSet::toPmuId);
            String prettyClusterNameFromAttrib = ClusterNameUtils.getArchName(clusterNameFromAttrib);
            TIntObjectIterator it = clusters.iterator();
            while (it.hasNext()) {
                it.advance();
                int id2 = it.key();
                String name = (String)it.value();
                if (!(clusterNameFromAttrib != null && name.contentEquals(clusterNameFromAttrib) || prettyClusterNameFromAttrib != null && name.contentEquals(prettyClusterNameFromAttrib)) && !name.contentEquals(this.mName)) continue;
                if (matchingClusterProperties == null) {
                    matchingClusterProperties = new ObjIntPair((Object)((String)NullChecking.neverNullOr((Object)ClusterNameUtils.getArchName(name), (Object)name)), id2);
                    continue;
                }
                matchingClusterProperties = null;
                break;
            }
        }
        this.clusterProperties = matchingClusterProperties;
        Collections.sort(this);
        Collections.sort(this.mCounterSets);
    }

    public boolean isDynamic() {
        return this.mIsDynamic;
    }

    @Override
    public int compareTo(Category other) {
        String pmuNameB;
        ObjBoolPair<String> archAndFlagB;
        boolean isArmCPUB;
        ObjBoolPair<String> archAndFlagA = this.getNameForArchCheck();
        boolean isArmCPUA = archAndFlagA != null ? archAndFlagA.second : false;
        int result = Boolean.compare(isArmCPUA, isArmCPUB = (archAndFlagB = other.getNameForArchCheck()) != null ? archAndFlagB.second : false);
        if (result != 0) {
            return -result;
        }
        String pmuNameA = archAndFlagA != null ? (String)archAndFlagA.first : null;
        String string = pmuNameB = archAndFlagB != null ? (String)archAndFlagB.first : null;
        if (pmuNameA == null) {
            if (pmuNameB == null) {
                boolean isUncoreB;
                boolean isMaliB;
                boolean isMaliA = ClusterNameUtils.isMaliOrImmortalis(this.mName);
                result = Boolean.compare(isMaliA, isMaliB = ClusterNameUtils.isMaliOrImmortalis(other.mName));
                if (result != 0) {
                    return -result;
                }
                boolean isUncoreA = ClusterNameUtils.isUncore(this.mName);
                result = Boolean.compare(isUncoreA, isUncoreB = ClusterNameUtils.isUncore(other.mName));
                if (result != 0) {
                    return -result;
                }
                return NumericStringComparator.caselessCompareStrings((String)this.mName, (String)other.mName);
            }
            return 1;
        }
        if (pmuNameB == null) {
            return -1;
        }
        result = NumericStringComparator.caselessCompareStrings((String)pmuNameA, (String)pmuNameB);
        if (result != 0) {
            return result;
        }
        return NumericStringComparator.caselessCompareStrings((String)this.mName, (String)other.mName);
    }

    private @Nullable ObjBoolPair<@NonNull String> getNameForArchCheck() {
        return Category.getNameForArchCheck(this.mCounterSet, this.mName);
    }

    private static @Nullable ObjBoolPair<@NonNull String> getNameForArchCheck(@Nullable String counterSet, @NonNull String prettyName) {
        String archName;
        if (counterSet != null && (archName = ClusterNameUtils.getArchName(counterSet)) != null) {
            return new ObjBoolPair((Object)archName, ClusterNameUtils.isArmCortexOrNeoverse(counterSet));
        }
        archName = ClusterNameUtils.getArchName(prettyName = prettyName.replaceAll("^([^:]+):.*$", "$1"));
        if (archName != null) {
            return new ObjBoolPair((Object)archName, ClusterNameUtils.isArmCortexOrNeoverse(prettyName));
        }
        return null;
    }

    public @Nullable StockCounter findCounterByEvent(long eventNo) {
        for (StockCounter counter : this) {
            @Nullable Long event = counter.getEvent();
            if (event == null || event != eventNo) continue;
            return counter;
        }
        return null;
    }

    public @Nullable StockCounter findCounterByTracepoint(@NonNull String tracepoint) {
        for (StockCounter counter : this) {
            String counterTracepoint = counter.getTracepoint();
            if (counterTracepoint == null || !counterTracepoint.equals(tracepoint)) continue;
            return counter;
        }
        return null;
    }

    public @Nullable CounterSet getCounterSet(String key) {
        int index = key.indexOf(58);
        if (index != -1) {
            key = key.substring(0, index);
        }
        for (CounterSet set : this.mCounterSets) {
            for (String one : set) {
                if (!one.equals(key)) continue;
                return set;
            }
        }
        return null;
    }

    public @Nullable String getCounterSetAttribute() {
        return this.mCounterSet;
    }

    public @NonNull List<@NonNull CounterSet> getCounterSets() {
        return this.mCounterSets;
    }

    public @NonNull String getName() {
        return this.mName;
    }

    public @Nullable String getDeviceInstance() {
        return this.mDeviceInstance;
    }

    public @Nullable OptionSet getOptionSet(@NonNull String key) {
        return this.mOptionSets.get(key);
    }

    public @Nullable String getMaliDdkVersion() {
        return this.mMaliDdkVersion;
    }

    public boolean isPerCPU() {
        return this.mPerCPU;
    }

    public boolean supportsEventBasedSampling() {
        return this.mSupportsEventBasedSampling;
    }

    @Override
    public String toString() {
        return String.format("%s = %s", this.getName(), super.toString());
    }

    private void checkForDupes(Set<String> names, StockCounter counter) {
        if (mExclude.contains(counter.getCounterName())) {
            return;
        }
        StringBuilder nameBuilder = new StringBuilder();
        @Nullable OptionSet optionSet = counter.getOptionSet();
        if (optionSet != null) {
            nameBuilder.append(optionSet.getName()).append("|");
        }
        nameBuilder.append(counter.getTitle()).append(": ").append(counter.getName());
        String name = nameBuilder.toString();
        if (!names.contains(name)) {
            names.add(name);
        }
    }

    public @Nullable ObjIntPair<@NonNull String> getClusterProperties() {
        return this.clusterProperties;
    }
}

