/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.widget;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.io.StdLog;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;

public class CommonError {
    public static void show(Plugin plugin, String pluginId, String message) {
        CommonError.show(plugin, pluginId, message, null, false);
    }

    public static void show(Plugin plugin, String pluginId, String message, boolean logAsWell) {
        CommonError.show(plugin, pluginId, message, null, logAsWell);
    }

    public static void show(Plugin plugin, final String pluginId, final String message, Throwable throwable, boolean logAsWell) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        final Throwable throwableForOutput = throwable;
        boolean headless = WorkspaceUtils.isHeadless();
        if (headless) {
            logAsWell = true;
        }
        if (logAsWell) {
            StdLog.log(4, plugin, message, throwableForOutput);
        }
        if (!headless) {
            Task.blockingCallOnUIThread(new Runnable(){

                @Override
                @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"})
                public void run() {
                    if (throwableForOutput != null) {
                        StringWriter buffer = new StringWriter();
                        throwableForOutput.printStackTrace(new PrintWriter(buffer));
                        ArrayList<Status> statuses = new ArrayList<Status>();
                        String[] stringArray = buffer.toString().split(System.getProperty("line.separator"));
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String line = stringArray[n2];
                            statuses.add(new Status(4, pluginId, line));
                            ++n2;
                        }
                        String msg = message == null ? throwableForOutput.getLocalizedMessage() : message;
                        Status[] array = statuses.toArray(new Status[0]);
                        MultiStatus status = new MultiStatus(pluginId, 4, (IStatus[])array, msg, null);
                        ErrorDialog.openError(null, null, null, (IStatus)status);
                    } else {
                        ErrorDialog.openError(null, null, null, (IStatus)new Status(4, pluginId, message));
                    }
                }
            });
        }
    }

    public static void show(Plugin plugin, String pluginId, Throwable throwable) {
        CommonError.show(plugin, pluginId, null, throwable, false);
    }

    public static void show(Plugin plugin, String pluginId, Throwable throwable, boolean logAsWell) {
        CommonError.show(plugin, pluginId, null, throwable, logAsWell);
    }
}

