/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility.text;

import com.arm.streamline.common.utility.text.TextMessages;
import com.arm.utils.text.BasicNumberUtils;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class NumberUtils
extends BasicNumberUtils {
    public static final int DOUBLE_MAX_EXPONENT_10 = (int)Math.floor(Math.log10(Double.MAX_VALUE));
    public static final int DOUBLE_MIN_EXPONENT_10 = (int)Math.floor(Math.log10(Double.MIN_NORMAL));
    private static final String SEPARATOR = " ";
    private static final NumberFormat NUMBER_FORMAT;
    private static final NumberFormat PRETTY_FORMATTER;
    private static final NumberFormat TRUNCATE_FORMATTER;
    private static final NumberFormat NUMBER_FORMAT_NO_GROUPING;
    private static final long KIBI = 1024L;
    private static final long MEBI = 0x100000L;
    private static final long GIBI = 0x40000000L;
    private static final long TEBI = 0x10000000000L;
    private static final @NonNull ThreadLocal<@NonNull NumberFormat> PARSER;

    static {
        PARSER = ThreadLocal.withInitial(NumberFormat::getInstance);
        NUMBER_FORMAT = NumberFormat.getNumberInstance();
        NUMBER_FORMAT.setMaximumFractionDigits(13);
        NUMBER_FORMAT.setRoundingMode(RoundingMode.DOWN);
        PRETTY_FORMATTER = NumberFormat.getNumberInstance();
        PRETTY_FORMATTER.setMinimumFractionDigits(2);
        PRETTY_FORMATTER.setMaximumFractionDigits(2);
        TRUNCATE_FORMATTER = NumberFormat.getNumberInstance();
        TRUNCATE_FORMATTER.setMinimumFractionDigits(0);
        TRUNCATE_FORMATTER.setMaximumFractionDigits(2);
        NUMBER_FORMAT_NO_GROUPING = NumberFormat.getNumberInstance();
        NUMBER_FORMAT_NO_GROUPING.setMaximumFractionDigits(13);
        NUMBER_FORMAT_NO_GROUPING.setRoundingMode(RoundingMode.DOWN);
        NUMBER_FORMAT_NO_GROUPING.setGroupingUsed(false);
    }

    public static double calculateLimit(double value, boolean useKibi) {
        double scale = 1.0;
        double v = value;
        if (!Double.isFinite(value)) {
            return 0.0;
        }
        double multiplier = useKibi ? 1024.0 : 1000.0;
        while (v > 0.0 && v < 1.0) {
            v *= multiplier;
            scale /= multiplier;
        }
        if (value <= 10.0) {
            v = Math.ceil(v);
        }
        while (v >= multiplier) {
            v /= multiplier;
            scale *= multiplier;
        }
        v = v <= 2.0 ? Math.ceil(v * 10.0) / 10.0 : (v <= 5.0 ? Math.ceil(v * 2.0) / 2.0 : (v <= 10.0 ? Math.ceil(v) : (v <= 50.0 ? Math.ceil(v / 5.0) * 5.0 : (v <= 100.0 ? Math.ceil(v / 10.0) * 10.0 : (v <= 500.0 ? Math.ceil(v / 50.0) * 50.0 : (v <= 900.0 ? Math.ceil(v / 100.0) * 100.0 : multiplier))))));
        return v * scale;
    }

    public static final String fill(int count, char ch) {
        StringBuilder buffer = new StringBuilder(count);
        int i = 0;
        while (i < count) {
            buffer.append(ch);
            ++i;
        }
        return buffer.toString();
    }

    public static @NonNull String format(long value) {
        return NUMBER_FORMAT.format(value);
    }

    public static @NonNull String formatUngrouped(long value) {
        return NUMBER_FORMAT_NO_GROUPING.format(value);
    }

    public static String formatAddress(int address) {
        return NumberUtils.formatHex(address, 8, true);
    }

    public static String formatAddress(long address) {
        return NumberUtils.formatHex(address, address < 0L || address > 0xFFFFFFFFL ? 16 : 8, true);
    }

    public static @NonNull String formatOpcode(byte @NonNull [] opCode, boolean thumb, boolean arm) {
        if (thumb) {
            assert (opCode.length == 2 || opCode.length == 4);
            if (opCode.length == 2) {
                return String.format("%02x%02x", opCode[1], opCode[0]);
            }
            if (opCode.length == 4) {
                return String.format("%02x%02x %02x%02x", opCode[1], opCode[0], opCode[3], opCode[2]);
            }
        }
        if (arm) {
            assert (opCode.length == 4);
            if (opCode.length == 4) {
                return String.format("%02x%02x%02x%02x", opCode[3], opCode[2], opCode[1], opCode[0]);
            }
        }
        StringBuilder result = new StringBuilder(opCode.length * 3);
        byte[] byArray = opCode;
        int n = opCode.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (!result.isEmpty()) {
                result.append(' ');
            }
            result.append(String.format("%02x", b));
            ++n2;
        }
        return result.toString();
    }

    public static String formatHex(int value, int pad, boolean prefix) {
        return NumberUtils.formatWithPad(prefix ? "0x" : null, Integer.toHexString(value).toUpperCase(), pad);
    }

    public static String formatHex(long value, int pad, boolean prefix) {
        return NumberUtils.formatWithPad(prefix ? "0x" : null, Long.toHexString(value).toUpperCase(), pad);
    }

    public static final @NonNull String formatPercentage(double value, boolean wholeNumbersOnly) {
        if (Double.isInfinite(value)) {
            return "\u221e";
        }
        if (value < 0.0 || Double.isNaN(value)) {
            return "-";
        }
        if (wholeNumbersOnly) {
            return Integer.toString((int)Math.round(value)) + "%";
        }
        if (value < 0.01 && value > 0.0) {
            return "< 0.01%";
        }
        if (value < 100.0 && value >= 99.995) {
            return "> 99.99%";
        }
        return PRETTY_FORMATTER.format(value) + "%";
    }

    public static @NonNull String formatInSiUnits(double value, double precision, boolean longFormat) {
        @NonNull SiPrefix bestPrefix = SiPrefix.bestFor(precision);
        @NonNull String number = NumberUtils.formatWithPrecision(value / bestPrefix.factor, precision / bestPrefix.factor, false);
        if (longFormat) {
            return number + SEPARATOR + bestPrefix.text;
        }
        return number + bestPrefix.symbol;
    }

    public static double parseTime(@NonNull String string) throws ParseException {
        @NonNull String @NonNull [] parts = string.split(":");
        if (parts.length > TimeUnits.values().length || string.endsWith(":")) {
            throw new ParseException("Unexpected ':'", string.lastIndexOf(58));
        }
        double result = 0.0;
        NumberFormat parser = PARSER.get();
        boolean negative = false;
        int i = parts.length - 1;
        while (i >= 0) {
            double value = parser.parse(parts[i].trim()).doubleValue();
            if (value < 0.0) {
                if (negative) {
                    throw new ParseException("Unexpected '-'", string.lastIndexOf(45));
                }
                negative = true;
            }
            result += Math.abs(value) * (double)TimeUnits.values()[i + TimeUnits.values().length - parts.length].factor;
            --i;
        }
        return negative ? -result : result;
    }

    public static double parse(@NonNull String string) throws ParseException {
        return PARSER.get().parse(string).doubleValue();
    }

    public static final String formatTime(double seconds) {
        return NumberUtils.formatTime(seconds, 0.0, true, true, false);
    }

    public static final int formatTimeMaxLength(double seconds, double precision, boolean addUnits, boolean longFormat) {
        int signLength = seconds < 0.0 ? 1 : 0;
        seconds = Math.abs(seconds);
        int length = 0;
        long lsec = (long)Math.floor(seconds);
        @NonNull TimeUnits @NonNull [] units = TimeUnits.values();
        int i = 0;
        while (i < units.length - 1) {
            length = NumberUtils.maxUnit(lsec, length, units[i], i == 0 ? null : units[i - 1], longFormat, addUnits);
            ++i;
        }
        TimeUnits unit = units[units.length - 1];
        seconds = length == 0 ? (seconds %= (double)units[units.length - 2].factor) : (double)units[units.length - 2].factor;
        length += NumberUtils.formatWithPrecisionMaxLength(seconds / (double)unit.factor, precision / (double)unit.factor);
        if (addUnits) {
            length = longFormat ? (length += 1 + unit.textMany.length()) : (length += unit.symbol.length());
        }
        return signLength + length;
    }

    public static final @NonNull String formatTime(double seconds, double precision, boolean addUnits, boolean longFormat, boolean pad) {
        String sign = seconds < 0.0 ? "-" : "";
        seconds = Math.abs(seconds);
        StringBuilder builder = new StringBuilder();
        long lsec = (long)Math.floor(seconds);
        @NonNull TimeUnits @NonNull [] units = TimeUnits.values();
        seconds -= (double)lsec;
        int i = 0;
        while (i < units.length - 1) {
            lsec = NumberUtils.portion(lsec, builder, units[i], longFormat, addUnits);
            ++i;
        }
        TimeUnits unit = units[units.length - 1];
        String secondsString = NumberUtils.formatWithPrecision((seconds += (double)lsec) / (double)unit.factor, precision / (double)unit.factor, pad);
        if (!addUnits || builder.length() == 0 || !secondsString.equals("0")) {
            if (addUnits && longFormat && builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(secondsString);
            if (addUnits) {
                if (longFormat) {
                    builder.append(' ');
                    builder.append(secondsString.equals("1") ? unit.textOne : unit.textMany);
                } else {
                    builder.append(unit.symbol);
                }
            }
        }
        return sign + builder.toString();
    }

    public static String formatWithPad(String prefix, String value, int pad) {
        int length;
        StringBuilder builder = new StringBuilder(pad + (prefix != null ? prefix.length() : 0));
        if (prefix != null) {
            builder.append(prefix);
        }
        if ((length = value.length()) < pad) {
            int i = length;
            while (i < pad) {
                builder.append('0');
                ++i;
            }
        } else if (length > pad) {
            value = value.substring(length - pad);
        }
        builder.append(value);
        return builder.toString();
    }

    public static String getByteUnits(long value) {
        if (value < 1024L) {
            return "B";
        }
        if (value < 0x100000L) {
            return "KB";
        }
        if (value < 0x40000000L) {
            return "MB";
        }
        if (value < 0x10000000000L) {
            return "GB";
        }
        return "TB";
    }

    public static String getByteValueInSignificantDigits(long value) {
        int zerosToAdd;
        if (value < 0L) {
            return "-";
        }
        if (value < 1024L) {
            return Long.toString(value);
        }
        long divisor = value < 0x100000L ? 1024L : (value < 0x40000000L ? 0x100000L : (value < 0x10000000000L ? 0x40000000L : 0x10000000000L));
        Object result = Double.toString((double)Math.round((double)value / (double)divisor) * 100.0 / 100.0);
        int dot = ((String)result).indexOf(46);
        if (dot != -1 && (zerosToAdd = 2 - (((String)result).length() - 1 - dot)) > 0) {
            result = (String)result + NumberUtils.fill(zerosToAdd, '0');
        }
        return result;
    }

    public static int getLocalizedInteger(String buffer, int defValue) {
        try {
            return NUMBER_FORMAT.parse(NumberUtils.strip((String)buffer)).intValue();
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static final @NonNull String prettyFormat(double value) {
        if (value < 0.0 || Double.isNaN(value)) {
            return "-";
        }
        return NumberUtils.adjustForLessThanVisiblePrecision(PRETTY_FORMATTER.format(value), value);
    }

    public static @NonNull String prettyFormat(double value, int fractionalDigits, boolean round) {
        if (value < 0.0 || Double.isNaN(value)) {
            return "-";
        }
        return NumberUtils.adjustForLessThanVisiblePrecision(NumberUtils.format(value, fractionalDigits, round), value);
    }

    public static @NonNull String prettyFormatUngrouped(double value, int fractionalDigits, boolean round) {
        if (value < 0.0 || Double.isNaN(value)) {
            return "-";
        }
        return NumberUtils.adjustForLessThanVisiblePrecision(NumberUtils.format(value, fractionalDigits, round, false), value);
    }

    public static int formatWithPrecisionMaxLength(double value, double precision) {
        int maxFractionalDigits;
        int minFractionalDigits = maxFractionalDigits = Math.max(0, -NumberUtils.getExponent10(precision));
        return NumberUtils.getFormatter((int)minFractionalDigits, (int)maxFractionalDigits).format(value).length();
    }

    public static @NonNull String formatWithPrecision(double value, double precision, boolean pad) {
        int maxFractionalDigits = Math.max(0, -NumberUtils.getExponent10(precision));
        int minFractionalDigits = pad ? maxFractionalDigits : 0;
        return NumberUtils.getFormatter((int)minFractionalDigits, (int)maxFractionalDigits).format(value);
    }

    public static @NonNull String format(double value, int fractionalDigits, boolean round) {
        return NumberUtils.format(value, fractionalDigits, round, true);
    }

    public static @NonNull String format(double value, int fractionalDigits, boolean round, boolean localised) {
        Object resultNeedingPadding;
        char dotChar;
        int dotIndex;
        if (round) {
            int powerOfTen = 1 + Math.max(fractionalDigits, 0);
            double divisor = Math.pow(10.0, powerOfTen);
            double rounding = Math.signum(value) * 5.0 / divisor;
            value += rounding;
        }
        String initial = NUMBER_FORMAT.format(value);
        if (!localised) {
            initial = NUMBER_FORMAT_NO_GROUPING.format(value);
        }
        if ((dotIndex = initial.indexOf(dotChar = DecimalFormatSymbols.getInstance().getDecimalSeparator())) != -1) {
            if (fractionalDigits <= 0) {
                return initial.substring(0, dotIndex);
            }
            if (initial.length() > dotIndex + fractionalDigits) {
                return initial.substring(0, dotIndex + fractionalDigits + 1);
            }
            resultNeedingPadding = initial;
        } else {
            if (fractionalDigits <= 0) {
                return initial;
            }
            dotIndex = initial.length();
            resultNeedingPadding = initial + dotChar;
        }
        byte[] zerosToAppend = new byte[dotIndex + fractionalDigits + 1 - ((String)resultNeedingPadding).length()];
        Arrays.fill(zerosToAppend, (byte)48);
        return ((String)resultNeedingPadding).concat(new String(zerosToAppend, StandardCharsets.US_ASCII));
    }

    public static final int getExponent10(double value) {
        if ((value = Math.abs(value)) == 0.0) {
            return DOUBLE_MIN_EXPONENT_10 - 1;
        }
        if (!Double.isFinite(value)) {
            return DOUBLE_MAX_EXPONENT_10 + 1;
        }
        double precise = Math.log10(value);
        double floor = Math.floor(precise);
        if (Math.pow(10.0, floor) > value) {
            return (int)floor - 1;
        }
        return (int)floor;
    }

    public static final @NonNull String prettyFormat(int value) {
        if (value < 0) {
            return "-";
        }
        return NumberUtils.format(value);
    }

    public static final @NonNull String prettyFormat(long value) {
        if (value < 0L) {
            return "-";
        }
        return NumberUtils.format(value);
    }

    public static final @NonNull String prettyFormatUngrouped(long value) {
        if (value < 0L) {
            return "-";
        }
        return NumberUtils.formatUngrouped(value);
    }

    public static @NonNull String trimTrailingZerosAfterDecimal(@NonNull String buffer, boolean localized) {
        int dot = (buffer = buffer.trim()).indexOf(localized ? (int)DecimalFormatSymbols.getInstance().getDecimalSeparator() : 46);
        if (dot != -1) {
            int pos = buffer.length() - 1;
            while (buffer.charAt(pos) == '0') {
                --pos;
            }
            if (dot != pos) {
                ++pos;
            }
            buffer = buffer.substring(0, pos);
        }
        return buffer;
    }

    public static final @NonNull String truncateFormat(double value) {
        if (value < 0.0 || Double.isNaN(value)) {
            return "-";
        }
        return NumberUtils.adjustForLessThanVisiblePrecision(TRUNCATE_FORMATTER.format(value), value);
    }

    private static final @NonNull String adjustForLessThanVisiblePrecision(@NonNull String buffer, double origValue) {
        if (origValue == 0.0) {
            return buffer;
        }
        int i = 0;
        while (i < buffer.length()) {
            char ch = buffer.charAt(i);
            if (ch != '0' && ch != '.') {
                return buffer;
            }
            ++i;
        }
        return "< " + buffer.substring(0, buffer.length() - 1) + "1";
    }

    private static final int maxUnit(long seconds, int length, @NonNull TimeUnits unit, @Nullable TimeUnits unitPrev, boolean longFormat, boolean addUnits) {
        if (seconds >= (long)unit.factor) {
            long maxNumber = unitPrev == null || length == 0 ? seconds / (long)unit.factor : (long)(unitPrev.factor / unit.factor);
            length += Long.toString(maxNumber).length();
            length = addUnits ? (longFormat ? (length += SEPARATOR.length() + unit.textMany.length() + SEPARATOR.length()) : (length += unit.symbol.length())) : ++length;
        }
        return length;
    }

    private static final long portion(long seconds, StringBuilder builder, @NonNull TimeUnits unit, boolean longFormat, boolean addUnits) {
        if (seconds >= (long)unit.factor) {
            if (addUnits && longFormat && builder.length() > 0) {
                builder.append(SEPARATOR);
            }
            long amt = seconds / (long)unit.factor;
            builder.append(amt);
            if (addUnits) {
                if (longFormat) {
                    builder.append(SEPARATOR);
                    builder.append(amt == 1L ? unit.textOne : unit.textMany);
                } else {
                    builder.append(unit.symbol);
                }
            } else {
                builder.append(':');
            }
            seconds %= (long)unit.factor;
        } else if (!addUnits && builder.length() > 0) {
            builder.append("0:");
        }
        return seconds;
    }

    public static enum SiPrefix {
        TERA("T", "tera", 1.0E12),
        GIGA("G", "giga", 1.0E9),
        MEGA("M", "mega", 1000000.0),
        KILO("k", "kilo", 1000.0),
        NONE("", "", 1.0),
        MILLI("m", "milli", 0.001),
        MICRO("\u03bc", "micro", 1.0E-6),
        NANO("n", "nano", 1.0E-9),
        PICO("p", "pico", 1.0E-12);

        final @NonNull String symbol;
        final @NonNull String text;
        final double factor;

        private SiPrefix(String symbol, String text, double factor) {
            this.symbol = symbol;
            this.text = text;
            this.factor = factor;
        }

        static @NonNull SiPrefix bestFor(double value) {
            SiPrefix[] siPrefixArray = SiPrefix.values();
            int n = siPrefixArray.length;
            int n2 = 0;
            while (n2 < n) {
                SiPrefix prefix = siPrefixArray[n2];
                if (value >= prefix.factor) {
                    return prefix;
                }
                ++n2;
            }
            return SiPrefix.values()[SiPrefix.values().length - 1];
        }
    }

    public static enum TimeUnits {
        DAY("d", TextMessages.DAY, TextMessages.DAYS, 86400),
        HOUR("h", TextMessages.HOUR, TextMessages.HOURS, 3600),
        MINUTE("m", TextMessages.MINUTE, TextMessages.MINUTES, 60),
        SECOND("s", TextMessages.SECOND, TextMessages.SECONDS, 1);

        public final @NonNull String symbol;
        public final @NonNull String textOne;
        public final @NonNull String textMany;
        public final int factor;

        private TimeUnits(@NonNull String symbol, String textOne, String textMany, int factor) {
            this.symbol = symbol;
            this.textOne = textOne;
            this.textMany = textMany;
            this.factor = factor;
        }
    }
}

