/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility.io;

import com.arm.streamline.common.utility.io.BufferUtils;
import com.arm.streamline.common.utility.io.StreamUtils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.NonNull;

public class LittleEndianDataOutputStream
extends DataOutputStream {
    private byte[] mBuffer = new byte[8];

    public LittleEndianDataOutputStream(@NonNull File file) throws IOException {
        super(StreamUtils.createBufferedOutput(file));
    }

    public LittleEndianDataOutputStream(OutputStream os) {
        super(os);
    }

    public LittleEndianDataOutputStream(String path) throws IOException {
        this(new File(path));
    }

    public final void writeLEDouble(double v) throws IOException {
        BufferUtils.writeLEDouble(this.mBuffer, 0, v);
        this.write(this.mBuffer, 0, 8);
    }

    public final void writeLEFloat(float v) throws IOException {
        BufferUtils.writeLEFloat(this.mBuffer, 0, v);
        this.write(this.mBuffer, 0, 4);
    }

    public final void writeLEInt(int v) throws IOException {
        BufferUtils.writeLEInt(this.mBuffer, 0, v);
        this.write(this.mBuffer, 0, 4);
    }

    public final void writeLELong(long v) throws IOException {
        BufferUtils.writeLELong(this.mBuffer, 0, v);
        this.write(this.mBuffer, 0, 8);
    }

    public final void writeLEShort(int v) throws IOException {
        BufferUtils.writeLEShort(this.mBuffer, 0, v);
        this.write(this.mBuffer, 0, 2);
    }
}

