/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility.io;

import com.arm.streamline.common.utility.io.BufferUtils;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianDataInputStream
extends DataInputStream {
    private byte[] mBuffer = new byte[8];

    public LittleEndianDataInputStream(byte[] data, boolean compressed) {
        super(BufferUtils.createInputStream(data, compressed));
    }

    public LittleEndianDataInputStream(File file) throws FileNotFoundException {
        super(new BufferedInputStream(new FileInputStream(file)));
    }

    public LittleEndianDataInputStream(InputStream is) {
        super(is);
    }

    public LittleEndianDataInputStream(String path) throws FileNotFoundException {
        super(new BufferedInputStream(new FileInputStream(path)));
    }

    public final double readLEDouble() throws IOException {
        this.readFully(this.mBuffer, 0, 8);
        return BufferUtils.readLEDouble(this.mBuffer, 0);
    }

    public final float readLEFloat() throws IOException {
        this.readFully(this.mBuffer, 0, 4);
        return BufferUtils.readLEFloat(this.mBuffer, 0);
    }

    public final int readLEInt() throws IOException {
        this.readFully(this.mBuffer, 0, 4);
        return BufferUtils.readLEInt(this.mBuffer, 0);
    }

    public final long readLELong() throws IOException {
        this.readFully(this.mBuffer, 0, 8);
        return BufferUtils.readLELong(this.mBuffer, 0);
    }

    public final short readLEShort() throws IOException {
        this.readFully(this.mBuffer, 0, 2);
        return BufferUtils.readLEShort(this.mBuffer, 0);
    }

    public final int readLEUnsignedShort() throws IOException {
        this.readFully(this.mBuffer, 0, 2);
        return BufferUtils.readLEUnsignedShort(this.mBuffer, 0);
    }
}

