/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility;

import com.arm.streamline.common.xml.pmus.EventsAndPmusXml;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.utils.NullChecking;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ClusterNameUtils {
    public static final @NonNull String OTHER = "Other";
    public static final @NonNull String OTHER_PRETTY = "Other";
    public static final @NonNull String PERF_HARDWARE = "Perf_Hardware";
    public static final @NonNull String PERF_HARDWARE_PRETTY = "Perf Hardware";
    private static final @NonNull Set<String> AMBIGUOUS_COUNTER_SET_NAMES = EventsAndPmusXml.BUILT_PMU.stream().collect(Collectors.groupingBy(pmu -> pmu.getCounterSet().toLowerCase())).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
    private static final @NonNull Set<@NonNull String> KNOWN_PMU_IDS = EventsAndPmusXml.KNOWN_PMU_IDS.stream().map(String::toLowerCase).collect(Collectors.toSet());
    private static final Pattern CORTEX_PATTERN = Pattern.compile("^(Cortex-|ARM_Cortex-|ARMv\\d+_Cortex_)");
    private static final @NonNull String CORTEX_PREFIX = "Cortex-";
    private static final Pattern NEOVERSE_PATTERN = Pattern.compile("^(Neoverse-|ARM_Neoverse-|ARMv\\d+_Neoverse_)");
    private static final @NonNull String NEOVERSE_PREFIX = "Neoverse-";
    private static final Pattern C_PATTERN = Pattern.compile("^(ARM_|ARMv\\d+_)?(C\\d+)[ _\\-]*(Pico|Nano|Pro|Premium|Ultra)?([ _\\-].*)?$");
    private static final Pattern MALI_PATTERN = Pattern.compile("^(ARM_)?(Mali|Immortalis)[ _\\-]+([GT]\\d+)([ _\\-].+)?$");
    private static final Pattern UNCORE_SIMPLE_PATTERN = Pattern.compile("^(cci|ccn|cmn|dsu|smmuv3|system mmu|corelink mmu)[ _\\-]+.*$");
    private static final Pattern PMU_COUNTER_NAME_PATTERN = Pattern.compile("^(.+)_(cnt[0-9]+|ccnt|freq|irq|softirq|system|user)$");
    private static final Map<@NonNull String, @NonNull String> GPU_CODENAME_MAP = new HashMap<String, String>(){
        {
            this.put("Mali-TMIx", "Mali-G71");
            this.put("Mali-THEx", "Mali-G72");
            this.put("Mali-TDVx", "Mali-G31");
            this.put("Mali-TSIx", "Mali-G51");
            this.put("Mali-TGOx", "Mali-G52");
            this.put("Mali-TNOx", "Mali-G76");
            this.put("Mali-TNAx", "Mali-G57");
            this.put("Mali-TTRx", "Mali-G77");
            this.put("Mali-TOTx", "Mali-G68");
            this.put("Mali-TBOx", "Mali-G78");
            this.put("Mali-TVAx", "Mali-G310");
            this.put("Mali-TGRx", "Mali-G510");
            this.put("Mali-TVIx", "Mali-G610");
            this.put("Mali-TODx", "Mali-G710");
            this.put("Mali-TTUx2", "Mali-G615");
            this.put("Mali-TTUx", "Mali-G715");
            this.put("Mali-TTIx", "Mali-G720");
            this.put("Mali-TTIx2", "Mali-G620");
            this.put("Mali-TKRx", "Mali-G725");
            this.put("Mali-TKRx2", "Mali-G625");
        }
    };

    public static @Nullable String getArchName(@Nullable String string) {
        return ClusterNameUtils.getName(string, true);
    }

    public static @Nullable String getPrettyName(@Nullable String string) {
        return ClusterNameUtils.getPrettyName(string, true);
    }

    public static @Nullable String getPrettyName(@Nullable String string, boolean allowPMUName) {
        return ClusterNameUtils.getName(string, allowPMUName);
    }

    public static @NonNull String getPrettyNameForNonCpu(@NonNull String string) {
        String gpuName = GPU_CODENAME_MAP.get(string);
        if (gpuName != null) {
            return gpuName;
        }
        return string;
    }

    public static boolean isAmbiguousCounterSet(@NonNull String counterSet) {
        return AMBIGUOUS_COUNTER_SET_NAMES.contains(counterSet = counterSet.toLowerCase()) && !KNOWN_PMU_IDS.contains(counterSet);
    }

    public static boolean isArmCortexOrNeoverse(@NonNull String counter) {
        return CORTEX_PATTERN.matcher(counter).find() || NEOVERSE_PATTERN.matcher(counter).find() || C_PATTERN.matcher(counter).find();
    }

    public static boolean isMaliOrImmortalis(@NonNull String name) {
        return MALI_PATTERN.matcher(name).find() || name.startsWith("Mali ") || name.contentEquals("Mali") || name.startsWith("Immortalis ") || name.contentEquals("Immortalis");
    }

    public static boolean isUncore(@NonNull String name) {
        for (Map.Entry<String, String> entry : EventsAndPmusXml.BUILT_IN_ID_TO_UNCORE_NAME.entrySet()) {
            if (!name.contentEquals(entry.getKey()) && !name.contentEquals(entry.getValue())) continue;
            return true;
        }
        if ((name = name.toLowerCase()).startsWith("arm_")) {
            name = name.substring(4);
        }
        return UNCORE_SIMPLE_PATTERN.matcher(name).find();
    }

    private static @NonNull String extractCortexOrNeoverseName(@NonNull String string, int end) {
        int pos = string.indexOf(95, end);
        if (pos == -1) {
            pos = string.length();
        }
        return (String)NullChecking.neverNull((Object)string.substring(end, pos));
    }

    @SuppressFBWarnings(value={"RpC_REPEATED_CONDITIONAL_TEST"})
    private static @Nullable String getName(@Nullable String string, boolean allowPMUName) {
        Matcher cortexMatcher;
        if (string == null) {
            return null;
        }
        if (string.startsWith("Other_") || string.equals("Other") || string.equals("Other")) {
            return "Other";
        }
        if (string.startsWith("Perf_Hardware_") || string.equals(PERF_HARDWARE) || string.equals(PERF_HARDWARE_PRETTY)) {
            return PERF_HARDWARE_PRETTY;
        }
        Matcher pmuCounterNameMatcher = PMU_COUNTER_NAME_PATTERN.matcher(string);
        if (pmuCounterNameMatcher.matches()) {
            string = (String)NullChecking.neverNull((Object)pmuCounterNameMatcher.group(1));
        }
        for (ProcessorPmu pmu : EventsAndPmusXml.BUILT_PMU) {
            if (!pmu.getId().equalsIgnoreCase(string) && !pmu.getCoreName().equalsIgnoreCase(string)) continue;
            return pmu.getCoreName();
        }
        for (ProcessorPmu pmu : EventsAndPmusXml.BUILT_PMU) {
            if (!pmu.getCounterSet().equals(string)) continue;
            if (ClusterNameUtils.isAmbiguousCounterSet(pmu.getCounterSet())) {
                if (!allowPMUName) break;
                return pmu.getCounterSet();
            }
            return pmu.getCoreName();
        }
        if ((cortexMatcher = CORTEX_PATTERN.matcher(string)).find()) {
            return CORTEX_PREFIX + ClusterNameUtils.extractCortexOrNeoverseName(string, cortexMatcher.end());
        }
        Matcher neoverseMatcher = NEOVERSE_PATTERN.matcher(string);
        if (neoverseMatcher.find()) {
            return NEOVERSE_PREFIX + ClusterNameUtils.extractCortexOrNeoverseName(string, neoverseMatcher.end());
        }
        neoverseMatcher = C_PATTERN.matcher(string);
        if (neoverseMatcher.find()) {
            String prefix = neoverseMatcher.group(2);
            String suffix = neoverseMatcher.group(3);
            if (suffix == null || suffix.isBlank()) {
                return prefix;
            }
            return prefix + "-" + suffix;
        }
        return null;
    }
}

