/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.preferences;

import com.arm.streamline.common.PluginMessages;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.utils.NullChecking;
import com.arm.utils.Platform;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CommonPreferences {
    private static final String MAC_OS_NAME = "mac";
    private static final String OS_NAME_PROPERTY = "os.name";
    private static final String LAST_CAPTURE_NAME_KEY = "com.arm.streamline.last_capture_name";
    private static final String LAST_SAVE_PATH = "com.arm.streamline.last_save_path";
    private static final String LAST_USED_ADVANCED_MODE = "com.arm.streamline.last_used_start_view_capture_config_mode";
    private static final String PREFERENCES_STORE_QUALIFIER = "com.arm.streamline";
    private static final String ANDROID_ACTIVITY_ARGUMENTS_HISTORY = "com.arm.streamline.android_activity_arguments_history";
    private static final String ARGUMENT_HISTORY_DELIMITER = "\u0000";
    public static final String ALLOW_ANALYTICS = "com.arm.streamline.allow_analytics";
    private static @Nullable IPreferenceStore preferenceStore;

    public static final @NonNull String chooseUniqueName(@NonNull File dir, @NonNull String name) {
        File[] entries = dir.listFiles();
        String[] existingEntries = entries == null ? null : (String[])Arrays.stream(entries).map(File::getName).toArray(String[]::new);
        return CommonPreferences.chooseUniqueName(name, existingEntries);
    }

    public static @NonNull String chooseUniqueName(@NonNull String name, String[] existingEntries) {
        String result;
        @NonNull Predicate<String> existingNameCheck = v -> existingEntries != null && Arrays.stream(existingEntries).filter(s -> s != null).anyMatch(s -> s.equalsIgnoreCase((String)v));
        boolean isMac = System.getProperty(OS_NAME_PROPERTY, "").toLowerCase(Locale.ROOT).contains(MAC_OS_NAME);
        if (existingNameCheck.test(name)) {
            String nextNumber;
            String baseNameWithoutLastDigits;
            String formattingString;
            boolean mm2;
            @NonNull String extension = (String)NullChecking.neverNullOr((Object)FilePath.getExtension(name), (Object)"");
            @NonNull String baseName = FilePath.getLeafName(name, false);
            @NonNull Pattern p0 = Pattern.compile("\\D+([0-9]+)\\D+$");
            @NonNull Matcher m0 = p0.matcher(baseName);
            @NonNull Pattern p1 = Pattern.compile(".*\\D([0-9]+)");
            @NonNull Matcher m1 = p1.matcher(baseName);
            @NonNull Pattern p2 = Pattern.compile("([0-9]+)");
            @NonNull Matcher m2 = p2.matcher(baseName);
            int nextValue = 2;
            boolean digitsArePartOfName = m0.find();
            boolean mm1 = digitsArePartOfName ? false : m1.find();
            boolean bl = mm2 = digitsArePartOfName ? false : m2.find();
            if (mm1 || mm2) {
                Matcher m = mm1 ? m1 : m2;
                @NonNull String group = (String)NullChecking.neverNull((Object)m.group(1));
                int patternLength = group.length();
                nextValue = Integer.parseInt(group) + 1;
                formattingString = String.format("%%0%dd", patternLength);
                baseNameWithoutLastDigits = baseName.substring(0, m.start(1));
            } else {
                formattingString = "_%02d";
                baseNameWithoutLastDigits = baseName;
            }
            String proposal = null;
            while (existingNameCheck.test(proposal = baseNameWithoutLastDigits.concat(nextNumber = String.format(formattingString, nextValue++)).concat(extension))) {
            }
            result = proposal;
        } else {
            result = name;
        }
        if (isMac) {
            result = FilePath.getLeafName(result, false);
        }
        return result;
    }

    public static final String getBaseName(String name) {
        String base = FilePath.getLeafName((String)NullChecking.neverNull((Object)name), false);
        int last = base.lastIndexOf(95);
        if (last != -1) {
            try {
                Integer.parseInt(base.substring(last + 1));
                base = base.substring(0, last);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return base;
    }

    public static final String getDefaultDocumentPath() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(System.getProperty("user.home"));
        buffer.append(File.separator);
        if (Platform.isWindows() && !Platform.isWindowsVistaOrNewer()) {
            buffer.append("My ");
        }
        buffer.append("Documents");
        buffer.append(File.separator);
        buffer.append("Streamline");
        String path = buffer.toString();
        new File(path).mkdirs();
        return path;
    }

    public static final String getLastCaptureName() {
        return CommonPreferences.getPreferenceStore().getString(LAST_CAPTURE_NAME_KEY);
    }

    public static final String getLastSavePath() {
        return CommonPreferences.getPreferenceStore().getString(LAST_SAVE_PATH);
    }

    public static final boolean isAdvancedConfigModePreferred() {
        return CommonPreferences.getPreferenceStore().getBoolean(LAST_USED_ADVANCED_MODE);
    }

    public static final @NonNull List<@NonNull String> getApplicationArgumentsHistory() {
        return Arrays.asList(CommonPreferences.getPreferenceStore().getString(ANDROID_ACTIVITY_ARGUMENTS_HISTORY).split(ARGUMENT_HISTORY_DELIMITER));
    }

    public static final boolean allowAnalytics() {
        return CommonPreferences.getPreferenceStore().getBoolean(ALLOW_ANALYTICS);
    }

    public static synchronized @NonNull IPreferenceStore getPreferenceStore() {
        IPreferenceStore preferenceStore = CommonPreferences.preferenceStore;
        if (preferenceStore == null) {
            CommonPreferences.preferenceStore = preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, PREFERENCES_STORE_QUALIFIER);
        }
        preferenceStore.setDefault(LAST_CAPTURE_NAME_KEY, PluginMessages.DEFAULT_CAPTURE_NAME);
        preferenceStore.setDefault(LAST_SAVE_PATH, CommonPreferences.getDefaultDocumentPath());
        preferenceStore.setDefault(LAST_USED_ADVANCED_MODE, false);
        preferenceStore.setDefault(ALLOW_ANALYTICS, true);
        return preferenceStore;
    }

    public static final void setLastCaptureName(String path) {
        CommonPreferences.getPreferenceStore().setValue(LAST_CAPTURE_NAME_KEY, path);
    }

    public static final void setLastSavePath(String path) {
        CommonPreferences.getPreferenceStore().setValue(LAST_SAVE_PATH, path);
    }

    public static final void setAdvancedConfigModePreference(boolean useAdvanced) {
        CommonPreferences.getPreferenceStore().setValue(LAST_USED_ADVANCED_MODE, useAdvanced);
    }

    public static final void setApplicationArgumentsHistory(@NonNull List<@NonNull String> history) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < history.size()) {
            builder.append(history.get(i));
            builder.append(ARGUMENT_HISTORY_DELIMITER);
            ++i;
        }
        CommonPreferences.getPreferenceStore().setValue(ANDROID_ACTIVITY_ARGUMENTS_HISTORY, builder.toString());
    }

    public static final void setAllowAnalytics(boolean allow) {
        CommonPreferences.getPreferenceStore().setValue(ALLOW_ANALYTICS, allow);
    }
}

