/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.preferences;

import com.arm.streamline.common.CommonPlugin;
import com.arm.utils.NullChecking;
import java.util.Arrays;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class AndroidDevicePreference {
    private static final @NonNull String ANDROID_DEVICE_PREFERENCES_STORE_QUALIFIER = "com.arm.streamline.adb.devices";
    private static final @NonNull String ANDROID_DEVICE_LAST_USED_PROFILE_GPU_CHECK = "adb.devices.profile.with.mali.counters";
    private static final @NonNull String ANDROID_DEVICE_LAST_USED_RESOLUTION_MODE = "adb.devices.analysis.resolution.mode";
    private static @Nullable Preferences checkedStatePreference;
    private static @Nullable Preferences resolutionModePreference;

    private static synchronized @NonNull Preferences getCheckedStatePreferenceStore() {
        Preferences checkedStatePreference = AndroidDevicePreference.checkedStatePreference;
        if (checkedStatePreference == null) {
            IEclipsePreferences androidDevicePreference = InstanceScope.INSTANCE.getNode(ANDROID_DEVICE_PREFERENCES_STORE_QUALIFIER);
            AndroidDevicePreference.checkedStatePreference = checkedStatePreference = androidDevicePreference.node(ANDROID_DEVICE_LAST_USED_PROFILE_GPU_CHECK);
        }
        return (Preferences)NullChecking.neverNull((Object)checkedStatePreference);
    }

    private static synchronized @NonNull Preferences getResolutionModePreferenceStore() {
        Preferences resolutionModePreference = AndroidDevicePreference.resolutionModePreference;
        if (resolutionModePreference == null) {
            IEclipsePreferences androidDevicePreference = InstanceScope.INSTANCE.getNode(ANDROID_DEVICE_PREFERENCES_STORE_QUALIFIER);
            AndroidDevicePreference.resolutionModePreference = resolutionModePreference = androidDevicePreference.node(ANDROID_DEVICE_LAST_USED_RESOLUTION_MODE);
        }
        return (Preferences)NullChecking.neverNull((Object)resolutionModePreference);
    }

    public static boolean getProfileWithMaliCounters(@NonNull String serialNumber) {
        return AndroidDevicePreference.getCheckedStatePreferenceStore().getBoolean(serialNumber, false);
    }

    public static boolean isProfileWithMaliCountersAddedForDevice(@NonNull String serialNumber) {
        try {
            return Arrays.asList(AndroidDevicePreference.getCheckedStatePreferenceStore().keys()).stream().filter(k -> k.equals(serialNumber)).count() == 1L;
        }
        catch (BackingStoreException e) {
            return false;
        }
    }

    public static void setProfileWithMaliCounters(@NonNull String serialNumber, boolean checkedState) {
        Preferences checkedStatePreferenceStore = AndroidDevicePreference.getCheckedStatePreferenceStore();
        checkedStatePreferenceStore.putBoolean(serialNumber, checkedState);
        try {
            checkedStatePreferenceStore.flush();
        }
        catch (BackingStoreException e) {
            CommonPlugin.warning((String)NullChecking.neverNullOr((Object)e.getMessage(), (Object)"Error while saving preferences."));
        }
    }

    public static void setResolutionMode(@NonNull String serialNumber, @NonNull String resolutionMode) {
        Preferences resolutionModePreferenceStore = AndroidDevicePreference.getResolutionModePreferenceStore();
        resolutionModePreferenceStore.put(serialNumber, resolutionMode);
        try {
            resolutionModePreferenceStore.flush();
        }
        catch (BackingStoreException e) {
            CommonPlugin.warning((String)NullChecking.neverNullOr((Object)e.getMessage(), (Object)"Error while saving preferences."));
        }
    }

    public static @NonNull String getResolutionMode(@NonNull String serialNumber) {
        return (String)NullChecking.neverNull((Object)AndroidDevicePreference.getResolutionModePreferenceStore().get(serialNumber, ""));
    }
}

