/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.warnings;

import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.common.model.warnings.RawWarnings;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.jni.common.WarningType;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Warnings
extends RawWarnings
implements IWarnings {
    private final @NonNull List<@NonNull WarningItem> mAggregatedItems = new ArrayList<WarningItem>();

    public Warnings() {
    }

    public Warnings(@NonNull IWarnings that) {
        super(that);
        this.mAggregatedItems.addAll(that.getAggregatedItems());
    }

    @Override
    public final void add(@NonNull WarningItem item) {
        this.mAggregatedItems.clear();
        super.add(item);
    }

    @Override
    public final void clear() {
        this.mAggregatedItems.clear();
        super.clear();
    }

    @Override
    public @NonNull List<@NonNull WarningItem> getAggregatedItems() {
        return this.mAggregatedItems;
    }

    @Override
    public @NonNull Iterator<@NonNull WarningItem> iterator() {
        this.aggregate();
        return this.mAggregatedItems.iterator();
    }

    @Override
    public final void load(@NonNull File dir) {
        this.mAggregatedItems.clear();
        super.load(dir);
    }

    @Override
    public final void remove(@NonNull WarningItem item) {
        this.mAggregatedItems.clear();
        super.remove(item);
    }

    @Override
    public final int size() {
        this.aggregate();
        return this.mAggregatedItems.size();
    }

    private void aggregate() {
        if (this.mAggregatedItems.size() == 0) {
            List<WarningItem> items = this.getItems();
            for (WarningItem item : items) {
                WarningItem warning;
                if (item.getVariable() == null || item.getVariableSubstitutionString() == null) {
                    this.mAggregatedItems.add(item);
                    continue;
                }
                if (this.aggregateWarningsContains(item.getType(), item.getTitle()) || (warning = this.aggregateWarnings(item.getType(), item.getTitle())) == null) continue;
                this.mAggregatedItems.add(warning);
            }
        }
    }

    private @Nullable WarningItem aggregateWarnings(@NonNull WarningType type, @NonNull String title) {
        StringBuffer variables = new StringBuffer();
        WarningItem firstItem = null;
        List<WarningItem> items = this.getItems();
        for (WarningItem item : items) {
            if (item.getType() != type || !item.getTitle().contentEquals(title) || item.getVariable() == null) continue;
            if (variables.length() == 0) {
                firstItem = item;
                variables.append(item.getVariable());
                continue;
            }
            variables.append(", " + item.getVariable());
        }
        if (firstItem != null) {
            return new WarningItem(type, firstItem.getSeverity(), title, MessageFormat.format(firstItem.getVariableSubstitutionString(), variables));
        }
        return null;
    }

    private boolean aggregateWarningsContains(@NonNull WarningType type, @NonNull String title) {
        for (WarningItem item : this.mAggregatedItems) {
            if (!item.getType().equals((Object)type) || !item.getTitle().contentEquals(title)) continue;
            return true;
        }
        return false;
    }
}

