/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.topology;

import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class ProcessingElementReference
implements Comparable<ProcessingElementReference> {
    private static final String ATTR_DEVICE_NUMBER = "pe";
    private static final String ATTR_VMUID = "vm";
    public final @NonNull DeviceType deviceType;
    public final int deviceNumber;
    public final long vmUID;

    public static @NonNull ProcessingElementReference create(@NonNull DeviceType deviceType, long vmUID, int deviceNumber) {
        if (deviceType.supportsMultipleCores()) {
            return new ProcessingElementReference(deviceType, vmUID, deviceNumber);
        }
        return new ProcessingElementReference(deviceType, vmUID, 0);
    }

    public ProcessingElementReference(@NonNull XMLParser in) {
        this.deviceType = DeviceType.read(in, false);
        this.vmUID = in.getLongAttribute(ATTR_VMUID);
        this.deviceNumber = in.getIntegerAttribute(ATTR_DEVICE_NUMBER);
    }

    private ProcessingElementReference(@NonNull DeviceType deviceType, long vmUID, int deviceNumber) {
        this.deviceType = deviceType;
        this.vmUID = vmUID;
        this.deviceNumber = deviceNumber;
    }

    @Override
    public int compareTo(ProcessingElementReference o) {
        if (o == null) {
            return -1;
        }
        int deviceTypeResult = this.deviceType.compareTo(o.deviceType);
        if (deviceTypeResult != 0) {
            return deviceTypeResult;
        }
        int vmResult = Long.compare(this.vmUID, o.vmUID);
        if (vmResult != 0) {
            return vmResult;
        }
        return Long.compare(this.deviceNumber, o.deviceNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProcessingElementReference) {
            ProcessingElementReference that = (ProcessingElementReference)obj;
            return this.vmUID == that.vmUID && this.deviceNumber == that.deviceNumber && this.deviceType.equals(that.deviceType);
        }
        return false;
    }

    public int hashCode() {
        return (31 * Long.hashCode(this.vmUID) + this.deviceNumber) * 31 + this.deviceType.hashCode();
    }

    public String toString() {
        return String.format("(%s):%d:%d", this.deviceType, this.vmUID, this.deviceNumber);
    }

    public void write(@NonNull XMLGenerator xml) throws IOException {
        this.deviceType.write(xml);
        xml.addAttribute(ATTR_VMUID, this.vmUID);
        xml.addAttribute(ATTR_DEVICE_NUMBER, this.deviceNumber);
    }
}

