/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.counters;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.counters.BadXmlException;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class CounterRecordFile {
    public static final @NonNull String COUNTERFILE = "counter.xml";
    private static final @NonNull String ATTR_VERSION = "version";
    private static final @NonNull String TAG_COUNTER = "counter";

    public static @NonNull CounterRecord counterRecordReader(@NonNull File path) throws IOException {
        File xml = new File(path, COUNTERFILE);
        CounterRecord cr = null;
        XMLParser in = null;
        try {
            String tag;
            in = XMLParser.create(xml);
            while ((tag = in.nextTag()) != null) {
                if (TAG_COUNTER.equals(tag)) {
                    try {
                        cr = new CounterRecord(in);
                    }
                    catch (BadXmlException e) {
                        StdLog.warning(CommonPlugin.getInstance(), "Invalid XML in counter record", e);
                    }
                    continue;
                }
                in.skip();
            }
        }
        finally {
            if (cr == null) {
                cr = new CounterRecord();
            }
            CommonFileUtils.ignoredClose(in);
        }
        return cr;
    }

    public static void writeCounterRecord(@NonNull File outputPath, CounterRecord counterRecord, int cores) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLGenerator xml = XMLGenerator.create(new File(outputPath, COUNTERFILE));){
            xml.startDocument();
            xml.startTag(TAG_COUNTER);
            xml.addAttribute(ATTR_VERSION, 1);
            counterRecord.write(xml, cores);
            xml.endTag();
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

