/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model;

import com.arm.streamline.common.model.Scales;
import org.eclipse.jdt.annotation.NonNull;

public final class ZoomLevel {
    private final int bps;

    public ZoomLevel(int bps) {
        this.bps = bps;
    }

    public long convertBinToNanoseconds(long bin) {
        return bin * 1000000000L / (long)this.bps;
    }

    public long convertNanosecondsToBin(long nanoseconds) {
        return Math.floorDiv(nanoseconds * (long)this.bps, 1000000000);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ZoomLevel) {
            @NonNull ZoomLevel other = (ZoomLevel)obj;
            return this.bps == other.bps;
        }
        return false;
    }

    public int getBps() {
        return this.bps;
    }

    public int getCallPathTicks() {
        int binDurationNanoseconds = 1000000000 / this.bps;
        assert (binDurationNanoseconds <= 1000000000);
        assert (binDurationNanoseconds > 0);
        assert ((long)binDurationNanoseconds % Scales.NANOSECONDS_PER_DENSEST_CALLPATH_BIN == 0L);
        int ticks = (int)((long)binDurationNanoseconds / Scales.NANOSECONDS_PER_DENSEST_CALLPATH_BIN);
        return ticks;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bps;
        return result;
    }
}

