/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model;

import com.arm.streamline.common.model.IScaleChangeListener;
import com.arm.streamline.common.model.IScaleListener;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.utils.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Scales {
    public static final int NANOSECONDS_PER_SECOND = 1000000000;
    public static final int MICROSECONDS_PER_SECOND = 1000000;
    public static final int TEN_MICROSECONDS_PER_SECOND = 100000;
    public static final int ONE_HUNDRED_MICROSECONDS_PER_SECOND = 10000;
    public static final int MILLISECONDS_PER_SECOND = 1000;
    public static final int FIVE_HUNDRED_MICROSECONDS_PER_SECOND = 2000;
    public static final int TEN_MILLISECONDS_PER_SECOND = 100;
    public static final @NonNull ZoomLevel ONE_MICROSECOND_ZOOM_LEVEL = new ZoomLevel(1000000);
    public static final @NonNull ZoomLevel ONE_MILLISECOND_ZOOM_LEVEL = new ZoomLevel(1000);
    public static final @NonNull ZoomLevel ONE_NANOSECOND_ZOOM_LEVEL = new ZoomLevel(1000000000);
    public static final @NonNull ZoomLevel HUNDRED_MILLISECONDS_ZOOM_LEVEL = new ZoomLevel(10);
    public static final @NonNull ZoomLevel DENSEST_HI_RES_ZOOM_LEVEL = new ZoomLevel(100000);
    public static final @NonNull ZoomLevel DENSEST_LO_RES_ZOOM_LEVEL = new ZoomLevel(2000);
    public static final @NonNull ZoomLevel DENSEST_SUMMARY_RES_ZOOM_LEVEL = new ZoomLevel(100);
    public static final @NonNull ZoomLevel DENSEST_ULTRA_HI_RES_ZOOM_LEVEL;
    public static final @NonNull ZoomLevel DENSEST_POSSIBLE_ZOOM_LEVEL;
    public static final @NonNull ZoomLevel @NonNull [] LO_RES_ZOOM_LEVELS;
    public static final @NonNull ZoomLevel @NonNull [] HI_RES_ZOOM_LEVELS;
    public static final @NonNull ZoomLevel @NonNull [] SUMMARY_RES_ZOOM_LEVELS;
    public static final @NonNull ZoomLevel @NonNull [] ULTRA_HI_RES_ZOOM_LEVELS;
    public static final @NonNull ZoomLevel LIVE_CAPTURE_ZOOM_LEVEL;
    public static final @NonNull ZoomLevel REPORT_DEFAULT_ZOOM_LEVEL;
    public static final @NonNull ZoomLevel @NonNull [] CALLPATH_BINS_PER_SECOND;
    public static final @NonNull ZoomLevel DENSEST_CALLPATH_ZOOM_LEVEL;
    public static final long NANOSECONDS_PER_DENSEST_CALLPATH_BIN;
    private final @NonNull IScaleChangeListener mDataProvider;
    private int mCurrentZoomLevelIndex;
    private final @NonNull ZoomLevel @NonNull [] mZoomLevels;
    private final @NonNull ZoomLevel @NonNull [] mReversedZoomLevels;
    private final @NonNull List<@NonNull IScaleListener> mListeners = new ArrayList<IScaleListener>();

    static {
        DENSEST_POSSIBLE_ZOOM_LEVEL = DENSEST_ULTRA_HI_RES_ZOOM_LEVEL = new ZoomLevel(1000000);
        LO_RES_ZOOM_LEVELS = Scales.fromBpses(new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000});
        HI_RES_ZOOM_LEVELS = Scales.fromBpses(new int[]{1, 10, 100, 1000, 10000, 100000});
        SUMMARY_RES_ZOOM_LEVELS = Scales.fromBpses(new int[]{1, 100});
        ULTRA_HI_RES_ZOOM_LEVELS = Scales.fromBpses(new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 200000, 500000, 1000000});
        LIVE_CAPTURE_ZOOM_LEVEL = HUNDRED_MILLISECONDS_ZOOM_LEVEL;
        REPORT_DEFAULT_ZOOM_LEVEL = HUNDRED_MILLISECONDS_ZOOM_LEVEL;
        CALLPATH_BINS_PER_SECOND = Scales.fromBpses(new int[]{1000000, 1000, 1});
        DENSEST_CALLPATH_ZOOM_LEVEL = CALLPATH_BINS_PER_SECOND[0];
        NANOSECONDS_PER_DENSEST_CALLPATH_BIN = DENSEST_CALLPATH_ZOOM_LEVEL.convertBinToNanoseconds(1L);
    }

    private static @NonNull ZoomLevel @NonNull [] fromBpses(int @NonNull [] bpses) {
        return (ZoomLevel[])Arrays.stream(bpses).mapToObj(ZoomLevel::new).toArray(ZoomLevel[]::new);
    }

    private static int @NonNull [] toBpses(@NonNull ZoomLevel @NonNull [] levels) {
        return Arrays.stream(levels).mapToInt(ZoomLevel::getBps).toArray();
    }

    public Scales(@NonNull IScaleChangeListener dataProvider, @NonNull ZoomLevel currentZoomLevel, @NonNull ZoomLevel @NonNull [] allZoomLevels) {
        this.mDataProvider = dataProvider;
        this.mZoomLevels = allZoomLevels;
        this.mReversedZoomLevels = new ZoomLevel[this.mZoomLevels.length];
        int i = 0;
        while (i < this.mZoomLevels.length) {
            this.mReversedZoomLevels[i] = this.mZoomLevels[this.mZoomLevels.length - i - 1];
            ++i;
        }
        this.mCurrentZoomLevelIndex = this.validateZoomLevel(currentZoomLevel);
    }

    public final synchronized void addListener(@NonNull IScaleListener listener) {
        this.mListeners.add(listener);
    }

    public final @NonNull IScaleChangeListener getDataProvider() {
        return this.mDataProvider;
    }

    public final @NonNull ZoomLevel getDensestZoomLevel() {
        return this.mZoomLevels[this.mZoomLevels.length - 1];
    }

    public final int getMicrosecondsAtDensestScale() {
        return 1000000 / this.getDensestZoomLevel().getBps();
    }

    public final @Nullable ZoomLevel getNextScaleDown() {
        if (this.mCurrentZoomLevelIndex > 0) {
            return this.mZoomLevels[this.mCurrentZoomLevelIndex - 1];
        }
        return null;
    }

    public final @Nullable ZoomLevel getNextScaleUp() {
        int next = this.mCurrentZoomLevelIndex + 1;
        if (next < this.mZoomLevels.length) {
            return this.mZoomLevels[next];
        }
        return null;
    }

    public final int[] getReversedScales() {
        return Scales.toBpses(this.mReversedZoomLevels);
    }

    public final @NonNull ZoomLevel getZoomLevel() {
        return this.mZoomLevels[this.mCurrentZoomLevelIndex];
    }

    public final @NonNull ZoomLevel @NonNull [] getAvailableZoomLevels() {
        return this.mZoomLevels;
    }

    public final long getTimeInNanoseconds(int bin) {
        return this.mZoomLevels[this.mCurrentZoomLevelIndex].convertBinToNanoseconds(bin);
    }

    public final boolean isAtMaxZoom() {
        return this.mCurrentZoomLevelIndex >= this.mZoomLevels.length - 1;
    }

    public final boolean isAtMinZoom() {
        return this.mCurrentZoomLevelIndex <= 0;
    }

    public static final long mapDensestBinIndexToMicroseconds(int densestBinIndex) {
        double seconds = (double)densestBinIndex / (double)DENSEST_POSSIBLE_ZOOM_LEVEL.getBps();
        return (long)(seconds * 1000000.0);
    }

    public final synchronized void removeListener(IScaleListener listener) {
        this.mListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setZoomLevel(@NonNull ZoomLevel zoomLevel) {
        int newIndex = this.validateZoomLevel(zoomLevel);
        if (this.mCurrentZoomLevelIndex != newIndex) {
            IScaleListener[] listeners;
            int oldIndex = this.mCurrentZoomLevelIndex;
            this.mCurrentZoomLevelIndex = newIndex;
            this.mDataProvider.adjustToNewScale(this.mZoomLevels[oldIndex], this.mZoomLevels[newIndex]);
            Scales scales = this;
            synchronized (scales) {
                listeners = this.mListeners.toArray(new IScaleListener[this.mListeners.size()]);
            }
            IScaleListener[] iScaleListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IScaleListener listener = iScaleListenerArray[n2];
                listener.scaleChanged(this);
                ++n2;
            }
        }
    }

    private final int validateZoomLevel(@NonNull ZoomLevel zoomLevel) {
        int result = ArrayUtils.indexOf((Object[])this.mZoomLevels, (Object)zoomLevel);
        if (result >= 0) {
            return result;
        }
        return 0;
    }
}

