/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model;

import com.arm.streamline.common.model.CaptureSubType;
import com.arm.streamline.common.model.ProtocolType;
import org.eclipse.jdt.annotation.NonNull;

public final class CaptureProperties {
    private final @NonNull CaptureSubType captureSubType;
    private final @NonNull ProtocolType protocolType;
    private static final @NonNull String UNKNOWN_CAPTURETYPE = "Unknown capture sub type %s";
    private static final @NonNull String UNKNOWN_PROTOCOL = "Unknown protocol type %s";

    public CaptureProperties(@NonNull CaptureSubType captureSubType, @NonNull ProtocolType protocolType) throws IllegalArgumentException {
        this.captureSubType = captureSubType;
        this.protocolType = protocolType;
        if ((captureSubType == CaptureSubType.ANDROID || captureSubType == CaptureSubType.LINUX) && protocolType != ProtocolType.PERF) {
            throw new IllegalArgumentException("This capture is not supported in the current version of Streamline. Please create a new capture.");
        }
    }

    public @NonNull CaptureSubType getCaptureSubType() {
        return this.captureSubType;
    }

    public @NonNull ProtocolType getProtocolType() {
        return this.protocolType;
    }

    public final boolean isBareMetalCapture() {
        switch (this.protocolType) {
            case ASTF: {
                return false;
            }
            case BARMAN: {
                return true;
            }
            case PERF: {
                switch (this.captureSubType) {
                    case ANDROID: 
                    case DEFAULT: 
                    case LINUX: {
                        return false;
                    }
                }
                throw new AssertionError((Object)String.format(UNKNOWN_CAPTURETYPE, new Object[]{this.captureSubType}));
            }
            case UNKNOWN: {
                return false;
            }
        }
        throw new AssertionError((Object)String.format(UNKNOWN_PROTOCOL, new Object[]{this.protocolType}));
    }

    public final boolean isGatorCapture() {
        switch (this.captureSubType) {
            case ANDROID: 
            case LINUX: {
                return true;
            }
            case DEFAULT: {
                switch (this.protocolType) {
                    case ASTF: {
                        return false;
                    }
                    case PERF: {
                        return true;
                    }
                    case BARMAN: {
                        return false;
                    }
                    case UNKNOWN: {
                        return false;
                    }
                }
                throw new AssertionError((Object)String.format(UNKNOWN_PROTOCOL, new Object[]{this.protocolType}));
            }
        }
        throw new AssertionError((Object)String.format(UNKNOWN_CAPTURETYPE, new Object[]{this.captureSubType}));
    }
}

