/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.analysis.model;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AnnotationColour {
    public static final int DEFAULT_COLOUR_INT = -3092272;
    public static final int @NonNull [] DARK_COLOR_PALETTE = new int[]{AnnotationColour.makeRGB((byte)59, (byte)62, (byte)-57), AnnotationColour.makeRGB((byte)-122, (byte)53, (byte)-64), AnnotationColour.makeRGB((byte)46, (byte)-115, (byte)101), AnnotationColour.makeRGB((byte)-68, (byte)106, (byte)0)};
    public static final @NonNull AnnotationColour DEFAULT_COLOUR_OBJ = new AnnotationColour(-3092272);
    public static final @NonNull AnnotationColour ALT_WARNING_COLOUR = new AnnotationColour(-1, 127, 0);
    public static final @NonNull AnnotationColour WARNING_COLOUR = new AnnotationColour(-1, 0, 0);
    public static final int @NonNull [] LIGHT_COLOR_PALETTE = new int[]{AnnotationColour.makeRGB((byte)94, (byte)-114, (byte)-21), AnnotationColour.makeRGB((byte)-80, (byte)70, (byte)-18), AnnotationColour.makeRGB((byte)120, (byte)-46, (byte)-120), AnnotationColour.makeRGB((byte)-14, (byte)-90, (byte)61)};
    public static final int NUM_COLOUR_CYCLES = 4;
    public static final @NonNull AnnotationColour TEMPLATE_COLOUR_1 = new AnnotationColour(AnnotationColourClassification.TEMPLATE_0, 0, 0, 0);
    public static final @NonNull AnnotationColour TEMPLATE_COLOUR_2 = new AnnotationColour(AnnotationColourClassification.TEMPLATE_1, 0, 0, 0);
    public static final @NonNull AnnotationColour TEMPLATE_COLOUR_3 = new AnnotationColour(AnnotationColourClassification.TEMPLATE_2, 0, 0, 0);
    public static final @NonNull AnnotationColour TEMPLATE_COLOUR_4 = new AnnotationColour(AnnotationColourClassification.TEMPLATE_3, 0, 0, 0);
    private final @NonNull AnnotationColourClassification classification;
    private final byte r;
    private final byte g;
    private final byte b;

    public static @NonNull AnnotationColourClassification classify(int value) {
        if (value == -3092272) {
            return AnnotationColourClassification.DEFAULT;
        }
        int c = value >>> 24;
        switch (c) {
            case 0: {
                return AnnotationColourClassification.ROTATE;
            }
            case 1: {
                return AnnotationColourClassification.TEMPLATE_0;
            }
            case 2: {
                return AnnotationColourClassification.TEMPLATE_1;
            }
            case 3: {
                return AnnotationColourClassification.TEMPLATE_2;
            }
            case 4: {
                return AnnotationColourClassification.TEMPLATE_3;
            }
        }
        return AnnotationColourClassification.RGB;
    }

    public static @NonNull AnnotationColour mapCyclicColour(int n) {
        int x = n % 4;
        if (x == 3) {
            return TEMPLATE_COLOUR_4;
        }
        if (x == 2) {
            return TEMPLATE_COLOUR_3;
        }
        if (x == 1) {
            return TEMPLATE_COLOUR_2;
        }
        return TEMPLATE_COLOUR_1;
    }

    private static int makeRGB(byte r, byte g, byte b) {
        return r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
    }

    public AnnotationColour() {
        this(AnnotationColourClassification.ROTATE, 0, 0, 0);
    }

    public AnnotationColour(byte r, byte g, byte b) {
        this(AnnotationColourClassification.RGB, r, g, b);
    }

    public AnnotationColour(int value) {
        this.classification = AnnotationColour.classify(value);
        switch (this.classification) {
            case DEFAULT: 
            case ROTATE: 
            case TEMPLATE_0: 
            case TEMPLATE_1: 
            case TEMPLATE_2: 
            case TEMPLATE_3: {
                this.r = 0;
                this.g = 0;
                this.b = 0;
                break;
            }
            case RGB: {
                this.r = (byte)(value >>> 16);
                this.g = (byte)(value >>> 8);
                this.b = (byte)value;
                break;
            }
            default: {
                throw new AssertionError((Object)this.classification);
            }
        }
    }

    private AnnotationColour(@NonNull AnnotationColourClassification classification, byte r, byte g, byte b) {
        this.classification = classification;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnnotationColour) {
            AnnotationColour that = (AnnotationColour)obj;
            return this.classification.equals((Object)that.classification) && this.r == that.r && this.g == that.g && this.b == that.b;
        }
        return false;
    }

    public byte getB() {
        return this.b;
    }

    public @NonNull AnnotationColourClassification getClassification() {
        return this.classification;
    }

    public byte getG() {
        return this.g;
    }

    public byte getR() {
        return this.r;
    }

    public int hashCode() {
        return this.classification.ordinal() << 24 | (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF;
    }

    public @Nullable Integer mapCounterColour() {
        switch (this.classification) {
            case RGB: {
                return AnnotationColour.makeRGB(this.r, this.g, this.b);
            }
            case ROTATE: {
                return null;
            }
            case TEMPLATE_0: {
                return DARK_COLOR_PALETTE[0];
            }
            case TEMPLATE_1: {
                return DARK_COLOR_PALETTE[1];
            }
            case TEMPLATE_2: {
                return DARK_COLOR_PALETTE[2];
            }
            case TEMPLATE_3: {
                return DARK_COLOR_PALETTE[3];
            }
            case DEFAULT: {
                return -3092272;
            }
        }
        throw new AssertionError((Object)this.classification);
    }

    public int toInt() {
        switch (this.classification) {
            case RGB: {
                return 0x1B000000 | AnnotationColour.makeRGB(this.r, this.g, this.b);
            }
            case ROTATE: {
                return 0;
            }
            case TEMPLATE_0: {
                return 0x1000000;
            }
            case TEMPLATE_1: {
                return 0x2000000;
            }
            case TEMPLATE_2: {
                return 0x3000000;
            }
            case TEMPLATE_3: {
                return 0x4000000;
            }
            case DEFAULT: {
                return -3092272;
            }
        }
        throw new AssertionError((Object)this.classification);
    }

    public @NonNull String toString() {
        switch (this.classification) {
            case RGB: {
                return String.format("#%02x%02x%02x", this.r & 0xFF, this.g & 0xFF, this.b & 0xFF);
            }
            case DEFAULT: 
            case ROTATE: 
            case TEMPLATE_0: 
            case TEMPLATE_1: 
            case TEMPLATE_2: 
            case TEMPLATE_3: {
                return this.classification.toString();
            }
        }
        throw new AssertionError((Object)this.classification);
    }

    public static enum AnnotationColourClassification {
        DEFAULT,
        RGB,
        ROTATE,
        TEMPLATE_0,
        TEMPLATE_1,
        TEMPLATE_2,
        TEMPLATE_3;

    }
}

