/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.v1.write;

import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.report.api.write.IReportWriterFactory;
import com.arm.streamline.report.api.write.counters.IReportBinnedCounterWriter;
import com.arm.streamline.report.shared.zoomlevelgeneration.BinningDataMode;
import com.arm.streamline.report.v1.write.ReportBinnedCounterWriter;
import java.io.File;
import java.io.IOException;
import java.util.function.ToIntFunction;
import org.eclipse.jdt.annotation.NonNull;

public class ReportWriterFactoryV1
implements IReportWriterFactory {
    private final @NonNull File countersDirectory;

    public ReportWriterFactoryV1(@NonNull File reportsDirectory) {
        File timelineDirectory = new File(reportsDirectory, "timeline");
        this.countersDirectory = new File(timelineDirectory, "counters");
    }

    @Override
    public <T> @NonNull IReportBinnedCounterWriter<T> create(@NonNull CounterRecord counterRecord, int numberOfChannels, @NonNull BinningDataMode @NonNull [] binningDataModes, long binDurationInNanoSeconds, int @NonNull [] numberOfTicksPerBin, int @NonNull [] labelsPerBin, @NonNull ToIntFunction<@NonNull T> channelMapper) throws IOException {
        if (numberOfTicksPerBin.length != labelsPerBin.length) {
            throw new IllegalArgumentException();
        }
        return new ReportBinnedCounterWriter<T>(new File(this.countersDirectory, counterRecord.getAlias()), counterRecord, binDurationInNanoSeconds, numberOfChannels, binningDataModes, numberOfTicksPerBin, labelsPerBin, channelMapper);
    }
}

