/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.shared.zoomlevelgeneration;

import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.shared.zoomlevelgeneration.AbstractZoomLevelGenerator;
import com.arm.streamline.report.shared.zoomlevelgeneration.BinningDataMode;
import com.arm.streamline.report.shared.zoomlevelgeneration.IZoomLevelBinDataWriter;
import com.arm.streamline.report.shared.zoomlevelgeneration.IZoomLevelLimitsTracker;
import com.arm.utils.ArrayUtils;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.hash.TIntLongHashMap;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SumZoomLevelGenerator
extends AbstractZoomLevelGenerator {
    private final @NonNull TIntLongMap @NonNull [] channelData;

    public SumZoomLevelGenerator(int numberOfTicks, int numberOfChannels, @NonNull IZoomLevelBinDataWriter binDataWriter, @NonNull IZoomLevelLimitsTracker limitsTracker) {
        super(numberOfTicks, numberOfChannels, BinningDataMode.SUM, binDataWriter, limitsTracker);
        this.channelData = (TIntLongMap[])ArrayUtils.create(TIntLongMap[]::new, (int)numberOfChannels, () -> new TIntLongHashMap(10, 0.5f, -1, 0L));
    }

    @Override
    public void consumeCounterValue(int channelNumber, @Nullable Integer utid, long value, boolean happenedInBin) throws IOException {
        TIntLongMap destination = this.channelData[channelNumber];
        int key = IUniqueIds.mapNullableUtidToInt(utid);
        destination.adjustOrPutValue(key, value, value);
    }

    @Override
    public void discard() {
        TIntLongMap[] tIntLongMapArray = this.channelData;
        int n = this.channelData.length;
        int n2 = 0;
        while (n2 < n) {
            TIntLongMap map = tIntLongMapArray[n2];
            map.clear();
            ++n2;
        }
    }

    @Override
    protected void writeData(@NonNull IZoomLevelBinDataWriter binDataWriter, @NonNull IZoomLevelLimitsTracker limitsTracker, int ticksRemaining) throws IOException {
        long binIndex = binDataWriter.getCurrentIndex();
        long systemWideAggregate = 0L;
        int channelNumber = 0;
        while (channelNumber < this.channelData.length) {
            TIntLongMap map = this.channelData[channelNumber];
            long perChannelAggregate = 0L;
            if (!map.isEmpty()) {
                TIntLongIterator it = map.iterator();
                while (it.hasNext()) {
                    it.advance();
                    int key = it.key();
                    long value = it.value();
                    @Nullable Integer utid = IUniqueIds.mapIntToNullableUtid(key);
                    binDataWriter.writeData(channelNumber, utid, value);
                    perChannelAggregate += value;
                    systemWideAggregate += value;
                }
                map.clear();
            } else {
                binDataWriter.writeData(channelNumber, null, 0L);
            }
            limitsTracker.updatePerChannelLimits(binIndex, channelNumber, BinningDataMode.SUM, perChannelAggregate);
            ++channelNumber;
        }
        limitsTracker.updateAggregateLimits(binIndex, BinningDataMode.SUM, systemWideAggregate);
        binDataWriter.next();
    }
}

