/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.shared.zoomlevelgeneration;

import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.shared.zoomlevelgeneration.AbstractZoomLevelGenerator;
import com.arm.streamline.report.shared.zoomlevelgeneration.BinningDataMode;
import com.arm.streamline.report.shared.zoomlevelgeneration.IZoomLevelBinDataWriter;
import com.arm.streamline.report.shared.zoomlevelgeneration.IZoomLevelLimitsTracker;
import com.arm.utils.ArrayUtils;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AverageZoomLevelGenerator
extends AbstractZoomLevelGenerator {
    private final @NonNull TIntLongMap @NonNull [] channelDataCount;
    private final @NonNull TIntLongMap @NonNull [] channelDataSum;
    private final @NonNull TIntSet @NonNull [] channelsWithDataInBin;

    public AverageZoomLevelGenerator(int numberOfTicks, int numberOfChannels, @NonNull IZoomLevelBinDataWriter binDataWriter, @NonNull IZoomLevelLimitsTracker limitsTracker) {
        super(numberOfTicks, numberOfChannels, BinningDataMode.AVERAGE, binDataWriter, limitsTracker);
        this.channelDataSum = (TIntLongMap[])ArrayUtils.create(TIntLongMap[]::new, (int)numberOfChannels, () -> new TIntLongHashMap(10, 0.5f, -1, 0L));
        this.channelDataCount = (TIntLongMap[])ArrayUtils.create(TIntLongMap[]::new, (int)numberOfChannels, () -> new TIntLongHashMap(10, 0.5f, -1, 0L));
        this.channelsWithDataInBin = (TIntSet[])ArrayUtils.create(TIntSet[]::new, (int)numberOfChannels, () -> new TIntHashSet(10, 0.5f, 0));
    }

    @Override
    public void consumeCounterValue(int channelNumber, @Nullable Integer utid, long value, boolean happenedInBin) throws IOException {
        TIntLongMap destinationSum = this.channelDataSum[channelNumber];
        TIntLongMap destinationCount = this.channelDataCount[channelNumber];
        int key = IUniqueIds.mapNullableUtidToInt(utid);
        boolean alreadyHappenedInBin = this.channelsWithDataInBin[channelNumber].contains(key);
        if (happenedInBin && !alreadyHappenedInBin) {
            destinationSum.put(key, value);
            destinationCount.put(key, 1L);
        } else if (happenedInBin || !alreadyHappenedInBin) {
            destinationSum.adjustOrPutValue(key, value, value);
            destinationCount.adjustOrPutValue(key, 1L, 1L);
        }
        if (happenedInBin) {
            this.channelsWithDataInBin[channelNumber].add(key);
        }
    }

    @Override
    public void discard() {
        TIntLongMap map;
        TIntLongMap[] tIntLongMapArray = this.channelDataSum;
        int n = this.channelDataSum.length;
        int n2 = 0;
        while (n2 < n) {
            map = tIntLongMapArray[n2];
            map.clear();
            ++n2;
        }
        tIntLongMapArray = this.channelDataSum;
        n = this.channelDataSum.length;
        n2 = 0;
        while (n2 < n) {
            map = tIntLongMapArray[n2];
            map.clear();
            ++n2;
        }
        tIntLongMapArray = this.channelsWithDataInBin;
        n = this.channelsWithDataInBin.length;
        n2 = 0;
        while (n2 < n) {
            TIntLongMap set = tIntLongMapArray[n2];
            set.clear();
            ++n2;
        }
    }

    @Override
    protected void writeData(@NonNull IZoomLevelBinDataWriter binDataWriter, @NonNull IZoomLevelLimitsTracker limitsTracker, int ticksRemaining) throws IOException {
        long binIndex = binDataWriter.getCurrentIndex();
        long systemWideAggregateSum = 0L;
        long systemWideAggregateCount = 0L;
        int channelNumber = 0;
        while (channelNumber < this.channelDataSum.length) {
            long perChannelAggregateSum = 0L;
            long perChannelAggregateCount = 0L;
            TIntLongMap sourceSum = this.channelDataSum[channelNumber];
            if (!sourceSum.isEmpty()) {
                TIntLongMap sourceCount = this.channelDataCount[channelNumber];
                TIntLongIterator it = sourceSum.iterator();
                while (it.hasNext()) {
                    it.advance();
                    int key = it.key();
                    long sum = it.value();
                    long count = sourceCount.get(key);
                    long average = count != 0L ? sum / count : 0L;
                    @Nullable Integer utid = IUniqueIds.mapIntToNullableUtid(key);
                    binDataWriter.writeData(channelNumber, utid, average);
                    perChannelAggregateSum += sum;
                    perChannelAggregateCount += count;
                    systemWideAggregateSum += sum;
                    systemWideAggregateCount += count;
                }
                sourceSum.clear();
                sourceCount.clear();
            } else {
                binDataWriter.writeData(channelNumber, null, 0L);
            }
            this.channelsWithDataInBin[channelNumber].clear();
            long perChannelAggregateAverage = perChannelAggregateCount != 0L ? perChannelAggregateSum / perChannelAggregateCount : 0L;
            limitsTracker.updatePerChannelLimits(binIndex, channelNumber, BinningDataMode.AVERAGE, perChannelAggregateAverage);
            ++channelNumber;
        }
        long systemWideAggregateAverage = systemWideAggregateCount != 0L ? systemWideAggregateSum / systemWideAggregateCount : 0L;
        limitsTracker.updateAggregateLimits(binIndex, BinningDataMode.AVERAGE, systemWideAggregateAverage);
        binDataWriter.next();
    }
}

