/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.shared.zoomlevelgeneration;

import com.arm.streamline.report.shared.zoomlevelgeneration.BinningDataMode;
import com.arm.streamline.report.shared.zoomlevelgeneration.IZoomLevelGenerator;
import com.arm.utils.function.Throwing;
import java.io.Closeable;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AllModesZoomLevelGenerator
implements IZoomLevelGenerator {
    private final @NonNull IZoomLevelGenerator @NonNull [] individualModes;

    public AllModesZoomLevelGenerator(@NonNull BinningDataMode @NonNull [] supportedModes, @NonNull IZoomLevelGeneratorFactory factory) throws IOException {
        this.individualModes = new IZoomLevelGenerator[supportedModes.length];
        try {
            int i = 0;
            while (i < this.individualModes.length) {
                this.individualModes[i] = factory.create(supportedModes[i]);
                ++i;
            }
        }
        catch (Throwable t) {
            Throwing.closeAll((Closeable[])this.individualModes);
            throw t;
        }
    }

    @Override
    public void close() throws IOException {
        Throwing.closeAll((Closeable[])this.individualModes);
    }

    @Override
    public void consumeCounterValue(int channelNumber, @Nullable Integer utid, long value, boolean happenedInBin) throws IOException {
        IZoomLevelGenerator[] iZoomLevelGeneratorArray = this.individualModes;
        int n = this.individualModes.length;
        int n2 = 0;
        while (n2 < n) {
            IZoomLevelGenerator individualMode = iZoomLevelGeneratorArray[n2];
            individualMode.consumeCounterValue(channelNumber, utid, value, happenedInBin);
            ++n2;
        }
    }

    @Override
    public void discard() {
        IZoomLevelGenerator[] iZoomLevelGeneratorArray = this.individualModes;
        int n = this.individualModes.length;
        int n2 = 0;
        while (n2 < n) {
            IZoomLevelGenerator individualMode = iZoomLevelGeneratorArray[n2];
            individualMode.discard();
            ++n2;
        }
    }

    @Override
    public void nextBaseBin() throws IOException {
        IZoomLevelGenerator[] iZoomLevelGeneratorArray = this.individualModes;
        int n = this.individualModes.length;
        int n2 = 0;
        while (n2 < n) {
            IZoomLevelGenerator individualMode = iZoomLevelGeneratorArray[n2];
            individualMode.nextBaseBin();
            ++n2;
        }
    }

    @FunctionalInterface
    public static interface IZoomLevelGeneratorFactory {
        public @NonNull IZoomLevelGenerator create(@NonNull BinningDataMode var1) throws IOException;
    }
}

