/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.shared.zoomlevelgeneration;

import com.arm.streamline.report.shared.zoomlevelgeneration.BinningDataMode;
import com.arm.streamline.report.shared.zoomlevelgeneration.IZoomLevelBinDataWriter;
import com.arm.streamline.report.shared.zoomlevelgeneration.IZoomLevelGenerator;
import com.arm.streamline.report.shared.zoomlevelgeneration.IZoomLevelLimitsTracker;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractZoomLevelGenerator
implements IZoomLevelGenerator {
    protected final int numberOfChannels;
    protected final int numberOfTicks;
    private final @NonNull IZoomLevelBinDataWriter binDataWriter;
    private final @NonNull IZoomLevelLimitsTracker limitsTracker;
    private int ticksRemaining;

    protected AbstractZoomLevelGenerator(int numberOfTicks, int numberOfChannels, @NonNull BinningDataMode binningDataMode, @NonNull IZoomLevelBinDataWriter binDataWriter, @NonNull IZoomLevelLimitsTracker limitsTracker) {
        this.numberOfTicks = numberOfTicks;
        this.numberOfChannels = numberOfChannels;
        this.binDataWriter = binDataWriter;
        this.limitsTracker = limitsTracker;
        this.ticksRemaining = numberOfTicks;
    }

    @Override
    public final void close() throws IOException {
        if (this.ticksRemaining != this.numberOfTicks) {
            this.writeData(this.binDataWriter, this.limitsTracker, this.ticksRemaining);
        }
        this.binDataWriter.close();
    }

    @Override
    public final void nextBaseBin() throws IOException {
        --this.ticksRemaining;
        if (this.ticksRemaining <= 0) {
            this.ticksRemaining = this.numberOfTicks;
            this.writeData(this.binDataWriter, this.limitsTracker, 0);
        }
    }

    protected abstract void writeData(@NonNull IZoomLevelBinDataWriter var1, @NonNull IZoomLevelLimitsTracker var2, int var3) throws IOException;
}

