/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.shared.zoomlevelgeneration;

import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.shared.zoomlevelgeneration.AbstractZoomLevelGenerator;
import com.arm.streamline.report.shared.zoomlevelgeneration.BinningDataMode;
import com.arm.streamline.report.shared.zoomlevelgeneration.IZoomLevelBinDataWriter;
import com.arm.streamline.report.shared.zoomlevelgeneration.IZoomLevelLimitsTracker;
import com.arm.utils.ArrayUtils;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractMinOrMaxZoomLevelGenerator
extends AbstractZoomLevelGenerator {
    private final @NonNull BinningDataMode binningMode;
    private final @NonNull TIntLongMap @NonNull [] channelData;
    private final @NonNull TIntSet @NonNull [] channelsWithDataInBin;

    public AbstractMinOrMaxZoomLevelGenerator(int numberOfTicks, int numberOfChannels, @NonNull BinningDataMode binningMode, @NonNull IZoomLevelBinDataWriter binDataWriter, @NonNull IZoomLevelLimitsTracker limitsTracker) {
        super(numberOfTicks, numberOfChannels, binningMode, binDataWriter, limitsTracker);
        this.binningMode = binningMode;
        this.channelData = (TIntLongMap[])ArrayUtils.create(TIntLongMap[]::new, (int)numberOfChannels, () -> new TIntLongHashMap(10, 0.5f, -1, 0L));
        this.channelsWithDataInBin = (TIntSet[])ArrayUtils.create(TIntSet[]::new, (int)numberOfChannels, () -> new TIntHashSet(10, 0.5f, 0));
    }

    @Override
    public void consumeCounterValue(int channelNumber, @Nullable Integer utid, long newValue, boolean happenedInBin) throws IOException {
        TIntLongMap destination = this.channelData[channelNumber];
        int key = IUniqueIds.mapNullableUtidToInt(utid);
        boolean alreadyHappenedInBin = this.channelsWithDataInBin[channelNumber].contains(key);
        if (happenedInBin && !alreadyHappenedInBin) {
            destination.put(key, newValue);
        } else if (happenedInBin || !alreadyHappenedInBin) {
            long currentValue = destination.adjustOrPutValue(key, 0L, newValue);
            destination.put(key, this.pickBest(newValue, currentValue));
        }
        if (happenedInBin) {
            this.channelsWithDataInBin[channelNumber].add(key);
        }
    }

    @Override
    public void discard() {
        TIntLongMap[] tIntLongMapArray = this.channelData;
        int n = this.channelData.length;
        int n2 = 0;
        while (n2 < n) {
            TIntLongMap map = tIntLongMapArray[n2];
            map.clear();
            ++n2;
        }
        tIntLongMapArray = this.channelsWithDataInBin;
        n = this.channelsWithDataInBin.length;
        n2 = 0;
        while (n2 < n) {
            TIntLongMap set = tIntLongMapArray[n2];
            set.clear();
            ++n2;
        }
    }

    protected abstract long pickBest(long var1, long var3);

    @Override
    protected void writeData(@NonNull IZoomLevelBinDataWriter binDataWriter, @NonNull IZoomLevelLimitsTracker limitsTracker, int ticksRemaining) throws IOException {
        long binIndex = binDataWriter.getCurrentIndex();
        long systemWideAggregate = 0L;
        boolean seenAnyValue = false;
        int channelNumber = 0;
        while (channelNumber < this.channelData.length) {
            TIntLongMap map = this.channelData[channelNumber];
            long perChannelAggregate = 0L;
            boolean seenChannelValue = false;
            if (!map.isEmpty()) {
                TIntLongIterator it = map.iterator();
                while (it.hasNext()) {
                    it.advance();
                    int key = it.key();
                    long value = it.value();
                    @Nullable Integer utid = IUniqueIds.mapIntToNullableUtid(key);
                    binDataWriter.writeData(channelNumber, utid, value);
                    if (seenChannelValue) {
                        perChannelAggregate = this.pickBest(perChannelAggregate, value);
                    } else {
                        seenChannelValue = true;
                        perChannelAggregate = value;
                    }
                    if (seenAnyValue) {
                        systemWideAggregate = this.pickBest(systemWideAggregate, value);
                        continue;
                    }
                    seenAnyValue = true;
                    systemWideAggregate = value;
                }
                map.clear();
                this.channelsWithDataInBin[channelNumber].clear();
            } else {
                binDataWriter.writeData(channelNumber, null, 0L);
            }
            limitsTracker.updatePerChannelLimits(binIndex, channelNumber, this.binningMode, perChannelAggregate);
            ++channelNumber;
        }
        limitsTracker.updateAggregateLimits(binIndex, this.binningMode, systemWideAggregate);
        binDataWriter.next();
    }
}

