/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.uids;

public abstract class AbstractPerVmId<T extends AbstractPerVmId<T>>
implements Comparable<T> {
    public final int id;
    public final long vmUID;

    protected AbstractPerVmId(long vmUID, int id) {
        this.vmUID = vmUID;
        this.id = id;
    }

    @Override
    public int compareTo(T o) {
        assert (o != null);
        int vmResult = Long.compare(this.vmUID, ((AbstractPerVmId)o).vmUID);
        if (vmResult != 0) {
            return vmResult;
        }
        return Integer.compare(this.id, ((AbstractPerVmId)o).id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractPerVmId) {
            AbstractPerVmId that = (AbstractPerVmId)obj;
            return this.id == that.id && this.vmUID == that.vmUID;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (int)(this.vmUID ^ this.vmUID >>> 32);
        return result;
    }

    public String toString() {
        return String.format("{%d : %d}", this.vmUID, this.id);
    }

    public static final class PerVmCookie
    extends AbstractPerVmId<PerVmCookie> {
        public PerVmCookie(long vmUID, int id) {
            super(vmUID, id);
        }
    }

    public static final class PerVmNonUniquePid
    extends PerVmNonUniquePidOrTid {
        public PerVmNonUniquePid(long vmUID, int id) {
            super(vmUID, id);
        }
    }

    public static abstract class PerVmNonUniquePidOrTid
    extends AbstractPerVmId<PerVmNonUniquePidOrTid> {
        protected PerVmNonUniquePidOrTid(long vmUID, int id) {
            super(vmUID, id);
        }
    }

    public static final class PerVmNonUniqueTid
    extends PerVmNonUniquePidOrTid {
        public PerVmNonUniqueTid(long vmUID, int id) {
            super(vmUID, id);
        }
    }
}

