/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.InvalidVersionException;
import com.arm.streamline.common.model.VariableReplacerConstants;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class VariableReplacer {
    private static final String VARIABLE_REPLACEMENT_XML = "variable_replacement.xml";
    private static final String TAG_VARIABLES = "variables";
    private static final String TAG_VARIABLE = "variable";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_TARGET = "target";
    private static final String ATTR_REPLACEMENT = "replacement";
    private static final int CURRENT_VERSION = 1;
    private final @NonNull Map<@NonNull String, @NonNull String> mVariableMap = new HashMap<String, String>();

    public synchronized void addVariable(String target, String replacement) {
        if (target == null || replacement == null || replacement.contains(target) || target.length() == 0 || replacement.length() == 0) {
            return;
        }
        this.mVariableMap.put(target, replacement);
    }

    /*
     * Unable to fully structure code
     */
    public void readXML(File path) {
        try {
            var2_2 = null;
            var3_7 = null;
            try {
                xml = XMLParser.create((File)new File(path, "variable_replacement.xml"));
                try {
                    while ((tag = xml.nextTag()) != null) {
                        block17: {
                            if (!"variables".equals(tag)) break block17;
                            marker = xml.getMarker();
                            version = xml.getIntegerAttribute("version", 0);
                            if (version <= 1) ** GOTO lbl19
                            throw InvalidVersionException.createReportDirectoryVersionTooNewException();
lbl-1000:
                            // 1 sources

                            {
                                if ("variable".equals(tag)) {
                                    target = xml.getAttribute("target");
                                    replacement = xml.getAttribute("replacement");
                                    this.addVariable(target, replacement);
                                    continue;
                                }
                                xml.skip();
lbl19:
                                // 3 sources

                                ** while ((tag = xml.nextTag((String)marker)) != null)
                            }
lbl20:
                            // 1 sources

                            continue;
                        }
                        xml.skip();
                    }
                }
                finally {
                    if (xml != null) {
                        xml.close();
                    }
                }
            }
            catch (Throwable var3_8) {
                if (var2_2 == null) {
                    var2_2 = var3_8;
                } else if (var2_2 != var3_8) {
                    var2_2.addSuppressed(var3_8);
                }
                throw var2_2;
            }
        }
        catch (FileNotFoundException var2_4) {
        }
        catch (InvalidVersionException exception) {
            CommonPlugin.warning((Throwable)exception);
        }
        catch (Exception exception) {
            CommonPlugin.error((Throwable)exception);
        }
    }

    public synchronized @NonNull String replace(@NonNull String text) {
        Set<@NonNull String> set = this.mVariableMap.keySet();
        boolean repeat = true;
        while (repeat) {
            repeat = false;
            for (String var : set) {
                if (!text.contains(var)) continue;
                text = text.replace(var, (CharSequence)NullChecking.neverNull((Object)this.mVariableMap.get(var)));
                repeat = true;
            }
        }
        return text;
    }

    public void writeXML(@NonNull OutputStream path) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (XMLGenerator xml = new XMLGenerator(path);){
                xml.startDocument();
                xml.startTag(TAG_VARIABLES);
                for (String key : this.mVariableMap.keySet()) {
                    xml.startEmptyTag(TAG_VARIABLE);
                    xml.addAttribute(ATTR_TARGET, key);
                    xml.addAttribute(ATTR_REPLACEMENT, this.mVariableMap.get(key));
                }
                xml.endTag();
                xml.endDocument();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            CommonPlugin.error((Throwable)exception);
        }
    }

    public static @NonNull OutputStream getOutPutStream(@NonNull File path) throws FileNotFoundException {
        return new FileOutputStream(new File(path, VARIABLE_REPLACEMENT_XML));
    }

    public void createClusterVariables(@NonNull IClustersInfo clustersInfo) {
        int[] nArray = clustersInfo.getClusterNames().keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int clusterId = nArray[n2];
            String replacement = clustersInfo.getClusterHumanName(clusterId);
            this.addVariable(VariableReplacerConstants.clusterSuffixId((int)clusterId), replacement);
            this.addVariable(VariableReplacerConstants.clusterVarId((int)clusterId), replacement);
            ++n2;
        }
    }
}

