/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model;

import com.arm.streamline.common.report.model.Messages;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.CountedInputStream;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.io.IProgressProvider;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.jni.apcdbgen.proto.ImageFile;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import com.arm.utils.NullChecking;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImagesAndSourcesLocator {
    public static final String ATTR_DIR = "dir";
    public static final String ATTR_FILE = "file";
    public static final String ATTR_IMAGE = "image";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_TIME_STAMP = "modified_time";
    public static final String STATIC_FILENAME = "icounter/images.xml";
    public static final String TAG_DIR = "dir";
    public static final String TAG_DIRS = "dirs";
    public static final String TAG_FILE = "file";
    public static final String TAG_FILES = "files";
    public static final String TAG_IMAGE_DATA = "image_data";
    private static final @NonNull String INVALID_DIRECTORY = "Source File #{0}: Invalid directory index ({1}).";
    private static final @NonNull String INVALID_IMAGE = "Source File #{0}: Invalid image index ({1}).";
    private static final @NonNull String INVALID_SOURCE_FILE_NAME = "Source File #{0}: Must have a name.";
    private final @NonNull List<@NonNull String> mSourceDirectories = new ArrayList<String>();
    private final @NonNull TIntObjectMap<SourceFile> mSourceFiles = new TIntObjectHashMap(10, 0.5f, -1);
    private final @NonNull TIntObjectMap<ImageFile> mImages = new TIntObjectHashMap(10, 0.5f, -1);
    private @NonNull String mLargestFileName = "";
    private @NonNull String mParentPath;

    private static @NonNull File getFile(File reportDir) {
        return CommonFileUtils.getFile((File)new File(reportDir, STATIC_FILENAME));
    }

    private static @NonNull String validateName(int index, @Nullable String name) throws IOException {
        if (name == null || name.length() == 0) {
            throw new IOException(MessageFormat.format(INVALID_SOURCE_FILE_NAME, index));
        }
        return name;
    }

    public ImagesAndSourcesLocator(@NonNull IProgressTracker tracker, @NonNull File reportDirectory) throws IOException, InterruptedException {
        tracker.setSubTaskTitle(Messages.FILE_SETS);
        @NonNull File file = ImagesAndSourcesLocator.getFile(reportDirectory);
        this.mParentPath = ((File)NullChecking.neverNull((Object)((File)NullChecking.neverNull((Object)file.getParentFile())).getParentFile())).getAbsolutePath();
        Throwable throwable = null;
        Object var5_6 = null;
        try (CountedInputStream cin = new CountedInputStream(file);){
            tracker.setProgressProvider((IProgressProvider)cin);
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (XMLParser in = XMLParser.create((InputStream)cin);){
                String tag;
                while ((tag = in.nextTag()) != null) {
                    if (TAG_IMAGE_DATA.equals(tag)) {
                        this.loadImageData(in, tracker);
                    } else {
                        in.skip();
                    }
                    tracker.update();
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            if (this.mImages.isEmpty()) {
                assert (this.mSourceFiles.isEmpty());
                if (this.mSourceDirectories.isEmpty()) {
                    this.mSourceDirectories.add(this.mParentPath);
                }
                ImageFile anonymousImage = new ImageFile(0L, "<unknown>", null, Collections.emptyList(), false);
                this.mImages.put(0, (Object)anonymousImage);
                this.mLargestFileName = anonymousImage.getNameWithContainer();
            }
            tracker.update();
            tracker.setProgressProvider(null);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private @NonNull String getUnadjustedSourceDirectory(int dirIndex) {
        return this.mSourceDirectories.get(dirIndex);
    }

    public @Nullable SourceFile getSourceFile(int index) {
        return (SourceFile)this.mSourceFiles.get(index);
    }

    public @Nullable ImageFile getImagefile(int index) {
        return (ImageFile)this.mImages.get(index);
    }

    public @NonNull String getLargestFileName() {
        return this.mLargestFileName;
    }

    public String getParentPath() {
        return this.mParentPath;
    }

    public @NonNull List<@NonNull String> getUnadjustedSourceDirectories() {
        return this.mSourceDirectories;
    }

    private void loadDirectories(@NonNull XMLParser in, @NonNull IProgressTracker tracker) throws IOException, InterruptedException {
        String tag;
        String marker = in.getMarker();
        while ((tag = in.nextTag(marker)) != null) {
            if ("dir".equals(tag)) {
                String dir = in.getAttribute(ATTR_NAME);
                if (dir == null) {
                    dir = this.mParentPath;
                } else if (!FilePath.isFullPath((String)dir)) {
                    dir = FilePath.getFullPath((String)this.mParentPath, (String)dir);
                }
                this.mSourceDirectories.add((String)NullChecking.neverNull((Object)FilePath.normalizeFullPath((String)dir)));
            }
            in.skip();
            tracker.update();
        }
        if (this.mSourceDirectories.isEmpty()) {
            this.mSourceDirectories.add(this.mParentPath);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadFiles(@NonNull XMLParser in, @NonNull IProgressTracker tracker) throws IOException, InterruptedException {
        String tag;
        String marker = in.getMarker();
        int count = 0;
        while ((tag = in.nextTag(marker)) != null) {
            if ("file".equals(tag)) {
                int mIndex = in.getIntegerAttribute("file", count++);
                String mName = ImagesAndSourcesLocator.validateName(mIndex, in.getAttribute(ATTR_NAME));
                int mDirIndex = in.getIntegerAttribute("dir", 0);
                if (mDirIndex < 0) {
                    throw new IOException(MessageFormat.format(INVALID_DIRECTORY, mIndex, mDirIndex));
                }
                int mImageIndex = in.getIntegerAttribute(ATTR_IMAGE, 0);
                if (mImageIndex < 0) {
                    throw new IOException(MessageFormat.format(INVALID_IMAGE, mIndex, mImageIndex));
                }
                in.skip();
                assert (mImageIndex <= mIndex);
                if (mImageIndex == mIndex) {
                    this.newImage(mIndex, mName);
                } else {
                    if (mImageIndex >= mIndex) throw new AssertionError((Object)"Invalid images.xml");
                    ImageFile mImageFile = (ImageFile)this.mImages.get(mImageIndex);
                    if (mImageFile == null) {
                        throw new AssertionError((Object)("Missing image for source file " + mName));
                    }
                    this.newSourceFile(mIndex, mDirIndex, mName, mImageFile);
                }
            } else {
                in.skip();
            }
            tracker.update();
        }
    }

    private void newSourceFile(int index, int dirIndex, @NonNull String name, @NonNull ImageFile imageFile) {
        String unadjustedPath = FilePath.getFullPath((String)this.getUnadjustedSourceDirectory(dirIndex), (String)name);
        SourceFile sourceFile = new SourceFile((long)index, imageFile, unadjustedPath);
        SourceFile prev = (SourceFile)this.mSourceFiles.put(index, (Object)sourceFile);
        assert (prev == null);
        this.updateLargestFileName(sourceFile.getFileName());
    }

    private void newImage(int index, @NonNull String name) {
        ImageFile image = new ImageFile((long)index, (String)NullChecking.neverNull((Object)FilePath.getLeafName((String)name)), null, Collections.emptyList(), false);
        ImageFile prev = (ImageFile)this.mImages.put(index, (Object)image);
        assert (prev == null);
        this.updateLargestFileName(image.getNameWithContainer());
    }

    private void updateLargestFileName(@NonNull String name) {
        if (name.length() > this.mLargestFileName.length()) {
            this.mLargestFileName = name;
        }
    }

    private void loadImageData(@NonNull XMLParser in, @NonNull IProgressTracker tracker) throws IOException, InterruptedException {
        String tag;
        String marker = in.getMarker();
        while ((tag = in.nextTag(marker)) != null) {
            if (TAG_DIRS.equals(tag)) {
                this.loadDirectories(in, tracker);
            } else if (TAG_FILES.equals(tag)) {
                this.loadFiles(in, tracker);
            } else {
                in.skip();
            }
            tracker.update();
        }
    }
}

