/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.reportmodel.icounters;

import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.jni.apcdbgen.proto.IExtractable;
import com.arm.streamline.jni.apcdbgen.proto.ImageFile;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.apcdbgen.proto.SourceLocation;
import com.arm.streamline.jni.reportmodel.icounters.CallPathRowValue;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class FunctionRowValue
implements Comparable<FunctionRowValue>,
IExtractable {
    private final @NonNull Set<@NonNull CallPathRowValue> associatedCallPaths;
    private final @NonNull IInstructionCounterSource ownerSource;
    private final @NonNull ReferencedSymbol referencedSymbol;

    public static @Nullable String getLocationLabel(@NonNull IInstructionCounterSource ownerSource, @NonNull ReferencedSymbol referencedSymbol, boolean computeFull) {
        SourceLocation sourceLocation = referencedSymbol.symbol.sourceLocation;
        if (sourceLocation == null) {
            ImageFile image = referencedSymbol.symbol.image;
            return image.getNameWithContainer();
        }
        if (computeFull) {
            return FilePath.getPathForPlatform((String)ownerSource.computeFullPath(sourceLocation.sourceFile)) + ":" + sourceLocation.lineNo;
        }
        return sourceLocation.sourceFile.getFileName() + ":" + sourceLocation.lineNo;
    }

    public static boolean isUnknown(@NonNull ReferencedSymbol referencedSymbol) {
        return referencedSymbol.isUnknown();
    }

    public FunctionRowValue(@NonNull IInstructionCounterSource ownerSource, @NonNull ReferencedSymbol referencedSymbol, @NonNull Set<@NonNull CallPathRowValue> associatedCallPaths) {
        this.ownerSource = ownerSource;
        this.referencedSymbol = referencedSymbol;
        this.associatedCallPaths = Collections.unmodifiableSet(associatedCallPaths);
    }

    @Override
    public int compareTo(@NonNull FunctionRowValue o) {
        return this.referencedSymbol.symbol.compareTo(o.referencedSymbol.symbol);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Object object = obj;
        if (object instanceof FunctionRowValue) {
            void that;
            FunctionRowValue functionRowValue = (FunctionRowValue)object;
            FunctionRowValue cfr_ignored_0 = (FunctionRowValue)object;
            return this.referencedSymbol == that.referencedSymbol;
        }
        return false;
    }

    public <R, E extends Throwable> R accept(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IExtractable.IExtractableVisitor<R, E> visitor) throws E {
        return (R)visitor.visit(this.referencedSymbol, this.associatedCallPaths.stream().map(CallPathRowValue::getCallPathNode).toList());
    }

    public @NonNull Set<@NonNull CallPathRowValue> getAssociatedCallPaths() {
        return this.associatedCallPaths;
    }

    public @Nullable String getImageLabel() {
        if (this.referencedSymbol.symbol.image.isUnknown()) {
            return null;
        }
        return this.referencedSymbol.symbol.image.getNameWithContainer();
    }

    public @Nullable String getLocationLabel(boolean computeFull) {
        return FunctionRowValue.getLocationLabel(this.ownerSource, this.referencedSymbol, computeFull);
    }

    public @NonNull String getName() {
        return this.referencedSymbol.symbol.getName();
    }

    public @NonNull ReferencedSymbol getReferencedSymbol() {
        return this.referencedSymbol;
    }

    public long getSizeInBytes() {
        if (this.isUnknown()) {
            return -1L;
        }
        return this.referencedSymbol.symbol.sizeInBytes;
    }

    public long getStackFrameSize() {
        if (this.isUnknown()) {
            return -1L;
        }
        return this.referencedSymbol.symbol.stackFrameSize;
    }

    public int hashCode() {
        return this.referencedSymbol.hashCode();
    }

    public boolean isUnknown() {
        return FunctionRowValue.isUnknown(this.referencedSymbol);
    }

    public String toString() {
        return this.referencedSymbol.symbol.getName();
    }
}

