/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.reportmodel.icounters;

import com.arm.streamline.jni.apcdbgen.proto.CallPathNode;
import com.arm.streamline.jni.apcdbgen.proto.IExtractable;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class CallPathRowValue
implements Comparable<CallPathRowValue>,
IExtractable {
    private final @NonNull CallPathNode callPathNode;
    private final @NonNull List<@NonNull CallPathRowValue> children;
    private final long cumulativeStackFrameSize;
    private final int depth;
    private final @NonNull IInstructionCounterSource ownerSource;
    private final @Nullable CallPathRowValue parent;

    public CallPathRowValue(@NonNull IInstructionCounterSource ownerSource, @Nullable CallPathRowValue parent, @NonNull CallPathNode callPathNode, @NonNull List<@NonNull CallPathRowValue> children) {
        this.ownerSource = ownerSource;
        this.parent = parent;
        this.callPathNode = callPathNode;
        this.children = Collections.unmodifiableList(children);
        this.depth = parent != null ? parent.depth + 1 : 0;
        ReferencedSymbol symbol = callPathNode.symbol;
        long functionStack = symbol != null ? symbol.symbol.stackFrameSize : 0L;
        long parentStack = parent != null ? parent.cumulativeStackFrameSize : 0L;
        this.cumulativeStackFrameSize = functionStack > 0L ? functionStack + parentStack : parentStack;
    }

    public <R, E extends Throwable> R accept(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IExtractable.IExtractableVisitor<R, E> visitor) throws E {
        return (R)visitor.visit(this.callPathNode);
    }

    @Override
    public int compareTo(@NonNull CallPathRowValue o) {
        return this.callPathNode.compareTo(o.callPathNode);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        Object object = obj;
        if (object instanceof CallPathRowValue) {
            void that;
            CallPathRowValue callPathRowValue = (CallPathRowValue)object;
            CallPathRowValue cfr_ignored_0 = (CallPathRowValue)object;
            return this.callPathNode.equals(that.callPathNode);
        }
        return false;
    }

    public @NonNull CallPathNode getCallPathNode() {
        return this.callPathNode;
    }

    public @NonNull List<@NonNull CallPathRowValue> getChildren() {
        return this.children;
    }

    public @NonNull String getName() {
        return this.callPathNode.label;
    }

    public @NonNull IInstructionCounterSource getOwnerSource() {
        return this.ownerSource;
    }

    public @Nullable CallPathRowValue getOwningThreadOrProcessRow() {
        CallPathRowValue node = this;
        while (node != null) {
            switch (node.callPathNode.type) {
                case PROCESS: 
                case THREAD: {
                    return node;
                }
                case SYMBOL: {
                    node = node.parent;
                    break;
                }
                case VMUID: {
                    return null;
                }
                default: {
                    throw new AssertionError(this.callPathNode.type);
                }
            }
        }
        return null;
    }

    public CallPathRowValue getParent() {
        return this.parent;
    }

    public long getStackSize() {
        return this.cumulativeStackFrameSize;
    }

    public @Nullable String getThreadName() {
        CallPathRowValue root = this.getOwningThreadOrProcessRow();
        if (root == null) {
            return null;
        }
        return root.getName();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int hashCode() {
        return this.callPathNode.hashCode();
    }

    public boolean hasUnknownStack() {
        return this.cumulativeStackFrameSize <= 0L;
    }

    public boolean isDescendantOf(@NonNull CallPathNode node) {
        CallPathRowValue current = this;
        while (current != null) {
            if (current.callPathNode == node) {
                return true;
            }
            current = current.parent;
        }
        return false;
    }

    public boolean isProcessOrThreadNode() {
        switch (this.callPathNode.type) {
            case SYMBOL: 
            case VMUID: {
                return false;
            }
            case PROCESS: 
            case THREAD: {
                return true;
            }
        }
        throw new AssertionError(this.callPathNode.type);
    }

    public boolean isStructureOnlyNode() {
        switch (this.callPathNode.type) {
            case SYMBOL: {
                return false;
            }
            case PROCESS: 
            case THREAD: 
            case VMUID: {
                return true;
            }
        }
        throw new AssertionError(this.callPathNode.type);
    }

    public boolean matches(Pattern pattern) {
        if (pattern.matcher(this.getName()).find()) {
            return true;
        }
        for (CallPathRowValue child : this.children) {
            if (!child.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.callPathNode.toString();
    }
}

