/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.elfdwarf;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public class MappingClassificationRange {
    private final long mAddress;
    private final long mSize;
    private final MappingSymbolClassification mClassification;

    public MappingClassificationRange(long l, long l2, MappingSymbolClassification mappingSymbolClassification) {
        this.mAddress = l;
        this.mSize = l2;
        this.mClassification = mappingSymbolClassification;
    }

    public MappingClassificationRange(long l, long l2, int n) {
        this.mAddress = l;
        this.mSize = l2;
        this.mClassification = MappingSymbolClassification.fromNativeValue(n);
    }

    public long getAddress() {
        return this.mAddress;
    }

    public long getSize() {
        return this.mSize;
    }

    public long getEnd() {
        return this.getAddress() + this.getSize();
    }

    public MappingSymbolClassification getClassification() {
        return this.mClassification;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        @NonNull MappingClassificationRange mappingClassificationRange = (MappingClassificationRange)object;
        return this.mAddress == mappingClassificationRange.mAddress && this.mSize == mappingClassificationRange.mSize && this.mClassification == mappingClassificationRange.mClassification;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mAddress, this.mSize, this.mClassification});
    }

    public String toString() {
        return String.format("{vAddr=0x%x, size=%d, classification=%s}", this.mAddress, this.mSize, this.mClassification.toString());
    }

    public static final class MappingSymbolClassification
    extends Enum<MappingSymbolClassification> {
        public static final /* enum */ MappingSymbolClassification NONE = new MappingSymbolClassification(0);
        public static final /* enum */ MappingSymbolClassification DATA = new MappingSymbolClassification(1);
        public static final /* enum */ MappingSymbolClassification ARM = new MappingSymbolClassification(2);
        public static final /* enum */ MappingSymbolClassification AARCH64 = new MappingSymbolClassification(3);
        public static final /* enum */ MappingSymbolClassification THUMB = new MappingSymbolClassification(4);
        private static final @NonNull MappingSymbolClassification[] cachedValues;
        private final int nativeValue;
        private static final /* synthetic */ MappingSymbolClassification[] $VALUES;

        public static MappingSymbolClassification[] values() {
            return (MappingSymbolClassification[])$VALUES.clone();
        }

        public static MappingSymbolClassification valueOf(String string) {
            return Enum.valueOf(MappingSymbolClassification.class, string);
        }

        private MappingSymbolClassification(int n2) {
            this.nativeValue = n2;
        }

        public static MappingSymbolClassification fromNativeValue(int n) {
            MappingSymbolClassification mappingSymbolClassification = cachedValues[n];
            assert (mappingSymbolClassification.nativeValue == n);
            return mappingSymbolClassification;
        }

        private static /* synthetic */ MappingSymbolClassification[] $values() {
            return new MappingSymbolClassification[]{NONE, DATA, ARM, AARCH64, THUMB};
        }

        static {
            $VALUES = MappingSymbolClassification.$values();
            cachedValues = MappingSymbolClassification.values();
        }
    }
}

