/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.elfdwarf;

import com.arm.streamline.jni.StreamlineLib;
import com.arm.streamline.jni.common.NativeException;
import com.arm.streamline.jni.common.NativeHandle;
import com.arm.streamline.jni.elfdwarf.BasicArchitecture;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImageMetadataReader
implements Closeable {
    private final @NonNull NativeHandle nativeHandle;

    public static boolean isValid(@NonNull File file, boolean bl, @NonNull File file2, @Nullable File file3) {
        try {
            return ImageMetadataReader.isValid(file.getAbsolutePath(), bl, file2.getAbsolutePath(), file3 != null ? file3.getAbsolutePath() : null);
        }
        catch (NativeException | IOException exception) {
            return false;
        }
    }

    private static native long createNativeImageMetadataReader(String var0, String var1) throws IOException;

    private static native void destroyNativeImageMetadataReader(long var0);

    private static native @NonNull ImageDescriptor getImageDescriptor(long var0);

    private static native boolean readNext(long var0, @NonNull ISymbolConsumer var2) throws IOException;

    private static long open(@NonNull File file, @NonNull File file2) throws IOException {
        try {
            return ImageMetadataReader.createNativeImageMetadataReader(file.getAbsolutePath(), file2.getAbsolutePath());
        }
        catch (NativeException nativeException) {
            throw new IOException(nativeException);
        }
    }

    private static native boolean isValid(@NonNull String var0, boolean var1, @NonNull String var2, @Nullable String var3) throws IOException;

    public ImageMetadataReader(@NonNull File file, @NonNull File file2) throws IOException {
        this.nativeHandle = new NativeHandle(ImageMetadataReader.open(file, file2), ImageMetadataReader::destroyNativeImageMetadataReader);
    }

    @Override
    public void close() throws IOException {
        this.nativeHandle.close();
    }

    public @NonNull ImageDescriptor getImageDescriptor() {
        return this.nativeHandle.doWithResult(l -> ImageMetadataReader.getImageDescriptor(l));
    }

    public boolean readNext(@NonNull ISymbolConsumer iSymbolConsumer) throws IOException {
        return this.nativeHandle.doWithResult(l -> ImageMetadataReader.readNext(l, iSymbolConsumer));
    }

    static {
        if (!StreamlineLib.isLoaded) {
            throw new AssertionError((Object)"Failed to load Streamline JNI lib");
        }
    }

    public static final class ImageDescriptor {
        public final @NonNull BasicArchitecture architecture;
        public final long imageHash;
        public final long splitDebugHash;
        public final @NonNull String triple;
        public final @NonNull String subtargetFeatures;
        public final long mappingOffset;
        public final long fileSize;
        public final @NonNull String buildId;
        public final boolean useAddressesNotOffsets;
        public final boolean imageWasProcessedWithDebugData;

        public ImageDescriptor(@NonNull BasicArchitecture basicArchitecture, long l, long l2, @NonNull String string, @NonNull String string2, @NonNull String string3, long l3, long l4, boolean bl, boolean bl2) {
            this.architecture = basicArchitecture;
            this.imageHash = l;
            this.splitDebugHash = l2;
            this.triple = string;
            this.subtargetFeatures = string2;
            this.buildId = string3;
            this.mappingOffset = l3;
            this.fileSize = l4;
            this.useAddressesNotOffsets = bl;
            this.imageWasProcessedWithDebugData = bl2;
        }

        public ImageDescriptor(int n, long l, long l2, @NonNull String string, @NonNull String string2, @NonNull String string3, long l3, long l4, boolean bl, boolean bl2) {
            this(BasicArchitecture.fromNativeValue(n), l, l2, string, string2, string3, l3, l4, bl, bl2);
        }
    }

    public static interface ISymbolConsumer {
        public @NonNull IRegionConsumer onSymbol(@NonNull SymbolRecord var1, long var2, byte @NonNull [] var4) throws IOException;
    }

    public static interface IRegionConsumer {
        public @NonNull IOpCodeConsumer onRegion(long var1,  @NonNull MappingClassificationRange.MappingSymbolClassification var3) throws IOException;
    }

    public static interface IOpCodeConsumer {
        public void onOpcode(boolean var1, long var2, long var4, int var6, long var7, int var9, long var10) throws IOException;
    }

    public static final class SymbolRecord {
        public final long fileOffset;
        public final long address;
        public final long size;
        public final long stackFrameSize;
        public final @NonNull String name;
        public final @NonNull String unmangledName;
        public final @NonNull String @NonNull [] aliasNames;
        public final @NonNull String @NonNull [] unmangledAliasNames;
        public final long sourceFileUID;
        public final int souceLineNo;

        public SymbolRecord(long l, long l2, long l3, long l4, @NonNull String string, @NonNull String string2, @NonNull String @NonNull [] stringArray, @NonNull String @NonNull [] stringArray2, long l5, int n) {
            this.fileOffset = l;
            this.address = l2;
            this.size = l3;
            this.stackFrameSize = l4;
            this.name = string;
            this.unmangledName = string2;
            this.aliasNames = stringArray;
            this.unmangledAliasNames = stringArray2;
            this.sourceFileUID = l5;
            this.souceLineNo = n;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (int)(this.fileOffset ^ this.fileOffset >>> 32);
            n = 31 * n + (int)(this.address ^ this.address >>> 32);
            n = 31 * n + (int)(this.size ^ this.size >>> 32);
            n = 31 * n + (int)(this.stackFrameSize ^ this.stackFrameSize >>> 32);
            n = 31 * n + this.name.hashCode();
            n = 31 * n + this.unmangledName.hashCode();
            n = 31 * n + Arrays.hashCode(this.aliasNames);
            n = 31 * n + Arrays.hashCode(this.unmangledAliasNames);
            n = 31 * n + (int)(this.sourceFileUID ^ this.sourceFileUID >>> 32);
            n = 31 * n + this.souceLineNo;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof SymbolRecord) {
                SymbolRecord symbolRecord = (SymbolRecord)object;
                return this.fileOffset == symbolRecord.fileOffset && this.address == symbolRecord.address && this.size == symbolRecord.size && this.stackFrameSize == symbolRecord.stackFrameSize && this.sourceFileUID == symbolRecord.sourceFileUID && this.souceLineNo == symbolRecord.souceLineNo && Objects.equals(this.name, symbolRecord.name) && Objects.equals(this.unmangledName, symbolRecord.unmangledName) && Arrays.equals(this.aliasNames, symbolRecord.aliasNames) && Arrays.equals(this.unmangledAliasNames, symbolRecord.unmangledAliasNames);
            }
            return false;
        }

        public String toString() {
            return "SymbolRecord [fileOffset=" + this.fileOffset + ", address=" + this.address + ", size=" + this.size + ", stackFrameSize=" + this.stackFrameSize + ", name=" + this.name + ", unmangledName=" + this.unmangledName + ", aliasNames=" + Arrays.toString(this.aliasNames) + ", unmangledAliasNames=" + Arrays.toString(this.unmangledAliasNames) + ", sourceFileUID=" + this.sourceFileUID + ", souceLineNo=" + this.souceLineNo + "]";
        }
    }
}

