/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.elfdwarf;

import com.arm.streamline.jni.StreamlineLib;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.jni.common.FilesystemError;
import com.arm.streamline.jni.common.IProgressMonitor;
import com.arm.streamline.jni.elfdwarf.IInterruptionChecker;
import com.arm.streamline.jni.elfdwarf.SectionRecord;
import com.arm.streamline.jni.elfdwarf.SeparateDwarfInfo;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ElfDwarfParser {
    public static final @NonNull String METADATA_FILE_NAME = "functions.bin";
    public static final @NonNull String OPCODES_FILE_NAME = "opcodes.bin";

    public static @NonNull Map<@NonNull File, @NonNull ImageNameAndEntryPath> findAllImageMetadataPaths(@NonNull File file) throws CodecException, IOException {
        try {
            String[] stringArray = ElfDwarfParser.findAllImageMetadataPaths(file.getAbsolutePath());
            if (stringArray == null || stringArray.length == 0) {
                return Collections.emptyMap();
            }
            if (stringArray.length % 3 != 0) {
                throw new AssertionError((Object)"Unexpected native result");
            }
            HashMap<File, ImageNameAndEntryPath> hashMap = new HashMap<File, ImageNameAndEntryPath>();
            for (int i = 0; i < stringArray.length; i += 3) {
                String string = stringArray[i + 0];
                String string2 = stringArray[i + 1];
                String string3 = stringArray[i + 2];
                if (string == null || string2 == null) {
                    throw new NullPointerException();
                }
                hashMap.put(new File(string), new ImageNameAndEntryPath(string2, string3));
            }
            return hashMap;
        }
        catch (FilesystemError filesystemError) {
            throw new IOException(filesystemError);
        }
    }

    public static boolean isProcessingNeeded(@NonNull File file, @NonNull String @NonNull [] stringArray, boolean bl, boolean bl2) throws CodecException, IOException {
        return ElfDwarfParser.isProcessingNeeded(file.getAbsolutePath(), stringArray, bl, bl2);
    }

    public static @Nullable List<@NonNull ExtractedImage> extractElfDwarfMetadata(@NonNull File file, @NonNull String @NonNull [] stringArray, boolean bl, boolean bl2, @NonNull IProgressMonitor iProgressMonitor, @NonNull IInterruptionChecker iInterruptionChecker) throws CodecException, IOException {
        ExtractedImage[] extractedImageArray = ElfDwarfParser.extractElfDwarfMetadata(file.getAbsolutePath(), stringArray, bl, bl2, iProgressMonitor, iInterruptionChecker);
        if (extractedImageArray == null) {
            return null;
        }
        return Arrays.asList(extractedImageArray);
    }

    public static @NonNull SectionRecord @NonNull [] getSections(@NonNull File file, boolean bl) throws CodecException, IOException {
        return ElfDwarfParser.getSections(file.getAbsolutePath(), bl);
    }

    public static @Nullable SectionRecord findSection(@NonNull File file, @NonNull String string, boolean bl) throws CodecException, IOException {
        return ElfDwarfParser.findSection(file.getAbsolutePath(), string, bl);
    }

    public static @NonNull SeparateDwarfInfo getSeparatedDwarfInfo(@NonNull File file) throws CodecException, IOException {
        return ElfDwarfParser.getSeparatedDwarfInfo(file.getAbsolutePath());
    }

    public static @NonNull String @NonNull [] getPossibleDebugDataLocations(@NonNull File file, @NonNull String string, @NonNull SeparateDwarfInfo separateDwarfInfo) throws CodecException, IOException {
        return ElfDwarfParser.getPossibleDebugDataLocations(file.getPath(), string, separateDwarfInfo.getGnuDebugLinkInfo(), separateDwarfInfo.getGnuBuildId());
    }

    public static final boolean is64Bit(@NonNull File file) throws CodecException, IOException {
        return ElfDwarfParser.is64Bit(file.getAbsolutePath());
    }

    private static native @Nullable String @Nullable [] findAllImageMetadataPaths(@NonNull String var0) throws CodecException, IOException;

    private static @NonNull Comparator<Long> createAddressComparator() {
        return (l, l2) -> Long.compareUnsigned(l, l2);
    }

    private static native boolean isProcessingNeeded(@NonNull String var0, @NonNull String @NonNull [] var1, boolean var2, boolean var3) throws CodecException, IOException;

    private static native @NonNull ExtractedImage @Nullable [] extractElfDwarfMetadata(@NonNull String var0, @NonNull String @NonNull [] var1, boolean var2, boolean var3, @NonNull IProgressMonitor var4, @NonNull IInterruptionChecker var5) throws CodecException, IOException;

    private static native @NonNull SectionRecord @NonNull [] getSections(@NonNull String var0, boolean var1) throws CodecException, IOException;

    private static native @Nullable SectionRecord findSection(@NonNull String var0, @NonNull String var1, boolean var2) throws CodecException, IOException;

    private static native @NonNull SeparateDwarfInfo getSeparatedDwarfInfo(@NonNull String var0) throws CodecException, IOException;

    private static native @NonNull String @NonNull [] getPossibleDebugDataLocations(@NonNull String var0, @NonNull String var1, @Nullable String var2, @Nullable String var3) throws CodecException, IOException;

    private static final native boolean is64Bit(@NonNull String var0) throws CodecException, IOException;

    static {
        if (!StreamlineLib.isLoaded) {
            throw new AssertionError((Object)"Failed to load Streamline JNI lib");
        }
    }

    public static final class ImageNameAndEntryPath {
        public final @NonNull String imageName;
        public final @Nullable String zipEntryName;

        public ImageNameAndEntryPath(@NonNull String string, @Nullable String string2) {
            this.imageName = string;
            this.zipEntryName = string2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ImageNameAndEntryPath) {
                ImageNameAndEntryPath imageNameAndEntryPath = (ImageNameAndEntryPath)object;
                return Objects.equals(this.imageName, imageNameAndEntryPath.imageName) && Objects.equals(this.zipEntryName, imageNameAndEntryPath.zipEntryName);
            }
            return false;
        }

        public int hashCode() {
            String string = this.zipEntryName;
            return this.imageName.hashCode() * 31 ^ (string != null ? string.hashCode() : 0);
        }

        public String toString() {
            String string = this.zipEntryName;
            return string == null ? this.imageName : String.format("%s!%s", this.imageName, string);
        }
    }

    public static final class ExtractedImage {
        public final @NonNull File imagePath;
        public final @Nullable String zipEntryName;

        public ExtractedImage(@NonNull String string) {
            this.imagePath = new File(string);
            this.zipEntryName = null;
        }

        public ExtractedImage(@NonNull String string, @NonNull String string2) {
            this.imagePath = new File(string);
            this.zipEntryName = string2;
        }

        public ExtractedImage(@NonNull File file, @Nullable String string) {
            this.imagePath = file;
            this.zipEntryName = string;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ExtractedImage) {
                ExtractedImage extractedImage = (ExtractedImage)object;
                return Objects.equals(this.imagePath, extractedImage.imagePath) && Objects.equals(this.zipEntryName, extractedImage.zipEntryName);
            }
            return false;
        }

        public int hashCode() {
            String string = this.zipEntryName;
            return this.imagePath.hashCode() * 31 ^ (string != null ? string.hashCode() : 0);
        }

        public String toString() {
            String string = this.zipEntryName;
            return string == null ? this.imagePath.getAbsolutePath() : String.format("%s!%s", this.imagePath.getAbsolutePath(), string);
        }
    }
}

