/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.common;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public enum WarningType {
    INCOMPATIBLE_CHART(0, "incompatible_chart", "Incompatible Charts:"),
    INCOMPATIBLE_SNIPPET(1, "incompatible_snippet", "Incompatible Sticky Snippets:"),
    POWER_CHART_CORRELATION(2, "power_chart_correlation", "Power Chart Correlation:"),
    SESSION_PROCESSOR(3, "session_processor", "Session Processor:"),
    DEVELOPMENT(4, "development", "Development:"),
    ENERGY_METER(5, "energy_meter", "Energy Meter:"),
    GATOR_PROTOCOL(6, "gator_protocol", "Capture Protocol:"),
    COMMUNITY_EDITION(7, "community_edition", "Community Edition:"),
    ANNOTATE(8, "annotate", "Annotate:"),
    DATABASE(9, "database", "Database:"),
    THREADS(10, "threads", "Threads:"),
    ELF_DWARF(11, "elf_dwarf", "Program Image Parsing:"),
    LIVE(12, "live", "Live Capture:"),
    COUNTER_CONFIGURATION(13, "counter_configuration", "Counter Configuration:"),
    CORRUPTION(14, "corruption", "Data Corruption:"),
    OPENCL(15, "opencl", "OpenCL:"),
    MISC(16, "misc", "Miscellaneous:"),
    CAM(17, "cam", "Custom Activity Map:"),
    LICENSING(18, "licensing", "Licensing:"),
    RETRIEVE_IMAGE(19, "retrieve_image", "Retrieve Image:"),
    GATOR_SETUP(20, "gator_setup", "Capture Setup:"),
    BARMAN_STM(21, "barman_stm", "Bare-Metal STM:"),
    BARMAN_DWT(22, "barman_dwt", "Bare-Metal DWT:"),
    ARMNN(23, "armnn", "ArmNN:"),
    ASTF(24, "astf", "ASTF Trace Format:"),
    GPULAYERS_TIMELINE(25, "gpulayers_timeline", "GPU Layers Timeline:");

    private final int ord;
    private final @NonNull String xmlKey;
    private final @NonNull String title;

    public static final @NonNull WarningType get(@Nullable String string, @NonNull WarningType warningType) {
        if (string != null) {
            string = string.trim().toLowerCase();
            int n = WarningType.tryParseOrd(string);
            for (WarningType warningType2 : WarningType.values()) {
                if (warningType2.ord != n && !warningType2.xmlKey.contentEquals(string)) continue;
                return warningType2;
            }
        }
        return warningType;
    }

    public static final @Nullable WarningType fromCxxOrdinal(int n) {
        for (WarningType warningType : WarningType.values()) {
            if (warningType.ord != n) continue;
            return warningType;
        }
        return null;
    }

    private static final int tryParseOrd(@NonNull String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private WarningType(@NonNull int n2, String string2, String string3) {
        this.ord = n2;
        this.xmlKey = string2;
        this.title = string3;
    }

    public final @NonNull String getXmlKey() {
        return this.xmlKey.toLowerCase();
    }

    public final @NonNull String toString() {
        return this.title;
    }
}

