/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.common;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EclipseLogSink {
    private static final Logger logger = Logger.getLogger("JNI");
    private static final @NonNull Consumers CONSUMERS = EclipseLogSink.initConsumers();

    public static void info(long l, @NonNull String string, int n, @NonNull String string2) {
        EclipseLogSink.CONSUMERS.info.accept(l, string, n, string2);
        logger.info(() -> EclipseLogSink.formatMessage(l, string, n, string2));
    }

    public static void warn(long l, @NonNull String string, int n, @NonNull String string2) {
        EclipseLogSink.CONSUMERS.warn.accept(l, string, n, string2);
        logger.warning(() -> EclipseLogSink.formatMessage(l, string, n, string2));
    }

    public static void error(long l, @NonNull String string, int n, @NonNull String string2) {
        EclipseLogSink.CONSUMERS.error.accept(l, string, n, string2);
        logger.severe(() -> EclipseLogSink.formatMessage(l, string, n, string2));
    }

    public static void trace(long l, @NonNull String string, int n, @NonNull String string2) {
        EclipseLogSink.CONSUMERS.trace.accept(l, string, n, string2);
        logger.finer(() -> EclipseLogSink.formatMessage(l, string, n, string2));
    }

    public static void debug(long l, @NonNull String string, int n, @NonNull String string2) {
        EclipseLogSink.CONSUMERS.debug.accept(l, string, n, string2);
        logger.fine(() -> EclipseLogSink.formatMessage(l, string, n, string2));
    }

    public static void fatal(long l, @NonNull String string, int n, @NonNull String string2) {
        EclipseLogSink.CONSUMERS.fatal.accept(l, string, n, string2);
        logger.severe(() -> EclipseLogSink.formatMessage(l, string, n, string2));
    }

    private static @NonNull String formatMessage(long l, @NonNull String string, int n, @NonNull String string2) {
        return String.format("[%s:%d] @ %d.%06d: %s", string, n, l / 1000000L, l % 1000000L, string2);
    }

    private static <T> @NonNull T neverNull(@Nullable T t) throws NullPointerException {
        if (t != null) {
            return t;
        }
        throw new NullPointerException();
    }

    private static @NonNull Consumers initConsumers() {
        String string = System.getProperty("streamline.native_log_level");
        string = string != null ? string.strip() : "";
        boolean bl = "trace".equalsIgnoreCase(string);
        boolean bl2 = bl || EclipseLogSink.class.desiredAssertionStatus() || "debug".equalsIgnoreCase(string);
        boolean bl3 = bl2 || EclipseLogSink.class.desiredAssertionStatus() || "info".equalsIgnoreCase(string);
        IConsumer iConsumer = EclipseLogSink.makeStdConsumer(bl, "TRACE", System.err);
        IConsumer iConsumer2 = EclipseLogSink.makeStdConsumer(bl2, "DEBUG", System.err);
        IConsumer iConsumer3 = EclipseLogSink.makeStdConsumer(bl3, "INFO", System.out);
        IConsumer iConsumer4 = EclipseLogSink.makeStdConsumer(true, "WARNING", System.err);
        IConsumer iConsumer5 = EclipseLogSink.makeStdConsumer(true, "ERROR", System.err);
        IConsumer iConsumer6 = EclipseLogSink.makeStdConsumer(true, "FATAL", System.err);
        try {
            Class<?> clazz = Class.forName("org.eclipse.core.runtime.ILog");
            Method method = EclipseLogSink.neverNull(clazz.getDeclaredMethod("of", Class.class));
            Method method2 = EclipseLogSink.neverNull(clazz.getDeclaredMethod("info", String.class));
            Method method3 = EclipseLogSink.neverNull(clazz.getDeclaredMethod("warn", String.class));
            Method method4 = EclipseLogSink.neverNull(clazz.getDeclaredMethod("error", String.class));
            Object object = EclipseLogSink.neverNull(method.invoke(null, EclipseLogSink.class));
            iConsumer = EclipseLogSink.makeLogInvoke(object, method2, iConsumer, "TRACE", bl);
            iConsumer2 = EclipseLogSink.makeLogInvoke(object, method2, iConsumer2, "DEBUG", bl2);
            iConsumer3 = EclipseLogSink.makeLogInvoke(object, method2, iConsumer3, "", bl3);
            iConsumer4 = EclipseLogSink.makeLogInvoke(object, method3, iConsumer4, "", true);
            iConsumer5 = EclipseLogSink.makeLogInvoke(object, method4, iConsumer5, "", true);
            iConsumer6 = EclipseLogSink.makeLogInvoke(object, method4, iConsumer6, "FATAL", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return new Consumers(iConsumer, iConsumer2, iConsumer3, iConsumer4, iConsumer5, iConsumer6);
    }

    private static @NonNull IConsumer makeStdConsumer(boolean bl, @NonNull String string4, @NonNull PrintStream printStream) {
        if (!bl) {
            return (l, string, n, string2) -> {};
        }
        return (l, string2, n, string3) -> printStream.printf("%s: [%s:%d] @ %d.%06d: %s%n", string4, string2, n, l / 1000000L, l % 1000000L, string3);
    }

    private static @NonNull IConsumer makeLogInvoke(@NonNull Object object, @NonNull Method method, IConsumer iConsumer, @NonNull String string4, boolean bl) {
        if (!bl) {
            return (l, string, n, string2) -> {};
        }
        return (l, string2, n, string3) -> {
            try {
                String string4 = string4.isBlank() ? String.format("%s (reported in [%s:%d] @ %d.%06d)", string3, string2, n, l / 1000000L, l % 1000000L) : String.format("%s: %s (reported in [%s:%d] @ %d.%06d)", string4, string3, string2, n, l / 1000000L, l % 1000000L);
                method.invoke(object, string4);
            }
            catch (Throwable throwable) {
                iConsumer.accept(l, string2, n, string3);
            }
        };
    }

    private record Consumers(@NonNull IConsumer trace, @NonNull IConsumer debug, @NonNull IConsumer info, @NonNull IConsumer warn, @NonNull IConsumer error, @NonNull IConsumer fatal) {
    }

    @FunctionalInterface
    private static interface IConsumer {
        public void accept(long var1, @NonNull String var3, int var4, @NonNull String var5);
    }
}

