/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.proto.cols;

import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnValueVisitor;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterDataSingleAccessor;
import com.arm.streamline.jni.apcdbgen.proto.cols.SimpleColumnDescriptor;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class NumberValueSingleAccessor
implements ISampleCounterDataSingleAccessor,
IColumnDescriptor.ISimpleValueColumnDescriptor {
    private final @NonNull IColumnDescriptor descriptor;
    private final @NonNull IColumnDescriptor.ISimpleValueColumnDescriptor.SingleValueFormat format;
    private final @Nullable Integer userDefinedRGB;
    private final @NonNull Supplier<@Nullable Number> valueSupplier;

    public NumberValueSingleAccessor(@NonNull SimpleColumnDescriptor simpleColumnDescriptor, @NonNull IColumnDescriptor.ISimpleValueColumnDescriptor.SingleValueFormat singleValueFormat, @Nullable Integer n, @NonNull Supplier<@Nullable Number> supplier) {
        this.descriptor = simpleColumnDescriptor;
        this.format = singleValueFormat;
        this.userDefinedRGB = n;
        this.valueSupplier = supplier;
    }

    @Override
    public <D, R, E extends Throwable> R getColumnValue(@NonNull ISampleCounterColumnValueVisitor<D, R, E> iSampleCounterColumnValueVisitor, D d) throws E {
        Number number = this.valueSupplier.get();
        if (number == null) {
            return iSampleCounterColumnValueVisitor.empty(d, this.descriptor);
        }
        if (number instanceof Float || number instanceof Double) {
            return iSampleCounterColumnValueVisitor.number(d, (IColumnDescriptor.ISimpleValueColumnDescriptor)this, number.doubleValue());
        }
        assert (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long);
        return iSampleCounterColumnValueVisitor.number(d, (IColumnDescriptor.ISimpleValueColumnDescriptor)this, number.longValue());
    }

    @Override
    public @NonNull IColumnDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public @NonNull IColumnDescriptor.ISimpleValueColumnDescriptor.SingleValueFormat getFormat() {
        return this.format;
    }

    @Override
    public double getRankingValue() {
        Number number = this.valueSupplier.get();
        return number != null ? number.doubleValue() : 0.0;
    }

    @Override
    public @Nullable Integer getUserDefinedRGB() {
        return this.userDefinedRGB;
    }
}

