/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.proto.cols;

import com.arm.streamline.jni.apcdbgen.proto.HistogramDataPoint;
import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnAccessorFactory;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnValueVisitor;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterDataSingleAccessor;
import com.arm.streamline.jni.apcdbgen.proto.cols.HistogramColumnDescriptor;
import com.arm.streamline.jni.apcdbgen.proto.cols.HistogramMode;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class HistogramValueSingleAccessor
implements ISampleCounterDataSingleAccessor,
IColumnDescriptor.IHistogramColumnDescriptor {
    private final @NonNull HistogramDataPoint @NonNull [] datapoints;
    private final @NonNull IColumnDescriptor descriptor;
    private final @NonNull HistogramMode mode;
    private final boolean scaleRelativeToLimit;
    private final int typicalBinCount;
    private final @Nullable Integer userDefinedRGB;
    private final @NonNull Supplier<@Nullable ISampleCounterColumnAccessorFactory.HistogramValue> valueSupplier;

    public HistogramValueSingleAccessor(@NonNull HistogramColumnDescriptor histogramColumnDescriptor, @NonNull HistogramDataPoint @NonNull [] histogramDataPointArray, boolean bl, @Nullable Integer n, int n2, @NonNull HistogramMode histogramMode, @NonNull Supplier<@Nullable ISampleCounterColumnAccessorFactory.HistogramValue> supplier) {
        this.descriptor = histogramColumnDescriptor;
        this.datapoints = histogramDataPointArray;
        this.scaleRelativeToLimit = bl;
        this.userDefinedRGB = n;
        this.typicalBinCount = n2;
        this.mode = histogramMode;
        this.valueSupplier = supplier;
    }

    @Override
    public <D, R, E extends Throwable> R getColumnValue(@NonNull ISampleCounterColumnValueVisitor<D, R, E> iSampleCounterColumnValueVisitor, D d) throws E {
        ISampleCounterColumnAccessorFactory.HistogramValue histogramValue = this.valueSupplier.get();
        return histogramValue != null ? iSampleCounterColumnValueVisitor.histogram(d, this, histogramValue.scalingLimit(), histogramValue.values()) : iSampleCounterColumnValueVisitor.empty(d, this.descriptor);
    }

    @Override
    public @NonNull HistogramDataPoint @NonNull [] getDatapoints() {
        return this.datapoints;
    }

    @Override
    public @NonNull IColumnDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public double getRankingValue() {
        ISampleCounterColumnAccessorFactory.HistogramValue histogramValue = this.valueSupplier.get();
        if (histogramValue == null) {
            return 0.0;
        }
        long l = 0L;
        block4: for (int i = 0; i < this.datapoints.length; ++i) {
            long l2 = histogramValue.values()[i];
            switch (this.mode) {
                case DEFAULT: {
                    l += (long)i * l2;
                    continue block4;
                }
                case LOG2_N_PLUS_1: {
                    l += (2L << i) * l2;
                    continue block4;
                }
                default: {
                    throw new AssertionError((Object)this.mode);
                }
            }
        }
        return l;
    }

    @Override
    public int getTypicalBinCount() {
        return this.typicalBinCount;
    }

    @Override
    public @Nullable Integer getUserDefinedRGB() {
        return this.userDefinedRGB;
    }

    @Override
    public boolean shouldScaleRelativeToLimit() {
        return this.scaleRelativeToLimit;
    }
}

