/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.proto;

import com.arm.streamline.jni.apcdbgen.proto.IBasicSourceReference;
import com.arm.streamline.jni.apcdbgen.proto.ImageFile;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SourceLocation
implements Comparable<SourceLocation>,
IBasicSourceReference {
    public final int lineNo;
    public final @NonNull SourceFile sourceFile;

    public static boolean equals(@Nullable SourceLocation sourceLocation, @Nullable SourceLocation sourceLocation2) {
        if (sourceLocation == sourceLocation2) {
            return true;
        }
        if (sourceLocation == null || sourceLocation2 == null) {
            return false;
        }
        return sourceLocation.equals(sourceLocation2);
    }

    public SourceLocation(long l, @NonNull ImageFile imageFile, @NonNull String string, int n) {
        this(new SourceFile(l, imageFile, string), n);
    }

    public SourceLocation(@NonNull SourceFile sourceFile, int n) {
        this.sourceFile = sourceFile;
        this.lineNo = n;
    }

    @Override
    public int compareTo(@NonNull SourceLocation sourceLocation) {
        int n = this.sourceFile.compareTo(sourceLocation.sourceFile);
        if (n == 0) {
            n = Integer.compare(this.lineNo, sourceLocation.lineNo);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SourceLocation) {
            SourceLocation sourceLocation = (SourceLocation)object;
            return this.equals(sourceLocation);
        }
        return false;
    }

    public boolean equals(@NonNull SourceLocation sourceLocation) {
        return this.lineNo == sourceLocation.lineNo && this.sourceFile.equals(sourceLocation.sourceFile);
    }

    @Override
    public @NonNull SourceFile getSourceFile() {
        return this.sourceFile;
    }

    public int hashCode() {
        return this.sourceFile.hashCode() * 31 ^ Integer.hashCode(this.lineNo);
    }

    public String toString() {
        return "SourceLocation [sourceFile=" + String.valueOf(this.sourceFile) + ", lineNo=" + this.lineNo + "]";
    }
}

