/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.proto;

import com.arm.streamline.jni.apcdbgen.proto.Symbol;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ImageFile {
    public static final long UNKNOWN_UID = 0L;
    public final @Nullable String containerName;
    public final @NonNull String imageName;
    public final boolean is64bit;
    public final @NonNull List<@NonNull Symbol> symbols;
    public final long uid;

    public static void sortSymbols(@NonNull List<@NonNull Symbol> list) {
        list.sort(Comparator.naturalOrder());
    }

    public ImageFile(long l, @NonNull String string, @Nullable String string2, @NonNull List<@NonNull Symbol> list, boolean bl) {
        this.uid = l;
        this.imageName = string;
        this.containerName = string2;
        this.symbols = Collections.unmodifiableList(list);
        this.is64bit = bl;
        ImageFile.sortSymbols(list);
    }

    public boolean equals(@NonNull ImageFile imageFile) {
        return this.uid == imageFile.uid && this.is64bit == imageFile.is64bit && this.imageName.contentEquals(imageFile.imageName) && Objects.equals(this.containerName, imageFile.containerName);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ImageFile) {
            ImageFile imageFile = (ImageFile)object;
            return this.equals(imageFile);
        }
        return false;
    }

    public @NonNull String getNameWithContainer() {
        String string = this.containerName;
        if (string == null || string.isBlank()) {
            return this.imageName;
        }
        return String.format("%s (%s)", string, this.imageName);
    }

    public int hashCode() {
        return Long.hashCode(this.uid);
    }

    public boolean isUnknown() {
        return this.uid == 0L;
    }

    public String toString() {
        return "Image [uid=" + this.uid + ", imageName=" + this.imageName + ", containerName=" + this.containerName + ", is64bit=" + this.is64bit + "]";
    }
}

