/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.proto;

import com.arm.streamline.jni.apcdbgen.proto.AccelerationStructureTransferType;
import com.arm.streamline.jni.apcdbgen.proto.ILabelVisitor;
import com.arm.streamline.jni.apcdbgen.proto.TimelineWorkload;
import org.eclipse.jdt.annotation.NonNull;

public final class AccelerationStructureTransfer
extends TimelineWorkload {
    private static final @NonNull String WORKLOAD_NAME = "Acceleration Structure Transfer";
    private final int byteCount;
    private final @NonNull AccelerationStructureTransferType type;

    public AccelerationStructureTransfer(@NonNull String @NonNull [] stringArray, long l, long l2, long l3, int n, @NonNull AccelerationStructureTransferType accelerationStructureTransferType) {
        super(WORKLOAD_NAME, stringArray, l, l2, l3);
        this.byteCount = n;
        this.type = accelerationStructureTransferType;
        this.addProperties();
    }

    @Override
    public void accept(@NonNull ILabelVisitor iLabelVisitor) {
        iLabelVisitor.visit(this);
    }

    private void addProperties() {
        if (this.byteCount < 0) {
            this.addProperty("Transfer size", "Unknown");
        } else {
            String string = this.byteCount != 1 ? "s" : "";
            this.addProperty("Transfer size", String.format("%d primitive%s", this.byteCount, string));
        }
    }

    public @NonNull AccelerationStructureTransferType getBuildType() {
        return this.type;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    @Override
    public String toString() {
        return "AccelerationStructureTransfer[byteCount=" + this.byteCount + ", type=" + String.valueOf((Object)this.type) + ", super=" + super.toString() + "]";
    }

    @Override
    public int getColor() {
        return TimelineWorkload.WorkloadColor.ACCELERATION_STRUCTURE_TRANSFER.getHex();
    }
}

