/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.impl.cam;

import com.arm.streamline.jni.apcdbgen.impl.CAMDataProvider;
import com.arm.streamline.jni.apcdbgen.impl.cam.CAMTrackVisitor;
import com.arm.streamline.jni.apcdbgen.impl.cam.ICAMTrackVisitor;
import com.arm.streamline.jni.apcdbgen.impl.cam.ICAMViewVisitor;
import com.arm.streamline.jni.apcdbgen.proto.ICAMDataProvider;
import com.arm.streamline.jni.apcdbgen.proto.PerfettoWorkload;
import com.arm.streamline.jni.apcdbgen.proto.TimelineWorkload;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;

public class CAMViewVisitor
implements ICAMViewVisitor {
    private final @NonNull List<@NonNull CAMDataProvider> views = new ArrayList<CAMDataProvider>();
    private final @NonNull List<@NonNull CAMTrackVisitor> roots = new ArrayList<CAMTrackVisitor>();
    private final @NonNull Map<@NonNull Long, @NonNull Map<@NonNull Long, @NonNull TimelineWorkload>> timelineWorkloads;
    private final @NonNull Map<@NonNull Long, @NonNull Map<@NonNull Long, @NonNull PerfettoWorkload>> perfettoWorkloads;

    public CAMViewVisitor(@NonNull Map<@NonNull Long, @NonNull Map<@NonNull Long, @NonNull TimelineWorkload>> map, @NonNull Map<@NonNull Long, @NonNull Map<@NonNull Long, @NonNull PerfettoWorkload>> map2) {
        this.timelineWorkloads = map;
        this.perfettoWorkloads = map2;
    }

    @Override
    public @NonNull ICAMTrackVisitor visit(long l, long l2, int n, @NonNull String string, long l3) {
        CAMDataProvider cAMDataProvider = new CAMDataProvider(l2, CAMDataProvider.CAMTimelineType.mapJniValue(n), this.views.size() + 1, string, l3);
        this.views.add(cAMDataProvider);
        Map<Long, TimelineWorkload> map = this.timelineWorkloads.get(l);
        Map<Long, PerfettoWorkload> map2 = this.perfettoWorkloads.get(l);
        CAMTrackVisitor cAMTrackVisitor = new CAMTrackVisitor(cAMDataProvider, map != null ? map : Collections.emptyMap(), map2 != null ? map2 : Collections.emptyMap());
        this.roots.add(cAMTrackVisitor);
        return cAMTrackVisitor;
    }

    public @NonNull List<@NonNull ICAMDataProvider> finish() {
        this.roots.forEach(CAMTrackVisitor::updateDependencies);
        this.views.stream().forEach(CAMDataProvider::sortJobs);
        return this.views.stream().collect(Collectors.toList());
    }
}

