/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.impl.cam;

import com.arm.streamline.jni.apcdbgen.impl.CAMDataProvider;
import com.arm.streamline.jni.apcdbgen.impl.CAMJob;
import com.arm.streamline.jni.apcdbgen.impl.CAMTrack;
import com.arm.streamline.jni.apcdbgen.impl.GPUWorkloadJob;
import com.arm.streamline.jni.apcdbgen.impl.cam.CAMJobAndTrackVisitor;
import com.arm.streamline.jni.apcdbgen.impl.cam.ICAMJobAndTrackVisitor;
import com.arm.streamline.jni.apcdbgen.impl.cam.ICAMTrackVisitor;
import com.arm.streamline.jni.apcdbgen.proto.PerfettoWorkload;
import com.arm.streamline.jni.apcdbgen.proto.TimelineWorkload;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CAMTrackVisitor
implements ICAMTrackVisitor {
    private final @NonNull CAMDataProvider view;
    private final @NonNull Map<@NonNull Integer, @NonNull CAMJob> jobs;
    private final @NonNull Map<@NonNull Long, @NonNull TimelineWorkload> workloads;
    private final @NonNull Map<@NonNull Long, @NonNull PerfettoWorkload> perfetto;

    public CAMTrackVisitor(@NonNull CAMDataProvider cAMDataProvider, @NonNull Map<@NonNull Long, @NonNull TimelineWorkload> map, @NonNull Map<@NonNull Long, @NonNull PerfettoWorkload> map2) {
        this.view = cAMDataProvider;
        this.jobs = new HashMap<Integer, CAMJob>();
        this.workloads = map;
        this.perfetto = map2;
    }

    public @Nullable TimelineWorkload getTimelineWorkload(long l) {
        return this.workloads.get(l);
    }

    public @Nullable PerfettoWorkload getPerfettoWorkload(long l) {
        return this.perfetto.get(l);
    }

    @Override
    public @NonNull ICAMJobAndTrackVisitor visit(int n, @NonNull String string) {
        CAMTrack cAMTrack = new CAMTrack(string, n, null);
        this.view.addTrack(cAMTrack);
        this.view.addTrackNonHierarchical(cAMTrack);
        return new CAMJobAndTrackVisitor(this, this.view, cAMTrack);
    }

    void updateDependencies() {
        this.jobs.values().stream().forEach(cAMJob -> cAMJob.updateDependencies(this.jobs));
    }

    void addJob(@NonNull CAMJob cAMJob) {
        this.jobs.put(cAMJob.getId(), cAMJob);
        this.view.addJob(cAMJob);
    }

    void addGPUWorkloadJob(@NonNull GPUWorkloadJob gPUWorkloadJob) {
        this.view.addGPUWorkloadJob(gPUWorkloadJob);
    }
}

