/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.impl;

import com.arm.streamline.jni.apcdbgen.impl.ListOfUIDObjects;
import com.arm.streamline.jni.apcdbgen.impl.SamplesReport;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportPeriodicSamplesData;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import gnu.trove.map.TLongLongMap;
import gnu.trove.map.hash.TLongLongHashMap;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SamplesReportPeriodicSamplesData
implements ISamplesReportPeriodicSamplesData {
    private final @NonNull String description;
    private final @NonNull List<@NonNull ReferencedSymbol> referencedSymbols;
    private final @NonNull SamplesReport samplesReport;
    private final @NonNull TLongLongMap symbolValues;
    private final @NonNull String title;
    private final long total;
    private final @NonNull String units;

    protected static @Nullable SamplesReportPeriodicSamplesData tryFromHandle(@NonNull SamplesReport samplesReport, @NonNull String string, @NonNull String string2, @NonNull String string3, long @NonNull [] lArray, long @NonNull [] lArray2, int n) {
        return new SamplesReportPeriodicSamplesData(samplesReport, string, string2, string3, lArray, lArray2, n);
    }

    private static native void destroyHandle(long var0);

    private static native long getTotalValue(long var0);

    private static native @Nullable Long getValueFor(long var0, long var2);

    private SamplesReportPeriodicSamplesData(@NonNull SamplesReport samplesReport, @NonNull String string, @NonNull String string2, @NonNull String string3, long @NonNull [] lArray, long @NonNull [] lArray2, int n) {
        this.samplesReport = samplesReport;
        this.title = string;
        this.description = string2;
        this.units = string3;
        this.referencedSymbols = new ArrayList<ReferencedSymbol>(n);
        this.symbolValues = new TLongLongHashMap(n, 0.5f, -1L, -1L);
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            long l2 = lArray[i];
            long l3 = lArray2[i];
            ReferencedSymbol referencedSymbol3 = ListOfUIDObjects.findObjectByUID(samplesReport.getSymbols(), l2, referencedSymbol -> referencedSymbol.uid);
            if (referencedSymbol3 == null) {
                throw new AssertionError((Object)("Missing symbol " + l2));
            }
            this.referencedSymbols.add(referencedSymbol3);
            this.symbolValues.put(l2, l3);
            l += l3;
        }
        this.total = l;
        this.referencedSymbols.sort((referencedSymbol, referencedSymbol2) -> {
            long l;
            long l2 = this.symbolValues.get(referencedSymbol.uid);
            int n = -Long.compare(l2, l = this.symbolValues.get(referencedSymbol2.uid));
            if (n == 0) {
                n = referencedSymbol.symbol.compareTo(referencedSymbol2.symbol);
            }
            return n;
        });
    }

    @Override
    public @NonNull String getDescription() {
        return this.description;
    }

    @Override
    public @NonNull List<@NonNull ReferencedSymbol> getReferencedSymbols() {
        return this.referencedSymbols;
    }

    @Override
    public @NonNull String getTitle() {
        return this.title;
    }

    @Override
    public long getTotalValue() {
        return this.total;
    }

    @Override
    public @NonNull String getUnits() {
        return this.units;
    }

    @Override
    public @Nullable Long getValueFor(long l) {
        long l2 = this.symbolValues.get(l);
        return l2 > 0L ? Long.valueOf(l2) : null;
    }
}

