/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.impl;

import com.arm.streamline.jni.apcdbgen.ProfilingLoadOptions;
import com.arm.streamline.jni.apcdbgen.impl.IUniqueIDsHelper;
import com.arm.streamline.jni.apcdbgen.impl.SamplesReport;
import com.arm.streamline.jni.apcdbgen.proto.CallPathNode;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueProcessID;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueThreadID;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class CallPathNodeBuilder {
    protected final @NonNull IGroupImplementation implementation;

    public CallPathNodeBuilder(@NonNull IUniqueIDsHelper iUniqueIDsHelper, @NonNull List<@NonNull ReferencedSymbol> list, long @NonNull [] lArray, long @NonNull [] lArray2, @NonNull ProfilingLoadOptions.GroupingMode groupingMode) {
        switch (groupingMode) {
            case SYSTEM_WIDE: 
            case INVERTED_SYSTEM_WIDE: {
                this.implementation = new SystemWideImplementation(list, lArray2);
                break;
            }
            case PROCESS: {
                this.implementation = new ProcessImplementation(iUniqueIDsHelper, list, lArray2);
                break;
            }
            case THREAD: {
                this.implementation = new ProcessThreadImplementation(iUniqueIDsHelper, list, lArray2);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unexpected GroupingMode value");
            }
        }
    }

    public @NonNull CallPathNode @NonNull [] getRealRoots() {
        return this.implementation.getRealRoots();
    }

    public @NonNull CallPathNode makeForReferencedSymbolUID(@NonNull CallPathNode callPathNode, long l, @NonNull CallPathNode @NonNull [] callPathNodeArray) {
        return this.implementation.makeForReferencedSymbolUID(callPathNode, l, callPathNodeArray);
    }

    public @NonNull CallPathNode makeForThreadUID(long l, long l2, @NonNull CallPathNode @NonNull [] callPathNodeArray) {
        return this.implementation.makeForThreadUID(l, l2, callPathNodeArray);
    }

    protected static final class SystemWideImplementation
    implements IGroupImplementation {
        protected @Nullable CallPathNode systemWideCallStacksRoot = null;
        protected final @NonNull List<@NonNull ReferencedSymbol> referencedSymbols;
        protected long uidCounter = 0L;

        public SystemWideImplementation(@NonNull List<@NonNull ReferencedSymbol> list, long @NonNull [] lArray) {
            if (lArray.length > 1) {
                throw new IllegalArgumentException("Invalid call, expected at most one root node");
            }
            this.referencedSymbols = list;
        }

        @Override
        public @NonNull CallPathNode @NonNull [] getRealRoots() {
            CallPathNode callPathNode = this.systemWideCallStacksRoot;
            if (callPathNode == null) {
                return new CallPathNode[0];
            }
            return callPathNode.children;
        }

        @Override
        public @NonNull CallPathNode makeForReferencedSymbolUID(@NonNull CallPathNode callPathNode, long l, @NonNull CallPathNode @NonNull [] callPathNodeArray) {
            ReferencedSymbol referencedSymbol = SamplesReport.findReferencedSymbolByUid(this.referencedSymbols, l);
            if (referencedSymbol == null) {
                throw new AssertionError((Object)("Missing symbol " + l));
            }
            String string = referencedSymbol.symbol.getName();
            return new CallPathNode(CallPathNode.Type.SYMBOL, ++this.uidCounter, referencedSymbol.uid, null, referencedSymbol, string, callPathNodeArray, callPathNode != this.systemWideCallStacksRoot ? callPathNode : null);
        }

        @Override
        public @NonNull CallPathNode makeForThreadUID(long l, long l2, @NonNull CallPathNode @NonNull [] callPathNodeArray) {
            CallPathNode callPathNode;
            if (this.systemWideCallStacksRoot != null) {
                throw new AssertionError((Object)"system-wide call stacks root called twice");
            }
            this.systemWideCallStacksRoot = callPathNode = new CallPathNode(CallPathNode.Type.VMUID, ++this.uidCounter, 0L, null, null, "All Items", callPathNodeArray, null);
            return callPathNode;
        }
    }

    protected static interface IGroupImplementation {
        public @NonNull CallPathNode @NonNull [] getRealRoots();

        public @NonNull CallPathNode makeForReferencedSymbolUID(@NonNull CallPathNode var1, long var2, @NonNull CallPathNode @NonNull [] var4);

        public @NonNull CallPathNode makeForThreadUID(long var1, long var3, @NonNull CallPathNode @NonNull [] var5);
    }

    protected static final class ProcessImplementation
    implements IGroupImplementation {
        private final @NonNull Map<@NonNull IUniqueProcessID, @NonNull ProcessState> processStates = new HashMap<IUniqueProcessID, ProcessState>();
        private final @NonNull List<@NonNull ReferencedSymbol> referencedSymbols;
        private final @NonNull IUniqueIDsHelper uniqueIDsHelper;
        private long uidCounter = 0L;
        private final @NonNull Set<@NonNull IUniqueProcessID> idleOrKernelProcesses;
        private final @NonNull Set<@NonNull IUniqueProcessID> notIdleOrKernelProcesses;

        public ProcessImplementation(@NonNull IUniqueIDsHelper iUniqueIDsHelper, @NonNull List<@NonNull ReferencedSymbol> list, long @NonNull [] lArray) {
            this.uniqueIDsHelper = iUniqueIDsHelper;
            this.referencedSymbols = list;
            this.idleOrKernelProcesses = new HashSet<IUniqueProcessID>();
            this.notIdleOrKernelProcesses = new HashSet<IUniqueProcessID>();
            for (long l : lArray) {
                IUniqueProcessID iUniqueProcessID = iUniqueIDsHelper.getProcessByUID(l);
                iUniqueIDsHelper.getThreadsByProcessUID(l).forEach(iUniqueThreadID -> {
                    if (iUniqueThreadID.isIdle() || iUniqueThreadID.isKernel()) {
                        this.idleOrKernelProcesses.add(iUniqueProcessID);
                    } else {
                        this.notIdleOrKernelProcesses.add(iUniqueProcessID);
                    }
                });
            }
        }

        @Override
        public @NonNull CallPathNode @NonNull [] getRealRoots() {
            return (CallPathNode[])this.processStates.values().stream().map(processState -> processState.processNode).toArray(CallPathNode[]::new);
        }

        @Override
        public @NonNull CallPathNode makeForReferencedSymbolUID(@NonNull CallPathNode callPathNode, long l, @NonNull CallPathNode @NonNull [] callPathNodeArray) {
            ReferencedSymbol referencedSymbol = SamplesReport.findReferencedSymbolByUid(this.referencedSymbols, l);
            if (referencedSymbol == null) {
                throw new AssertionError((Object)("Missing symbol " + l));
            }
            String string = referencedSymbol.symbol.getName();
            return new CallPathNode(CallPathNode.Type.SYMBOL, ++this.uidCounter, referencedSymbol.uid, null, referencedSymbol, string, callPathNodeArray, callPathNode);
        }

        @Override
        public @NonNull CallPathNode makeForThreadUID(long l, long l2, @NonNull CallPathNode @NonNull [] callPathNodeArray) {
            IUniqueProcessID iUniqueProcessID = this.uniqueIDsHelper.getProcessByUID(l2);
            ProcessState processState = this.processStates.computeIfAbsent(iUniqueProcessID, iUniqueProcessID2 -> {
                boolean bl = this.idleOrKernelProcesses.contains(iUniqueProcessID) && !this.notIdleOrKernelProcesses.contains(iUniqueProcessID);
                String string = bl ? iUniqueProcessID.getName() : String.format("%s #%d", iUniqueProcessID.getName(), iUniqueProcessID.getOriginalID());
                CallPathNode callPathNode = new CallPathNode(CallPathNode.Type.PROCESS, ++this.uidCounter, iUniqueProcessID.getUID(), null, null, string, callPathNodeArray, null);
                return new ProcessState(callPathNode);
            });
            return processState.processNode;
        }
    }

    protected static final class ProcessThreadImplementation
    implements IGroupImplementation {
        protected final @NonNull Map<@NonNull IUniqueProcessID, @NonNull ProcessState> processStates = new HashMap<IUniqueProcessID, ProcessState>();
        protected final @NonNull List<@NonNull ReferencedSymbol> referencedSymbols;
        protected final @NonNull IUniqueIDsHelper uniqueIDsHelper;
        protected long uidCounter = 0L;

        public ProcessThreadImplementation(@NonNull IUniqueIDsHelper iUniqueIDsHelper, @NonNull List<@NonNull ReferencedSymbol> list, long @NonNull [] lArray) {
            CallPathNode[] callPathNodeArray;
            Object object;
            this.uniqueIDsHelper = iUniqueIDsHelper;
            this.referencedSymbols = list;
            HashMap<IUniqueProcessID, Integer> hashMap = new HashMap<IUniqueProcessID, Integer>();
            HashSet<IUniqueProcessID> hashSet = new HashSet<IUniqueProcessID>();
            HashSet<IUniqueProcessID> hashSet2 = new HashSet<IUniqueProcessID>();
            for (long l : lArray) {
                object = iUniqueIDsHelper.getProcessForThreadUID(l);
                hashMap.compute((IUniqueProcessID)object, (iUniqueProcessID, n) -> n != null ? Integer.valueOf(n + 1) : Integer.valueOf(1));
                callPathNodeArray = iUniqueIDsHelper.getThreadByUID(l);
                if (callPathNodeArray.isIdle() || callPathNodeArray.isKernel()) {
                    hashSet.add((IUniqueProcessID)object);
                    continue;
                }
                hashSet2.add((IUniqueProcessID)object);
            }
            Object object2 = hashMap.entrySet().iterator();
            while (object2.hasNext()) {
                Map.Entry entry = (Map.Entry)object2.next();
                IUniqueProcessID iUniqueProcessID2 = (IUniqueProcessID)entry.getKey();
                Integer n2 = (Integer)entry.getValue();
                boolean bl = hashSet.contains(iUniqueProcessID2) && !hashSet2.contains(iUniqueProcessID2);
                object = bl ? iUniqueProcessID2.getName() : String.format("%s #%d", iUniqueProcessID2.getName(), iUniqueProcessID2.getOriginalID());
                callPathNodeArray = new CallPathNode[n2.intValue()];
                CallPathNode callPathNode = new CallPathNode(CallPathNode.Type.PROCESS, ++this.uidCounter, iUniqueProcessID2.getUID(), null, null, (String)object, callPathNodeArray, null);
                ProcessState processState = new ProcessState(callPathNode);
                this.processStates.put(iUniqueProcessID2, processState);
            }
        }

        @Override
        public @NonNull CallPathNode @NonNull [] getRealRoots() {
            return (CallPathNode[])this.processStates.values().stream().map(processState -> processState.processNode).toArray(CallPathNode[]::new);
        }

        @Override
        public @NonNull CallPathNode makeForReferencedSymbolUID(@NonNull CallPathNode callPathNode, long l, @NonNull CallPathNode @NonNull [] callPathNodeArray) {
            ReferencedSymbol referencedSymbol = SamplesReport.findReferencedSymbolByUid(this.referencedSymbols, l);
            if (referencedSymbol == null) {
                throw new AssertionError((Object)("Missing symbol " + l));
            }
            String string = referencedSymbol.symbol.getName();
            return new CallPathNode(CallPathNode.Type.SYMBOL, ++this.uidCounter, referencedSymbol.uid, null, referencedSymbol, string, callPathNodeArray, callPathNode);
        }

        @Override
        public @NonNull CallPathNode makeForThreadUID(long l, long l2, @NonNull CallPathNode @NonNull [] callPathNodeArray) {
            IUniqueThreadID iUniqueThreadID = this.uniqueIDsHelper.getThreadByUID(l2);
            IUniqueProcessID iUniqueProcessID = this.uniqueIDsHelper.getProcessForThreadUID(l2);
            ProcessState processState = this.processStates.get(iUniqueProcessID);
            if (processState == null) {
                throw new AssertionError((Object)"missing process node");
            }
            if (processState.childIndex >= processState.processNode.children.length) {
                throw new AssertionError((Object)"too many thread nodes");
            }
            String string = String.format("%s #%s", iUniqueThreadID.getName(), Integer.toUnsignedString(iUniqueThreadID.getOriginalID()));
            CallPathNode callPathNode = new CallPathNode(CallPathNode.Type.THREAD, ++this.uidCounter, iUniqueThreadID.getUID(), iUniqueThreadID, null, string, callPathNodeArray, processState.processNode);
            processState.processNode.children[processState.childIndex++] = callPathNode;
            return callPathNode;
        }
    }

    protected static final class ProcessState {
        public int childIndex = 0;
        public final @NonNull CallPathNode processNode;

        public ProcessState(@NonNull CallPathNode callPathNode) {
            this.processNode = callPathNode;
        }
    }
}

