/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.impl;

import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import com.arm.streamline.jni.apcdbgen.proto.ICAMTrack;
import com.arm.streamline.jni.apcdbgen.proto.IGPUWorkloadJob;
import com.arm.streamline.jni.common.TimeRangeFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CAMTrack
implements ICAMTrack {
    private final @NonNull String title;
    private final int uid;
    private final int parentUid;
    private final @NonNull List<@NonNull ICAMTrack> children;
    private final @Nullable ICAMTrack parent;
    private final @NonNull List<@NonNull ICAMJob> jobs;
    private @Nullable JobCacheState cacheState;
    private boolean hasGPUWorkloads;

    public CAMTrack(@NonNull String string, int n, @Nullable ICAMTrack iCAMTrack) {
        this.title = string;
        this.uid = n;
        this.parent = iCAMTrack;
        this.parentUid = iCAMTrack != null ? iCAMTrack.getId() : 0;
        this.children = new ArrayList<ICAMTrack>();
        this.jobs = new ArrayList<ICAMJob>();
        this.cacheState = null;
        this.hasGPUWorkloads = false;
    }

    @Override
    public @NonNull String getTitle() {
        return this.title;
    }

    @Override
    public int getId() {
        return this.uid;
    }

    @Override
    public int getParentId() {
        return this.parentUid;
    }

    @Override
    public @Nullable ICAMTrack getParent() {
        return this.parent;
    }

    @Override
    public @NonNull List<@NonNull ICAMJob> getAllJobs() {
        return Collections.unmodifiableList(this.jobs);
    }

    public void addGPUJob(@NonNull IGPUWorkloadJob iGPUWorkloadJob) {
        this.hasGPUWorkloads = true;
        this.addJob(iGPUWorkloadJob);
    }

    public void addJob(@NonNull ICAMJob iCAMJob) {
        this.jobs.add(iCAMJob);
    }

    @Override
    public @NonNull List<@NonNull ICAMTrack> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(@NonNull ICAMTrack iCAMTrack) {
        this.children.add(iCAMTrack);
    }

    @Override
    public @NonNull List<@NonNull ICAMJob> getJobs(long l, long l2) {
        if (this.cacheState != null && this.cacheState.rangeStartNS == l && this.cacheState.rangeEndNS == l2) {
            return this.cacheState.jobsSpan;
        }
        List<ICAMJob> list = TimeRangeFilter.filterTimeRangeWindow(l, l2, this.jobs);
        this.cacheState = new JobCacheState(l, l2, list);
        return list;
    }

    @Override
    public boolean hasGPUWorkloadJobs() {
        return this.hasGPUWorkloads;
    }

    private record JobCacheState(long rangeStartNS, long rangeEndNS, @NonNull List<@NonNull ICAMJob> jobsSpan) {
    }
}

