/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.impl;

import com.arm.streamline.jni.apcdbgen.impl.CAMJob;
import com.arm.streamline.jni.apcdbgen.proto.ICAMDataProvider;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import com.arm.streamline.jni.apcdbgen.proto.ICAMTrack;
import com.arm.streamline.jni.apcdbgen.proto.IGPUWorkloadJob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class CAMDataProvider
implements ICAMDataProvider {
    private final long vmuid;
    private final int index;
    private final String name;
    private final List<@NonNull ICAMTrack> tracks;
    private final List<@NonNull ICAMTrack> tracksNonHierarchical;
    private final @NonNull List<@NonNull ICAMJob> jobs;
    private int maxEventId;
    private int maxCommandStringLength;
    private long lastTime;
    private int maxDependencies;
    private final boolean isOpenCL;
    private final boolean isMaliTimeline;
    private final boolean isASTFSyscalls;
    private boolean hasGPUWorkloadJobs;
    private final long originUtid;
    private final @NonNull Map<@NonNull Long, @NonNull List<@NonNull IGPUWorkloadJob>> gpuWorkloadJobs;

    public CAMDataProvider(long l, CAMTimelineType cAMTimelineType, int n, String string, long l2) {
        this.vmuid = l;
        this.index = n;
        this.name = string;
        this.tracks = new ArrayList<ICAMTrack>();
        this.tracksNonHierarchical = new ArrayList<ICAMTrack>();
        this.jobs = new ArrayList<ICAMJob>();
        this.maxEventId = -1;
        this.maxCommandStringLength = 0;
        this.lastTime = 0L;
        this.maxDependencies = 0;
        this.isOpenCL = cAMTimelineType == CAMTimelineType.OPENCL_TIMELINE;
        this.originUtid = l2;
        this.isMaliTimeline = cAMTimelineType == CAMTimelineType.MALI_TIMELINE;
        this.isASTFSyscalls = cAMTimelineType == CAMTimelineType.ASTF_SYSCALLS_TIMELINE;
        this.hasGPUWorkloadJobs = false;
        this.gpuWorkloadJobs = new HashMap<Long, List<IGPUWorkloadJob>>();
    }

    @Override
    public long getVmUID() {
        return this.vmuid;
    }

    @Override
    public int getId() {
        return this.index;
    }

    @Override
    public char getHotKey() {
        return this.isOpenCL ? (char)'O' : 'E';
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull List<@NonNull ICAMTrack> getTracks() {
        return Collections.unmodifiableList(this.tracks);
    }

    @Override
    public @NonNull List<@NonNull ICAMTrack> getTracksNonHierarchical() {
        return Collections.unmodifiableList(this.tracksNonHierarchical);
    }

    public void addTrackNonHierarchical(@NonNull ICAMTrack iCAMTrack) {
        this.tracksNonHierarchical.add(iCAMTrack);
    }

    public void addTrack(@NonNull ICAMTrack iCAMTrack) {
        this.tracks.add(iCAMTrack);
    }

    @Override
    public boolean isClippedDependencyChain() {
        return false;
    }

    @Override
    public boolean isOpenCL() {
        return this.isOpenCL;
    }

    @Override
    public boolean isOpenGL() {
        return false;
    }

    @Override
    public boolean isMaliTimeline() {
        return this.isMaliTimeline;
    }

    @Override
    public boolean isASTFSyscalls() {
        return this.isASTFSyscalls;
    }

    @Override
    public int getMaxEventId() {
        return this.maxEventId;
    }

    @Override
    public int getMaxCommandStringLength() {
        return this.maxCommandStringLength;
    }

    @Override
    public long getLastTime() {
        return this.lastTime;
    }

    @Override
    public int getMaxDependencies() {
        return this.maxDependencies;
    }

    @Override
    public @NonNull List<@NonNull ICAMJob> getAllJobsAsList() {
        return Collections.unmodifiableList(this.jobs);
    }

    @Override
    public long getOriginUtid() {
        return this.originUtid;
    }

    @Override
    public @NonNull List<@NonNull IGPUWorkloadJob> getGPUWorkloadJobsAsList(long l) {
        List<IGPUWorkloadJob> list = this.gpuWorkloadJobs.get(l);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public boolean hasGPUWorkloadJobs() {
        return this.hasGPUWorkloadJobs;
    }

    public void sortJobs() {
        this.jobs.sort((iCAMJob, iCAMJob2) -> Long.compare(iCAMJob.getStartTime(), iCAMJob2.getStartTime()));
        this.gpuWorkloadJobs.values().forEach(list -> list.sort((iGPUWorkloadJob, iGPUWorkloadJob2) -> Long.compare(iGPUWorkloadJob.getStartTime(), iGPUWorkloadJob2.getStartTime())));
    }

    public void addJob(@NonNull CAMJob cAMJob) {
        this.maxDependencies = Math.max(this.maxDependencies, cAMJob.getDependencyIds().length);
        this.addJobCommon(cAMJob);
    }

    public void addGPUWorkloadJob(@NonNull IGPUWorkloadJob iGPUWorkloadJob) {
        this.addJobCommon(iGPUWorkloadJob);
        this.hasGPUWorkloadJobs = true;
        long l2 = iGPUWorkloadJob.getTimelineWorkload().getFrame();
        this.gpuWorkloadJobs.computeIfAbsent(l2, l -> new ArrayList()).add(iGPUWorkloadJob);
    }

    private void addJobCommon(@NonNull ICAMJob iCAMJob) {
        this.jobs.add(iCAMJob);
        this.maxCommandStringLength = Math.max(this.maxCommandStringLength, iCAMJob.getName().length());
        this.maxEventId = Math.max(this.maxEventId, iCAMJob.getId());
        this.lastTime = Math.max(this.lastTime, iCAMJob.getStopTime());
    }

    public static enum CAMTimelineType {
        NON_TIMELINE(0),
        ARMNN_TIMELINE(1),
        OPENCL_TIMELINE(2),
        MALI_TIMELINE(3),
        ASTF_SYSCALLS_TIMELINE(4);

        public final int jniValue;

        public static @NonNull CAMTimelineType mapJniValue(int n) {
            for (CAMTimelineType cAMTimelineType : CAMTimelineType.values()) {
                if (n != cAMTimelineType.jniValue) continue;
                return cAMTimelineType;
            }
            throw new IllegalArgumentException("Invalid JNI value for CAMDataType");
        }

        private CAMTimelineType(int n2) {
            this.jniValue = n2;
        }
    }
}

