/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen.impl;

import com.arm.streamline.jni.StreamlineLib;
import com.arm.streamline.jni.apcdbgen.AnalysisOptions;
import com.arm.streamline.jni.apcdbgen.impl.CAMReport;
import com.arm.streamline.jni.apcdbgen.impl.IUniqueIDsHelper;
import com.arm.streamline.jni.apcdbgen.impl.SamplesReport;
import com.arm.streamline.jni.apcdbgen.proto.IApcReport;
import com.arm.streamline.jni.apcdbgen.proto.ICAMReport;
import com.arm.streamline.jni.common.CancellationPredicate;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.jni.common.Executor;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import com.arm.streamline.jni.common.NativeException;
import com.arm.streamline.jni.common.NativeHandle;
import com.arm.streamline.jni.common.WarningItem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ApcReport
implements AutoCloseable,
IApcReport {
    private final @NonNull NativeHandle nativeHandle;
    private final @NonNull List<@NonNull SamplesReport> sampleReports = new ArrayList<SamplesReport>();
    private @Nullable List<@NonNull String> unadjustedSourceDirectories;
    private final @NonNull IUniqueIDsHelper uniqueIDsHelper;
    private final boolean useProcessInCallPath;
    private final @Nullable CAMReport camReport;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static @Nullable ApcReport openReport(@NonNull ExecutorService executorService, @NonNull IProgressMonitorFactory iProgressMonitorFactory, @NonNull CancellationPredicate cancellationPredicate, @NonNull AnalysisOptions analysisOptions, @NonNull File file, @NonNull IUniqueIDsHelper iUniqueIDsHelper) throws Exception {
        return cancellationPredicate.doWithResult(l -> {
            long l2 = ApcReport.openReport(l, analysisOptions.forceClean(), analysisOptions.wantsBacktraceData(), analysisOptions.wantsSPEData(), analysisOptions.wantsCAMData(), analysisOptions.processDebugInfo(), analysisOptions.convertSearchImagePaths(), file.getCanonicalPath(), new Executor(executorService, iProgressMonitorFactory));
            if (l2 == 0L) {
                return null;
            }
            try {
                return new ApcReport(l2, iUniqueIDsHelper);
            }
            catch (Throwable throwable) {
                ApcReport.destroyHandle(l2);
                throw throwable;
            }
        });
    }

    private static native @Nullable SamplesReport createSampleReportObject(long var0, int var2, @NonNull IUniqueIDsHelper var3) throws CodecException, NativeException;

    private static native @Nullable CAMReport createCAMReportObject(long var0) throws CodecException, NativeException;

    private static native void destroyHandle(long var0);

    private static native @NonNull String @NonNull [] getUnadjustedSourceDirectories(long var0);

    private static native long openReport(long var0, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, @NonNull String @Nullable [] var7, String var8, Executor var9) throws CodecException, IOException;

    private static native @NonNull WarningItem @Nullable [] getWarnings(long var0);

    private static native boolean shouldCallPathTreeIncludeProcesses(long var0);

    private ApcReport(long l2, @NonNull IUniqueIDsHelper iUniqueIDsHelper) throws Exception {
        if (!$assertionsDisabled && l2 == 0L) {
            throw new AssertionError();
        }
        this.uniqueIDsHelper = iUniqueIDsHelper;
        this.nativeHandle = new NativeHandle(l2, ApcReport::destroyHandle);
        CAMReport cAMReport = null;
        try {
            int n;
            SamplesReport samplesReport;
            this.useProcessInCallPath = this.nativeHandle.doWithResult(l -> ApcReport.shouldCallPathTreeIncludeProcesses(l));
            int n2 = 0;
            while (n2 < Integer.MAX_VALUE && (samplesReport = this.nativeHandle.doWithResult(arg_0 -> ApcReport.lambda$new$2(n = n2++, iUniqueIDsHelper, arg_0))) != null) {
                try {
                    this.sampleReports.add(samplesReport);
                }
                catch (Throwable throwable) {
                    samplesReport.close();
                    throw throwable;
                }
            }
            cAMReport = this.nativeHandle.doWithResult(l -> ApcReport.createCAMReportObject(l));
        }
        catch (Throwable throwable) {
            try {
                NativeHandle.closeAll(this.sampleReports, Arrays.asList(cAMReport));
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.camReport = cAMReport;
        this.sampleReports.sort(Comparator.naturalOrder());
    }

    @Override
    public void close() throws Exception {
        NativeHandle.closeAll(this.sampleReports, List.of(this.nativeHandle), Arrays.asList(this.camReport));
    }

    public @NonNull List<@NonNull SamplesReport> getSampleReports() {
        return Collections.unmodifiableList(this.sampleReports);
    }

    @Override
    public @Nullable ICAMReport getCAMReport() {
        return this.camReport;
    }

    @Override
    public @NonNull List<@NonNull String> getUnadjustedSourceDirectories() {
        List<String> list = this.unadjustedSourceDirectories;
        if (list == null) {
            this.unadjustedSourceDirectories = list = Collections.unmodifiableList(Arrays.asList(this.nativeHandle.doWithResult(ApcReport::getUnadjustedSourceDirectories)));
        }
        return list;
    }

    @Override
    public @NonNull Set<@NonNull WarningItem> getWarnings() {
        WarningItem[] warningItemArray = this.nativeHandle.doWithResult(l -> ApcReport.getWarnings(l));
        return warningItemArray != null ? new HashSet<WarningItem>(Arrays.asList(warningItemArray)) : Collections.emptySet();
    }

    @Override
    public boolean shouldCallPathTreeIncludeProcesses() {
        return this.useProcessInCallPath;
    }

    private static /* synthetic */ SamplesReport lambda$new$2(int n, IUniqueIDsHelper iUniqueIDsHelper, long l) throws CodecException, CodecException {
        return ApcReport.createSampleReportObject(l, n, iUniqueIDsHelper);
    }

    static {
        boolean bl = $assertionsDisabled = !ApcReport.class.desiredAssertionStatus();
        if (!StreamlineLib.isLoaded) {
            throw new AssertionError((Object)"Failed to load Streamline JNI lib");
        }
    }
}

