/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.analytics;

import com.arm.streamline.jni.StreamlineLib;
import com.arm.streamline.jni.analytics.BooleanKey;
import com.arm.streamline.jni.analytics.DoubleKey;
import com.arm.streamline.jni.analytics.StringKey;
import com.arm.streamline.jni.analytics.ToolKey;

public final class AnalyticsLogger
implements AutoCloseable {
    private long nativeHandle;

    public AnalyticsLogger(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("coreLibraryPath must be non-empty");
        }
        this.nativeHandle = AnalyticsLogger.nativeCreate(string);
        if (this.nativeHandle == 0L) {
            throw new IllegalStateException("Failed to create native analytics session");
        }
    }

    @Override
    public void close() {
        long l = this.nativeHandle;
        if (l != 0L) {
            AnalyticsLogger.nativeDestroy(l);
            this.nativeHandle = 0L;
        }
    }

    public void logBoolean(BooleanKey booleanKey, boolean bl) {
        this.ensureOpen();
        if (booleanKey == null) {
            throw new NullPointerException("key");
        }
        AnalyticsLogger.nativeLogBoolean(this.nativeHandle, booleanKey, bl);
    }

    public void logDouble(DoubleKey doubleKey, double d) {
        this.ensureOpen();
        if (doubleKey == null) {
            throw new NullPointerException("key");
        }
        AnalyticsLogger.nativeLogDouble(this.nativeHandle, doubleKey, d);
    }

    public void logString(StringKey stringKey, String string) {
        this.ensureOpen();
        if (stringKey == null) {
            throw new NullPointerException("key");
        }
        if (string == null) {
            throw new NullPointerException("value");
        }
        AnalyticsLogger.nativeLogString(this.nativeHandle, stringKey, string);
    }

    public void logToolVersion(ToolKey toolKey, int n, int n2, int n3) {
        this.ensureOpen();
        if (toolKey == null) {
            throw new NullPointerException("tool");
        }
        if (n < 0 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("version parts must be non-negative");
        }
        AnalyticsLogger.nativeLogToolVersion(this.nativeHandle, toolKey, n, n2, n3);
    }

    private void ensureOpen() {
        if (this.nativeHandle == 0L) {
            throw new IllegalStateException("Analytics Logger is closed");
        }
    }

    private static native long nativeCreate(String var0);

    private static native void nativeDestroy(long var0);

    private static native void nativeLogBoolean(long var0, BooleanKey var2, boolean var3);

    private static native void nativeLogDouble(long var0, DoubleKey var2, double var3);

    private static native void nativeLogString(long var0, StringKey var2, String var3);

    private static native void nativeLogToolVersion(long var0, ToolKey var2, int var3, int var4, int var5);

    static native void nativeEnableLogCapture(boolean var0);

    static native String[] nativeDrainLogs();

    static native void nativeClearLogs();

    static native void nativeSetEnv(String var0, String var1);

    static native void nativeUnsetEnv(String var0);

    static {
        if (!StreamlineLib.isLoaded) {
            throw new AssertionError((Object)"Failed to load streamline JNI lib");
        }
    }
}

