/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.vm;

import com.arm.streamline.ui.part.GatordRunningErrorDialogMessages;
import com.arm.streamline.ui.vm.GatordRunningErrorDialogFlags;
import com.arm.streamline.ui.vm.GatordRunningErrorDialogResult;
import com.arm.streamline.ui.vm.ILandingPageActionHandler;
import com.arm.streamline.ui.vm.ILandingPageAdbPathPreferenceModel;
import com.arm.streamline.ui.vm.ILandingPageSshSubViewViewModel;
import com.arm.streamline.ui.vm.ISshDeviceModel;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import com.arm.streamline.ui.vm.ITargetDevice;
import com.arm.streamline.ui.vm.LandingPageSceneViewModel;
import com.arm.streamline.ui.vm.SshDeviceStatus;
import java.io.File;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class LandingPageSshSubViewViewModel
implements ILandingPageSshSubViewViewModel {
    private final @NonNull ILandingPageActionHandler actionsHandler;
    private final @NonNull ISshDeviceModel deviceModel;
    private final @NonNull ObjectBinding<@Nullable ISshTargetLauncher> activeTargetLauncher;
    private final @NonNull ILandingPageAdbPathPreferenceModel adbPathModel;
    private final @NonNull SimpleObjectProperty<@NonNull String> commandPathText = new SimpleObjectProperty((Object)"");
    private final @NonNull SimpleBooleanProperty commandStopOnExit = new SimpleBooleanProperty(true);
    private final @NonNull SimpleObjectProperty<@NonNull String> commandUserNameText = new SimpleObjectProperty((Object)"");
    private final @NonNull SimpleObjectProperty<@NonNull String> commandWorkingDirText = new SimpleObjectProperty((Object)"");
    private final @NonNull ObservableList<@NonNull ISshTargetLauncher> detectedDevices = FXCollections.observableArrayList();
    private final @NonNull BooleanBinding disableDeviceTableSelection;
    private final @NonNull LandingPageSceneViewModel.ISshTargetLauncherFactory launcherFactory;
    private final @NonNull SimpleObjectProperty<@Nullable ISshTargetLauncher> selectedDetectedDevice = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@NonNull SshDeviceStatus> selectedDeviceStatus;

    public LandingPageSshSubViewViewModel(@NonNull ILandingPageActionHandler actionsHandler, @NonNull LandingPageSceneViewModel.ISshTargetLauncherFactory launcherFactory, @NonNull ILandingPageAdbPathPreferenceModel adbPathModel, @NonNull ISshDeviceModel deviceModel, @NonNull Consumer<@NonNull Runnable> runOnUIThread) {
        this.actionsHandler = actionsHandler;
        this.deviceModel = deviceModel;
        this.launcherFactory = launcherFactory;
        this.adbPathModel = adbPathModel;
        this.selectedDeviceStatus = deviceModel.startCheckingDeviceStatuses(this.detectedDevices, (ObjectProperty<ISshTargetLauncher>)this.selectedDetectedDevice, runOnUIThread);
        this.disableDeviceTableSelection = Bindings.isEmpty(this.detectedDevices);
        this.loadDevicesFromCache();
        this.activeTargetLauncher = Bindings.createObjectBinding(this::calculateActiveTargetLauncher, (Observable[])new Observable[]{this.selectedDetectedDevice, this.selectedDeviceStatus, this.commandPathText, this.commandWorkingDirText, this.commandUserNameText, this.commandStopOnExit});
        this.detectedDevices.addListener((ListChangeListener)new ListChangeListener<ISshTargetLauncher>(){

            public void onChanged(// Could not load outer class - annotation placement on inner may be incorrect
            ListChangeListener.Change<? extends @NonNull ISshTargetLauncher> change) {
                block0: while (change.next()) {
                    if (change.wasReplaced()) {
                        int n = change.getTo() - change.getFrom();
                        int i = 0;
                        while (i < n) {
                            if (change.getRemoved().get(i) == LandingPageSshSubViewViewModel.this.selectedDetectedDevice.get()) {
                                LandingPageSshSubViewViewModel.this.selectedDetectedDevice.set(null);
                                LandingPageSshSubViewViewModel.this.selectedDetectedDevice.set((Object)((ISshTargetLauncher)change.getList().get(change.getFrom() + i)));
                                continue block0;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (!change.wasRemoved()) continue;
                    for (ISshTargetLauncher remitem : change.getRemoved()) {
                        if (remitem != LandingPageSshSubViewViewModel.this.selectedDetectedDevice.get()) continue;
                        LandingPageSshSubViewViewModel.this.selectedDetectedDevice.set(null);
                        continue block0;
                    }
                }
                if (LandingPageSshSubViewViewModel.this.detectedDevices.isEmpty()) {
                    LandingPageSshSubViewViewModel.this.selectedDetectedDevice.set(null);
                } else if (LandingPageSshSubViewViewModel.this.detectedDevices.size() == 1) {
                    LandingPageSshSubViewViewModel.this.selectedDetectedDevice.set((Object)((ISshTargetLauncher)LandingPageSshSubViewViewModel.this.detectedDevices.get(0)));
                }
            }
        });
    }

    private void loadDevicesFromCache() {
        Object[] targets = this.actionsHandler.getCachedTargets();
        if (targets != null) {
            this.detectedDevices.addAll(targets);
        }
    }

    @Override
    public @NonNull ObservableObjectValue<@Nullable ISshTargetLauncher> activeTargetLauncherProperty() {
        return this.activeTargetLauncher;
    }

    @Override
    public @NonNull ObservableObjectValue<@Nullable File> adbToolPathProperty() {
        return this.adbPathModel.adbToolPathProperty();
    }

    @Override
    public boolean canFocusOnDeviceTableEntry(@Nullable ISshTargetLauncher currentTableSelection) {
        if (currentTableSelection == null) {
            return false;
        }
        return this.detectedDevices.contains((Object)currentTableSelection);
    }

    @Override
    public @NonNull ObjectProperty<@NonNull String> commandPathTextProperty() {
        return this.commandPathText;
    }

    @Override
    public @NonNull BooleanProperty commandStopOnExitProperty() {
        return this.commandStopOnExit;
    }

    @Override
    public @NonNull ObjectProperty<@NonNull String> commandUserNameTextProperty() {
        return this.commandUserNameText;
    }

    @Override
    public @NonNull ObjectProperty<@NonNull String> commandWorkingDirTextProperty() {
        return this.commandWorkingDirText;
    }

    @Override
    public @NonNull ObservableList<@NonNull ISshTargetLauncher> detectedDevicesProperty() {
        return this.detectedDevices;
    }

    @Override
    public @NonNull ObservableBooleanValue disableDeviceTableSelectionProperty() {
        return this.disableDeviceTableSelection;
    }

    @Override
    public void doShowAdbPathConfigurationPreference() {
        this.adbPathModel.doShowAdbPathConfigurationPreference();
    }

    @Override
    public void resetAdbPathToDefault() {
        this.adbPathModel.resetAdbPathToDefault();
    }

    @Override
    public void doShowAndroidTargetHelp() {
        this.actionsHandler.showAndroidTargetHelp();
    }

    @Override
    public void doShowStreamlineMeTargetHelp() {
        this.actionsHandler.showStreamlineMeTargetHelp();
    }

    @Override
    public void doShowLinuxTargetHelp() {
        this.actionsHandler.showLinuxTargetHelp();
    }

    @Override
    public @NonNull ObservableBooleanValue hasValidAdbToolPathSetProperty() {
        return this.adbPathModel.hasValidAdbToolPathSetProperty();
    }

    @Override
    public @NonNull ObjectProperty<@Nullable ISshTargetLauncher> selectedDetectedDeviceProperty() {
        return this.selectedDetectedDevice;
    }

    private @Nullable ISshTargetLauncher calculateActiveTargetLauncher() {
        ISshTargetLauncher selectedDetectedDevice = (ISshTargetLauncher)this.selectedDetectedDevice.get();
        if (selectedDetectedDevice == null) {
            return null;
        }
        SshDeviceStatus status = (SshDeviceStatus)((Object)this.selectedDeviceStatus.get());
        switch (status) {
            case AVAILABLE: 
            case UNAVAILABLE_KILLABLE_GATORD_RUNNING: 
            case UNAVAILABLE_UNKILLABLE_GATORD_RUNNING: 
            case UNAVAILABLE_GATORD_PROCESS_FOUND: 
            case UNAVAILABLE_NON_GATORD_USING_PORT: {
                break;
            }
            case UNAVAILABLE_UNKNOWN: {
                return null;
            }
            default: {
                throw new AssertionError((Object)status);
            }
        }
        if (!selectedDetectedDevice.getSSHTargetConfig().username().equals("root") && ((String)this.commandPathText.get()).isBlank()) {
            return null;
        }
        return this.launcherFactory.create(selectedDetectedDevice.getSSHTargetConfig(), (String)this.commandPathText.get(), (String)this.commandWorkingDirText.get(), (String)this.commandUserNameText.get(), selectedDetectedDevice.getGatorPortNumeric(), selectedDetectedDevice.getGatorPath(), this.commandStopOnExit.get(), selectedDetectedDevice.isFromDefaults());
    }

    @Override
    public void setSelectedDeviceIfPresent(@NonNull ISshTargetLauncher targetDevice) {
        Optional<@NonNull ISshTargetLauncher> findSameDeviceInSshView = this.detectedDevicesProperty().stream().filter(SshViewDevice -> SshViewDevice.getTargetAddress().equals(targetDevice.getTargetAddress())).findFirst();
        if (findSameDeviceInSshView.isPresent()) {
            this.selectedDetectedDeviceProperty().set((Object)findSameDeviceInSshView.get());
        } else {
            this.selectedDetectedDeviceProperty().set(null);
        }
    }

    @Override
    public void doShowSSHConfiguration(ISshTargetLauncher sshTarget) {
        this.actionsHandler.showSSHConfiguration(this.detectedDevices, sshTarget);
    }

    @Override
    public void removeDevices(ObservableList<ISshTargetLauncher> observableList) {
        this.detectedDevices.removeAll(observableList);
    }

    @Override
    public void updateDevices(ObservableList<@NonNull ISshTargetLauncher> observableList) {
        this.detectedDevices.setAll(observableList);
    }

    @Override
    public boolean handleGatordRunningStates() {
        ISshTargetLauncher device = (ISshTargetLauncher)this.selectedDetectedDevice.get();
        if (device == null) {
            return false;
        }
        GatordRunningErrorDialogFlags flags = GatordRunningErrorDialogFlags.forSshSubView().setHideUseButton();
        SshDeviceStatus deviceStatus = (SshDeviceStatus)((Object)this.selectedDeviceStatus.get());
        switch (deviceStatus) {
            case AVAILABLE: {
                return true;
            }
            case UNAVAILABLE_KILLABLE_GATORD_RUNNING: {
                return this.handleGatordRunningState(device, GatordRunningErrorDialogMessages.HEADER_GATOR_UNAVAILABLE, GatordRunningErrorDialogMessages.BODY_GATOR_KILLABLE_NEVER_USE, flags);
            }
            case UNAVAILABLE_UNKILLABLE_GATORD_RUNNING: 
            case UNAVAILABLE_GATORD_PROCESS_FOUND: {
                return this.handleGatordRunningState(device, GatordRunningErrorDialogMessages.HEADER_GATOR_UNAVAILABLE, GatordRunningErrorDialogMessages.BODY_CANNOT_PERFORM_CAPTURE, flags.setHideStopButton());
            }
            case UNAVAILABLE_NON_GATORD_USING_PORT: {
                return this.handleGatordRunningState(device, GatordRunningErrorDialogMessages.HEADER_NON_GATOR_RUNNING, GatordRunningErrorDialogMessages.BODY_CANNOT_PERFORM_CAPTURE, flags.setHideStopButton());
            }
        }
        return false;
    }

    private boolean handleGatordRunningState(final @NonNull ISshTargetLauncher target, @NonNull String messageHeader, @NonNull String messageBody, @NonNull GatordRunningErrorDialogFlags flags) {
        GatordRunningErrorDialogResult result = this.actionsHandler.showGatorRunningErrorDialog(target.getSSHTargetConfig().id(), messageHeader, messageBody, flags);
        ITargetDevice device = new ITargetDevice(){

            @Override
            public @NonNull String getDescription() {
                return target.getSSHTargetConfig().id();
            }

            @Override
            public @NonNull String getTargetAddress() {
                return target.getTargetAddress();
            }

            @Override
            public @NonNull String getTooltip() {
                return target.getSSHTargetConfig().id();
            }
        };
        return result == GatordRunningErrorDialogResult.STOP && this.deviceModel.doKillGatordOnDevice(device);
    }

    @Override
    public @NonNull ObservableValue<SshDeviceStatus> getStatusPropertyFor(@Nullable ISshTargetLauncher launcher) {
        if (launcher == null) {
            return new ReadOnlyObjectWrapper((Object)SshDeviceStatus.UNAVAILABLE_UNKNOWN);
        }
        return this.deviceModel.getStatusPropertyFor(launcher);
    }
}

