/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.vm;

import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.deviceconn.adb.AdbDeviceRootMode;
import com.arm.streamline.ui.part.LandingPageMessages;
import com.arm.streamline.ui.utils.LandingPagesUiUitility;
import com.arm.streamline.ui.utils.ObservableUtils;
import com.arm.streamline.ui.vm.IAndroidDeviceModel;
import com.arm.streamline.ui.vm.IAndroidPackage;
import com.arm.streamline.ui.vm.IAndroidTargetDevice;
import com.arm.streamline.ui.vm.IAndroidTargetLauncher;
import com.arm.streamline.ui.vm.ILandingPageActionHandler;
import com.arm.streamline.ui.vm.ILandingPageAdbPathPreferenceModel;
import com.arm.streamline.ui.vm.ILandingPageAndroidSubViewViewModel;
import com.arm.streamline.ui.vm.ILandingPageSceneViewModel;
import com.arm.streamline.ui.vm.ILandingPageSshSubViewViewModel;
import com.arm.streamline.ui.vm.ILandingPageTcpSubViewViewModel;
import com.arm.streamline.ui.vm.ISshDeviceModel;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import com.arm.streamline.ui.vm.ITargetLauncher;
import com.arm.streamline.ui.vm.ITcpTargetLauncher;
import com.arm.streamline.ui.vm.LandingPageAndroidSubViewViewModel;
import com.arm.streamline.ui.vm.LandingPageSshSubViewViewModel;
import com.arm.streamline.ui.vm.LandingPageTcpSubViewViewModel;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.services.IDisposable;

public final class LandingPageSceneViewModel
implements ILandingPageSceneViewModel {
    private final @NonNull ILandingPageActionHandler actionsHandler;
    private final @NonNull SimpleObjectProperty<@NonNull ILandingPageSceneViewModel.SubView> activeSubView = new SimpleObjectProperty((Object)ILandingPageSceneViewModel.SubView.TCP);
    private final @NonNull SimpleObjectProperty<@Nullable ITcpTargetLauncher> tcpTargetLauncher = new SimpleObjectProperty();
    private final @NonNull SimpleObjectProperty<@Nullable IAndroidTargetLauncher> androidTargetLauncher = new SimpleObjectProperty();
    private final @NonNull SimpleObjectProperty<@Nullable ISshTargetLauncher> sshTargetLauncher = new SimpleObjectProperty();
    private final @NonNull ObjectBinding<@Nullable ITargetLauncher> activeTargetLauncher;
    private final @NonNull SimpleBooleanProperty disableAdvancedSettings = new SimpleBooleanProperty(true);
    private final @NonNull SimpleBooleanProperty inAdvancedMode = new SimpleBooleanProperty(true);
    private final @NonNull SimpleBooleanProperty profileWithMaliCountersInBasicMode = new SimpleBooleanProperty(false);
    private final @NonNull SimpleBooleanProperty isHighRes = new SimpleBooleanProperty(false);
    private final @NonNull SimpleBooleanProperty disableCounterConfiguration = new SimpleBooleanProperty(true);
    private final @NonNull SimpleBooleanProperty disableStartCapture = new SimpleBooleanProperty(true);
    private final @NonNull ILandingPageTcpSubViewViewModel tcpSubViewViewModel;
    private final @NonNull ILandingPageAndroidSubViewViewModel androidSubViewViewModel;
    private final @NonNull ILandingPageSshSubViewViewModel sshSubViewViewModel;
    private final @NonNull SimpleBooleanProperty isMaliGpuDetected = new SimpleBooleanProperty(false);
    private final @NonNull IDisposable deviceSelectionChange;
    private boolean useAdvancedModeForNonTcp;

    public LandingPageSceneViewModel(@NonNull ILandingPageActionHandler actionsHandler, @NonNull ObservableBooleanValue hasActiveCapture, @NonNull ISshTargetLauncherFactory sshTargetLauncherFactory, @NonNull ITcpTargetLauncherFactory tcpTargetLauncherFactory, @NonNull IAndroidTargetLauncherFactory androidTargetLauncherFactory, @NonNull IAndroidDeviceModel androidDeviceManager, @NonNull ISshDeviceModel sshDeviceModel, @NonNull ILandingPageAdbPathPreferenceModel adbPathModel) {
        this(actionsHandler, hasActiveCapture, sshTargetLauncherFactory, tcpTargetLauncherFactory, androidTargetLauncherFactory, androidDeviceManager, sshDeviceModel, adbPathModel, LandingPagesUiUitility::runLater);
    }

    LandingPageSceneViewModel(@NonNull ILandingPageSshSubViewViewModel sshSubViewViewModel, @NonNull ILandingPageTcpSubViewViewModel tcpSubViewViewModel, @NonNull ILandingPageAndroidSubViewViewModel androidSubViewViewModel, @NonNull ILandingPageActionHandler actionsHandler, @NonNull ObservableBooleanValue hasActiveCapture, @NonNull ISshTargetLauncherFactory sshTargetLauncherFactory, @NonNull ITcpTargetLauncherFactory tcpTargetLauncherFactory, @NonNull IAndroidTargetLauncherFactory androidTargetLauncherFactory, @NonNull ILandingPageAdbPathPreferenceModel adbPathModel, @NonNull Consumer<@NonNull Runnable> runOnUIThread) {
        this.actionsHandler = actionsHandler;
        this.tcpSubViewViewModel = tcpSubViewViewModel;
        this.androidSubViewViewModel = androidSubViewViewModel;
        this.sshSubViewViewModel = sshSubViewViewModel;
        androidSubViewViewModel.uiElementDisableProperty().bind((ObservableValue)hasActiveCapture);
        this.activeTargetLauncher = Bindings.createObjectBinding(this::calculateSelectedTargetLauncher, (Observable[])new Observable[]{this.activeSubView, sshSubViewViewModel.activeTargetLauncherProperty(), tcpSubViewViewModel.activeTargetLauncherProperty(), androidSubViewViewModel.activeTargetLauncherProperty()});
        BooleanBinding disabled = Bindings.or((ObservableBooleanValue)this.activeTargetLauncher.isNull(), (ObservableBooleanValue)hasActiveCapture);
        this.disableAdvancedSettings.bind((ObservableValue)disabled);
        this.disableCounterConfiguration.bind((ObservableValue)disabled);
        this.disableStartCapture.bind((ObservableValue)disabled);
        this.isMaliGpuDetected.bind((ObservableValue)Bindings.createBooleanBinding(this::checkIfMaliDetected, (Observable[])new Observable[]{androidSubViewViewModel.selectedDeviceProperty(), this.activeSubView}));
        this.deviceSelectionChange = ObservableUtils.onChange(androidSubViewViewModel.selectedDeviceProperty(), (oldSelection, newSelection) -> {
            if (newSelection != null && newSelection.isMaliGpuDetected()) {
                this.profileWithMaliCountersInBasicMode.set(this.getProfileWithMaliCounters((IAndroidTargetDevice)newSelection));
            } else {
                this.profileWithMaliCountersInBasicMode.set(false);
            }
            if (newSelection != null) {
                this.isHighRes.set(this.isHighResolutionModeForSelectedDevice((IAndroidTargetDevice)newSelection));
            } else {
                this.isHighRes.set(false);
            }
        });
        this.profileWithMaliCountersInBasicMode.addListener((obsrv, old_val, new_val) -> {
            IAndroidTargetDevice iAndroidTargetDevice = (IAndroidTargetDevice)androidSubViewViewModel.selectedDeviceProperty().get();
            if (iAndroidTargetDevice != null) {
                this.setProfileWithMaliCounters(iAndroidTargetDevice, (boolean)new_val);
            }
        });
        this.isHighRes.addListener((v, o, n) -> {
            ResolutionMode resolutionMode = n != false ? ResolutionMode.HIGH : ResolutionMode.NORMAL;
            IAndroidTargetDevice iAndroidTargetDevice = (IAndroidTargetDevice)androidSubViewViewModel.selectedDeviceProperty().get();
            if (iAndroidTargetDevice != null) {
                this.setResolutionMode(iAndroidTargetDevice, resolutionMode);
            }
        });
        androidSubViewViewModel.setSwitchToTcpCallback(this::switchToTcpAndSelectTargetDevice);
        this.useAdvancedModeForNonTcp = actionsHandler.isAdvancedConfigModePreferred();
        this.activeSubView.addListener((v, o, n) -> {
            if (n.equals((Object)ILandingPageSceneViewModel.SubView.TCP)) {
                this.useAdvancedModeForNonTcp = this.inAdvancedMode.get();
                this.inAdvancedMode.set(true);
            } else {
                this.inAdvancedMode.set(this.useAdvancedModeForNonTcp);
            }
        });
        this.inAdvancedMode.addListener((v, o, n) -> this.setAdvancedConfigModePreference((boolean)n));
    }

    private boolean isHighResolutionModeForSelectedDevice(@NonNull IAndroidTargetDevice newSelection) {
        return this.actionsHandler.getResolutionMode(newSelection) == ResolutionMode.HIGH;
    }

    private void setResolutionMode(@NonNull IAndroidTargetDevice iAndroidTargetDevice, @NonNull ResolutionMode resolutionMode) {
        this.actionsHandler.setResolutionMode(iAndroidTargetDevice, resolutionMode);
    }

    private void setProfileWithMaliCounters(@NonNull IAndroidTargetDevice selectedDevice, boolean checkedState) {
        this.actionsHandler.setProfileWithMaliCounters(selectedDevice, checkedState);
    }

    private boolean getProfileWithMaliCounters(@NonNull IAndroidTargetDevice selectedDevice) {
        return this.actionsHandler.getProfileWithMaliCounters(selectedDevice);
    }

    public LandingPageSceneViewModel(@NonNull ILandingPageActionHandler actionsHandler, @NonNull ObservableBooleanValue hasActiveCapture, @NonNull ISshTargetLauncherFactory sshTargetLauncherFactory, @NonNull ITcpTargetLauncherFactory tcpTargetLauncherFactory, @NonNull IAndroidTargetLauncherFactory androidTargetLauncherFactory, @NonNull IAndroidDeviceModel androidDeviceManager, @NonNull ISshDeviceModel sshDeviceModel, @NonNull ILandingPageAdbPathPreferenceModel adbPathModel, @NonNull Consumer<@NonNull Runnable> runOnUIThread) {
        this(new LandingPageSshSubViewViewModel(actionsHandler, sshTargetLauncherFactory, adbPathModel, sshDeviceModel, runOnUIThread), new LandingPageTcpSubViewViewModel(actionsHandler, tcpTargetLauncherFactory, adbPathModel), new LandingPageAndroidSubViewViewModel(actionsHandler, androidTargetLauncherFactory, adbPathModel, LandingPagesUiUitility::runLater, androidDeviceManager), actionsHandler, hasActiveCapture, sshTargetLauncherFactory, tcpTargetLauncherFactory, androidTargetLauncherFactory, adbPathModel, runOnUIThread);
    }

    private void switchToTcpAndSelectTargetDevice(@NonNull IAndroidTargetDevice targetDevice) {
        this.activeSubView.set((Object)ILandingPageSceneViewModel.SubView.TCP);
        this.tcpSubViewViewModel.setSelectedDeviceIfPresent(targetDevice);
    }

    @Override
    public @NonNull ObjectProperty<@NonNull ILandingPageSceneViewModel.SubView> activeSubViewProperty() {
        return this.activeSubView;
    }

    @Override
    public @NonNull SimpleBooleanProperty inAdvancedMode() {
        return this.inAdvancedMode;
    }

    @Override
    public @NonNull SimpleBooleanProperty profileWithMaliCountersInBasicMode() {
        return this.profileWithMaliCountersInBasicMode;
    }

    @Override
    public @NonNull SimpleBooleanProperty isHighRes() {
        return this.isHighRes;
    }

    @Override
    public @NonNull ObservableObjectValue<@Nullable ITargetLauncher> activeTargetLauncherProperty() {
        return this.activeTargetLauncher;
    }

    @Override
    public @NonNull ReadOnlyBooleanProperty disableAdvancedSettingsProperty() {
        return this.disableAdvancedSettings;
    }

    @Override
    public @NonNull ReadOnlyBooleanProperty disableCounterConfigurationProperty() {
        return this.disableCounterConfiguration;
    }

    @Override
    public @NonNull ReadOnlyBooleanProperty disableStartCaptureProperty() {
        return this.disableStartCapture;
    }

    @Override
    public void doAdvancedSettings() {
        if (!this.disableAdvancedSettings.get()) {
            this.actionsHandler.showAdvancedSettings();
        }
    }

    private void setAdvancedConfigModePreference(boolean useAdvanced) {
        this.actionsHandler.setAdvancedConfigModePreference(useAdvanced);
    }

    @Override
    public boolean isAdvancedConfigModePreferred() {
        return this.actionsHandler.isAdvancedConfigModePreferred();
    }

    @Override
    public void doCounterConfiguration() {
        ITargetLauncher activeTarget = (ITargetLauncher)this.activeTargetLauncher.get();
        if (activeTarget != null && !this.disableCounterConfiguration.get()) {
            ILandingPageSceneViewModel.SubView activeSubView = (ILandingPageSceneViewModel.SubView)((Object)this.activeSubView.get());
            if (activeSubView == ILandingPageSceneViewModel.SubView.ANDROID && !this.androidSubViewViewModel.handleGatordRunningStates()) {
                return;
            }
            if (activeSubView == ILandingPageSceneViewModel.SubView.SSH && !this.sshSubViewViewModel.handleGatordRunningStates()) {
                return;
            }
            this.actionsHandler.showCounterConfiguration(activeTarget);
        }
    }

    @Override
    public void doStartCapture() {
        if (!this.disableStartCapture.get()) {
            ILandingPageSceneViewModel.SubView activeSubView = (ILandingPageSceneViewModel.SubView)((Object)this.activeSubView.get());
            switch (activeSubView) {
                case ANDROID: {
                    if (!this.androidSubViewViewModel.handleGatordRunningStates()) {
                        return;
                    }
                    @Nullable IAndroidTargetLauncher iAndroidTargetLauncher = (IAndroidTargetLauncher)this.androidTargetLauncher.get();
                    if (iAndroidTargetLauncher == null) break;
                    boolean shouldOverride = this.androidSubViewViewModel.overrideActivityProperty().get();
                    String overrideActivityName = this.androidSubViewViewModel.overrideActivityNameProperty().get();
                    if (shouldOverride && overrideActivityName != null) {
                        if (overrideActivityName.isBlank()) {
                            MessageDialog.openWarning(null, (String)LandingPageMessages.TITLE_NO_ACTIVITY_SPECIFIED, (String)LandingPageMessages.NO_ACTIVITY_NAME_SPECIFIED);
                            break;
                        }
                        iAndroidTargetLauncher.getDebuggablePackage().setOverrideActivity(overrideActivityName, true);
                    } else {
                        iAndroidTargetLauncher.getDebuggablePackage().setOverrideActivity("", false);
                    }
                    this.androidSubViewViewModel.storeArguments();
                    String activityArgs = this.androidSubViewViewModel.applicationArgumentsProperty().get();
                    if (activityArgs != null) {
                        iAndroidTargetLauncher.getDebuggablePackage().setActivityArguments(activityArgs);
                    } else {
                        iAndroidTargetLauncher.getDebuggablePackage().setActivityArguments("");
                    }
                    this.actionsHandler.showStartCapture(iAndroidTargetLauncher);
                    break;
                }
                case TCP: {
                    @Nullable ITcpTargetLauncher iTcpTargetLauncher = (ITcpTargetLauncher)this.tcpTargetLauncher.get();
                    if (iTcpTargetLauncher == null) break;
                    this.actionsHandler.showStartCapture(iTcpTargetLauncher);
                    break;
                }
                case SSH: {
                    if (!this.sshSubViewViewModel.handleGatordRunningStates()) {
                        return;
                    }
                    @Nullable ISshTargetLauncher iSshTargetLauncher = (ISshTargetLauncher)this.sshTargetLauncher.get();
                    if (iSshTargetLauncher == null) break;
                    this.actionsHandler.showStartCapture(iSshTargetLauncher);
                    break;
                }
            }
        }
    }

    @Override
    public @NonNull ILandingPageTcpSubViewViewModel getTcpSubViewViewModel() {
        return this.tcpSubViewViewModel;
    }

    @Override
    public @NonNull ILandingPageAndroidSubViewViewModel getAndroidSubViewViewModel() {
        return this.androidSubViewViewModel;
    }

    @Override
    public @NonNull ILandingPageSshSubViewViewModel getSshSubViewViewModel() {
        return this.sshSubViewViewModel;
    }

    private @Nullable ITargetLauncher calculateSelectedTargetLauncher() {
        ILandingPageSceneViewModel.SubView activeSubView = (ILandingPageSceneViewModel.SubView)((Object)this.activeSubView.get());
        switch (activeSubView) {
            case ANDROID: {
                this.androidTargetLauncher.set((Object)((IAndroidTargetLauncher)this.androidSubViewViewModel.activeTargetLauncherProperty().get()));
                return (ITargetLauncher)this.androidTargetLauncher.get();
            }
            case TCP: {
                this.tcpTargetLauncher.set((Object)((ITcpTargetLauncher)this.tcpSubViewViewModel.activeTargetLauncherProperty().get()));
                return (ITargetLauncher)this.tcpTargetLauncher.get();
            }
            case SSH: {
                this.sshTargetLauncher.set((Object)((ISshTargetLauncher)this.sshSubViewViewModel.activeTargetLauncherProperty().get()));
                return (ITargetLauncher)this.sshTargetLauncher.get();
            }
        }
        throw new AssertionError((Object)activeSubView);
    }

    @Override
    public @NonNull SimpleBooleanProperty isMaliGpuDetected() {
        return this.isMaliGpuDetected;
    }

    private boolean checkIfMaliDetected() {
        ILandingPageSceneViewModel.SubView activeSubView = (ILandingPageSceneViewModel.SubView)((Object)this.activeSubView.get());
        switch (activeSubView) {
            case ANDROID: {
                IAndroidTargetDevice iAndroidTargetDevice = (IAndroidTargetDevice)this.androidSubViewViewModel.selectedDeviceProperty().get();
                if (iAndroidTargetDevice != null) {
                    return iAndroidTargetDevice.isMaliGpuDetected();
                }
                return false;
            }
            case TCP: {
                return false;
            }
            case SSH: {
                return false;
            }
        }
        throw new AssertionError((Object)activeSubView);
    }

    @FunctionalInterface
    public static interface IAndroidTargetLauncherFactory {
        public @Nullable IAndroidTargetLauncher create(@NonNull String var1, @NonNull IAndroidPackage var2, boolean var3, @NonNull AdbDeviceRootMode var4);
    }

    @FunctionalInterface
    public static interface ISshTargetLauncherFactory {
        public @Nullable ISshTargetLauncher create(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull OpenSSHConfigParser.SSHTargetConfig var1, @NonNull String var2, @NonNull String var3, @NonNull String var4, int var5, @NonNull String var6, boolean var7, boolean var8);
    }

    @FunctionalInterface
    public static interface ITcpTargetLauncherFactory {
        public @Nullable ITcpTargetLauncher create(@NonNull String var1, @NonNull String var2, @NonNull String var3, @NonNull String var4, boolean var5);
    }
}

