/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part;

import com.arm.streamline.ui.controls.table.SvgImageTableCell;
import com.arm.streamline.ui.controls.table.TooltipTableRow;
import com.arm.streamline.ui.part.LandingPageScene;
import com.arm.streamline.ui.utils.NodeUtils;
import com.arm.streamline.ui.utils.SvgImageUtility;
import com.arm.streamline.ui.vm.ILandingPageSshSubViewViewModel;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import com.arm.streamline.ui.vm.SshDeviceStatus;
import java.io.IOException;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class LandingPageSshSubView {
    @FXML
    private RadioButton btnEnterTargetDetails;
    @FXML
    private TableColumn<ISshTargetLauncher, SshDeviceStatus> colStatus;
    @FXML
    private TableColumn<ISshTargetLauncher, String> colName;
    @FXML
    private TableColumn<ISshTargetLauncher, String> colHost;
    @FXML
    private TableColumn<ISshTargetLauncher, String> colUser;
    @FXML
    private TableColumn<ISshTargetLauncher, String> colSshPort;
    @FXML
    private TableColumn<ISshTargetLauncher, String> colGatorPort;
    @FXML
    private TableColumn<ISshTargetLauncher, String> colEdit;
    @FXML
    private Button btnAddTarget;
    @FXML
    private Button btnModify;
    @FXML
    private Button btnDelete;
    private final @NonNull VBox rootNode;
    @FXML
    private TableView<ISshTargetLauncher> tblExistingTargetsSsh;
    @FXML
    private TextFlow txfMissingAdbLabel;
    @FXML
    private TextField txtRunCommand;
    @FXML
    private TextField txtWorkingDir;
    @FXML
    private TextField txtUserName;
    @FXML
    private CheckBox cbxStopOnExit;

    public LandingPageSshSubView(@NonNull ILandingPageSshSubViewViewModel viewModel) throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader(LandingPageScene.class.getResource("/resources/fxml/landing-page-ssh-target-subview.fxml"));
        fxmlLoader.setResources(ResourceBundle.getBundle("com.arm.streamline.ui.part.LandingPageFxmlMessages"));
        fxmlLoader.setController((Object)this);
        this.rootNode = (VBox)fxmlLoader.load();
        this.colStatus.setCellFactory(c -> new SvgImageTableCell(true, SvgImageUtility::mapStatusToSvgImage, s -> null, s -> null, s -> null));
        this.colStatus.setCellValueFactory(cdf -> {
            ISshTargetLauncher tl = (ISshTargetLauncher)cdf.getValue();
            return viewModel.getStatusPropertyFor(tl);
        });
        this.colName.setCellValueFactory(cdf -> {
            ISshTargetLauncher tl = (ISshTargetLauncher)cdf.getValue();
            return new ReadOnlyStringWrapper(tl.getSSHTargetConfig().id());
        });
        this.colHost.setCellValueFactory(cdf -> {
            ISshTargetLauncher tl = (ISshTargetLauncher)cdf.getValue();
            return new ReadOnlyStringWrapper(tl.getSSHTargetConfig().hostname());
        });
        this.colUser.setCellValueFactory(cdf -> {
            ISshTargetLauncher tl = (ISshTargetLauncher)cdf.getValue();
            return new ReadOnlyStringWrapper(tl.getSSHTargetConfig().username());
        });
        this.colSshPort.setCellValueFactory(cdf -> {
            ISshTargetLauncher tl = (ISshTargetLauncher)cdf.getValue();
            return new ReadOnlyStringWrapper(String.valueOf(tl.getSSHTargetConfig().port()));
        });
        this.colGatorPort.setCellValueFactory(cdf -> {
            ISshTargetLauncher tl = (ISshTargetLauncher)cdf.getValue();
            return new ReadOnlyStringWrapper(String.valueOf(tl.getGatorPortNumeric()));
        });
        this.txtRunCommand.textProperty().bindBidirectional(viewModel.commandPathTextProperty());
        this.txtWorkingDir.textProperty().bindBidirectional(viewModel.commandWorkingDirTextProperty());
        this.txtUserName.textProperty().bindBidirectional(viewModel.commandUserNameTextProperty());
        this.cbxStopOnExit.selectedProperty().bindBidirectional((Property)viewModel.commandStopOnExitProperty());
        NodeUtils.createTooltipBoundToPromptText(this.txtRunCommand);
        NodeUtils.createTooltipBoundToPromptText(this.txtWorkingDir);
        NodeUtils.createTooltipBoundToPromptText(this.txtUserName);
        this.tblExistingTargetsSsh.setRowFactory(v -> new TooltipTableRow<ISshTargetLauncher>(s -> {
            ObservableValue<SshDeviceStatus> sp = viewModel.getStatusPropertyFor((ISshTargetLauncher)s);
            return Bindings.createStringBinding(() -> {
                switch ((SshDeviceStatus)((Object)((Object)((Object)((Object)sp.getValue()))))) {
                    case AVAILABLE: {
                        return "Available";
                    }
                    case UNAVAILABLE_GATORD_PROCESS_FOUND: {
                        return "Gator already running on target";
                    }
                    case UNAVAILABLE_KILLABLE_GATORD_RUNNING: {
                        return "Gator already running on target, but can be stopped";
                    }
                    case UNAVAILABLE_NON_GATORD_USING_PORT: {
                        return "Some other process is using the port specified";
                    }
                    case UNAVAILABLE_UNKILLABLE_GATORD_RUNNING: {
                        return "Gator already running on target";
                    }
                    case UNAVAILABLE_UNKNOWN: {
                        return "Unavailable";
                    }
                }
                throw new AssertionError(sp.getValue());
            }, (Observable[])new Observable[]{sp});
        }));
        this.tblExistingTargetsSsh.setItems(viewModel.detectedDevicesProperty());
        TableView.TableViewSelectionModel selectionModel = this.tblExistingTargetsSsh.getSelectionModel();
        selectionModel.setSelectionMode(SelectionMode.SINGLE);
        this.btnModify.setDisable(true);
        this.btnDelete.setDisable(true);
        this.tblExistingTargetsSsh.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            this.btnModify.setDisable(false);
            this.btnDelete.setDisable(false);
            for (ISshTargetLauncher sshTarget : this.tblExistingTargetsSsh.getSelectionModel().getSelectedItems()) {
                if (sshTarget == null) continue;
                viewModel.setSelectedDeviceIfPresent(sshTarget);
            }
        });
        this.btnAddTarget.setOnMouseClicked(e -> {
            viewModel.doShowSSHConfiguration(null);
            if (!this.tblExistingTargetsSsh.getItems().isEmpty()) {
                int lastAdded = this.tblExistingTargetsSsh.getItems().size() - 1;
                this.tblExistingTargetsSsh.requestFocus();
                this.tblExistingTargetsSsh.getSelectionModel().select(lastAdded);
                this.tblExistingTargetsSsh.getFocusModel().focus(lastAdded);
            }
        });
        this.btnModify.setOnMouseClicked(e -> {
            for (ISshTargetLauncher sshTarget : this.tblExistingTargetsSsh.getSelectionModel().getSelectedItems()) {
                if (sshTarget == null) continue;
                int pos = this.tblExistingTargetsSsh.getItems().indexOf((Object)sshTarget);
                viewModel.doShowSSHConfiguration(sshTarget);
                viewModel.setSelectedDeviceIfPresent(sshTarget);
                this.tblExistingTargetsSsh.getSelectionModel().select(pos);
                this.tblExistingTargetsSsh.getFocusModel().focus(pos);
                break;
            }
            this.tblExistingTargetsSsh.refresh();
        });
        this.btnDelete.setOnMouseClicked(e -> {
            viewModel.removeDevices((ObservableList<ISshTargetLauncher>)this.tblExistingTargetsSsh.getSelectionModel().getSelectedItems());
            if (this.tblExistingTargetsSsh.getItems().isEmpty()) {
                this.btnModify.setDisable(true);
                this.btnDelete.setDisable(true);
                viewModel.selectedDetectedDeviceProperty().set(null);
            } else {
                int lastElem = this.tblExistingTargetsSsh.getItems().size() - 1;
                this.tblExistingTargetsSsh.getSelectionModel().select(lastElem);
                this.tblExistingTargetsSsh.getFocusModel().focus(lastElem);
            }
        });
    }

    private static @Nullable Shell getShell() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return null;
        }
        IWorkbenchWindow aww = wb.getActiveWorkbenchWindow();
        if (aww == null) {
            return null;
        }
        return aww.getShell();
    }

    public @NonNull Node getNode() {
        return this.rootNode;
    }
}

