/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part;

import com.arm.streamline.ui.part.LandingPageAdvancedCaptureConfigView;
import com.arm.streamline.ui.part.LandingPageAndroidSubView;
import com.arm.streamline.ui.part.LandingPageBasicCaptureConfigView;
import com.arm.streamline.ui.part.LandingPageSshSubView;
import com.arm.streamline.ui.part.LandingPageTcpSubView;
import com.arm.streamline.ui.utils.BidirectionalKeyedToggleGroup;
import com.arm.streamline.ui.utils.ObservableUtils;
import com.arm.streamline.ui.vm.ILandingPageSceneViewModel;
import com.arm.utils.ListUtils;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.StackPane;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.services.IDisposable;

public final class LandingPageScene {
    @FXML
    private RadioButton btnPickAndroidDeviceType;
    @FXML
    private RadioButton btnPickTcpDeviceType;
    @FXML
    private RadioButton btnPickSshDeviceType;
    @FXML
    private Button btnStartCapture;
    @FXML
    private StackPane captureConfigContents;
    @FXML
    private CheckBox btnUseAdvancedMode;
    @FXML
    private StackPane contents;
    private final @NonNull Scene scene;
    private final @NonNull LandingPageTcpSubView tcpSubView;
    private final @NonNull LandingPageSshSubView sshSubView;
    private final @Nullable LandingPageAndroidSubView androidSubView;
    private final @NonNull LandingPageAdvancedCaptureConfigView advancedCaptureConfigView;
    private final @NonNull LandingPageBasicCaptureConfigView basicCaptureConfigView;
    private final @Nullable IDisposable activeSubViewChangeListener;
    private final @NonNull BidirectionalKeyedToggleGroup<ILandingPageSceneViewModel.SubView, RadioButton> toggleGroup;

    protected static <V> @NonNull IDisposable setChildrenBySubView(@NonNull ObservableValue<@NonNull ILandingPageSceneViewModel.SubView> subView, @NonNull List<@NonNull V> childList, @Nullable V tcpValue, @Nullable V androidValue, @Nullable V sshValue) {
        return ObservableUtils.onChange(subView, i -> {
            switch (i) {
                case ANDROID: {
                    if (androidValue == null) break;
                    ListUtils.addOrSetAtIndexZero((List)childList, (Object)androidValue);
                    break;
                }
                case TCP: {
                    if (tcpValue == null) break;
                    ListUtils.addOrSetAtIndexZero((List)childList, (Object)tcpValue);
                    break;
                }
                case SSH: {
                    if (sshValue == null) break;
                    ListUtils.addOrSetAtIndexZero((List)childList, (Object)sshValue);
                    break;
                }
                default: {
                    throw new AssertionError(i);
                }
            }
        });
    }

    public LandingPageScene(@NonNull ILandingPageSceneViewModel viewModel, boolean licenseSupportsAndroid, boolean licenseSupportsLinux) throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader(LandingPageScene.class.getResource("/resources/fxml/landing-page-shell.fxml"));
        fxmlLoader.setController((Object)this);
        ScrollPane rootNode = (ScrollPane)fxmlLoader.load();
        this.scene = new Scene((Parent)rootNode);
        this.tcpSubView = new LandingPageTcpSubView(viewModel.getTcpSubViewViewModel(), licenseSupportsAndroid, licenseSupportsLinux);
        this.sshSubView = new LandingPageSshSubView(viewModel.getSshSubViewViewModel());
        Node androidNode = null;
        if (licenseSupportsAndroid) {
            LandingPageAndroidSubView androidSubView;
            this.androidSubView = androidSubView = new LandingPageAndroidSubView(viewModel.getAndroidSubViewViewModel(), licenseSupportsAndroid);
            androidNode = androidSubView.getNode();
        } else {
            this.androidSubView = null;
            this.btnPickAndroidDeviceType.setDisable(true);
        }
        this.activeSubViewChangeListener = LandingPageScene.setChildrenBySubView(viewModel.activeSubViewProperty(), this.contents.getChildren(), this.tcpSubView.getNode(), androidNode, this.sshSubView.getNode());
        this.toggleGroup = BidirectionalKeyedToggleGroup.create(viewModel.activeSubViewProperty(), Map.of(ILandingPageSceneViewModel.SubView.ANDROID, (RadioButton)NullChecking.neverNull((Object)this.btnPickAndroidDeviceType), ILandingPageSceneViewModel.SubView.TCP, (RadioButton)NullChecking.neverNull((Object)this.btnPickTcpDeviceType), ILandingPageSceneViewModel.SubView.SSH, (RadioButton)NullChecking.neverNull((Object)this.btnPickSshDeviceType)));
        this.advancedCaptureConfigView = new LandingPageAdvancedCaptureConfigView(viewModel);
        this.basicCaptureConfigView = new LandingPageBasicCaptureConfigView(viewModel);
        this.selectCaptureConfigView(viewModel.inAdvancedMode().get());
        this.btnUseAdvancedMode.selectedProperty().bindBidirectional((Property)viewModel.inAdvancedMode());
        viewModel.inAdvancedMode().addListener((v, o, n) -> this.selectCaptureConfigView((boolean)n));
        viewModel.activeSubViewProperty().addListener((v, o, n) -> {
            if (n.equals((Object)ILandingPageSceneViewModel.SubView.TCP)) {
                this.btnUseAdvancedMode.setVisible(false);
            } else {
                this.btnUseAdvancedMode.setVisible(true);
            }
        });
        this.btnStartCapture.disableProperty().bind((ObservableValue)viewModel.disableStartCaptureProperty());
        this.btnStartCapture.setOnAction(e -> viewModel.doStartCapture());
        viewModel.activeSubViewProperty().set((Object)(licenseSupportsAndroid ? ILandingPageSceneViewModel.SubView.ANDROID : ILandingPageSceneViewModel.SubView.TCP));
        viewModel.inAdvancedMode().set(viewModel.isAdvancedConfigModePreferred());
    }

    private void selectCaptureConfigView(boolean advanced) {
        if (advanced) {
            ListUtils.addOrSetAtIndexZero((List)this.captureConfigContents.getChildren(), (Object)this.advancedCaptureConfigView.getNode());
        } else {
            ListUtils.addOrSetAtIndexZero((List)this.captureConfigContents.getChildren(), (Object)this.basicCaptureConfigView.getNode());
        }
    }

    public @NonNull Scene getScene() {
        return this.scene;
    }

    public void addListenersToScene() {
        if (this.androidSubView != null) {
            this.androidSubView.addListenersToScene(this.scene);
        }
    }
}

