/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part;

import com.arm.streamline.ui.Images;
import com.arm.streamline.ui.dialog.HybridModalDialog;
import com.arm.streamline.ui.part.GatordRunningErrorDialogMessages;
import com.arm.streamline.ui.vm.GatordRunningErrorDialogFlags;
import com.arm.streamline.ui.vm.GatordRunningErrorDialogResult;
import com.arm.streamline.ui.vm.ILandingPageSceneViewModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GatordRunningErrorDialog
extends HybridModalDialog<GatordRunningErrorDialogResult> {
    private final @NonNull String FXML_PATH = "/resources/fxml/error-dialog-running-gatord.fxml";
    private final @NonNull String STYLE_CENTER_ALIGN = "-fx-alignment: CENTER;";
    private static final @Nullable Image ANDROID_ICON;
    private static final @Nullable Image SSH_ICON;
    @FXML
    private DialogPane dialogPane;
    @FXML
    private ButtonType btnTypeStop;
    @FXML
    private ButtonType btnTypeUse;
    @FXML
    private ButtonType btnTypeCancel;
    @FXML
    private Label lblErrorMessageHeader;
    @FXML
    private Label lblErrorMessageBody;
    @FXML
    private ImageView imgDeviceIcon;
    private final @NonNull String title;
    private final @NonNull String messageHeader;
    private final @NonNull String messageBody;
    private final ILandingPageSceneViewModel.SubView subView;
    private boolean hideUseButton;
    private boolean hideStopButton;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try {
                InputStream androidIconResource = Images.asInputStream("android-black-18dp.png");
                try {
                    try (InputStream sshIconResource = Images.asInputStream("terminal.png");){
                        ANDROID_ICON = androidIconResource == null ? null : new Image(androidIconResource);
                        SSH_ICON = sshIconResource == null ? null : new Image(sshIconResource);
                    }
                    if (androidIconResource == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (androidIconResource == null) throw throwable;
                    androidIconResource.close();
                    throw throwable;
                }
                androidIconResource.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public GatordRunningErrorDialog(@NonNull String title, @NonNull String messageHeader, @NonNull String messageBody, GatordRunningErrorDialogFlags flags) {
        this.title = title;
        this.messageHeader = messageHeader;
        this.messageBody = messageBody;
        this.subView = flags.subView();
        this.hideUseButton = flags.hideUseButton();
        this.hideStopButton = flags.hideStopButton();
    }

    @Override
    protected void configureDialog() {
        this.lblErrorMessageHeader.setText(this.messageHeader);
        this.lblErrorMessageBody.setText(this.messageBody);
        Image iconImage = this.getIconImage();
        if (iconImage != null) {
            this.imgDeviceIcon.setImage(iconImage);
        }
        this.dialogPane.getButtonTypes().stream().map(arg_0 -> ((DialogPane)this.dialogPane).lookupButton(arg_0)).forEach(btn -> {
            ButtonBar.setButtonUniformSize((Node)btn, (boolean)false);
            btn.setStyle("-fx-alignment: CENTER;");
        });
        Button btnStop = (Button)this.dialogPane.lookupButton(this.btnTypeStop);
        assert (btnStop != null);
        btnStop.setOnAction(event -> {
            this.result.set((Object)GatordRunningErrorDialogResult.STOP);
            this.dispose();
        });
        btnStop.setVisible(!this.hideStopButton);
        btnStop.setTooltip(new Tooltip(GatordRunningErrorDialogMessages.STOP));
        Button btnUse = (Button)this.dialogPane.lookupButton(this.btnTypeUse);
        assert (btnUse != null);
        btnUse.setOnAction(event -> {
            this.result.set((Object)GatordRunningErrorDialogResult.USE);
            this.dispose();
        });
        btnUse.setVisible(!this.hideUseButton);
        btnUse.setTooltip(new Tooltip(GatordRunningErrorDialogMessages.USE));
        Button btnCancel = (Button)this.dialogPane.lookupButton(this.btnTypeCancel);
        assert (btnUse != null);
        btnCancel.setOnAction(event -> {
            this.result.set((Object)GatordRunningErrorDialogResult.CANCEL);
            this.dispose();
        });
        btnCancel.setTooltip(new Tooltip(GatordRunningErrorDialogMessages.CANCEL));
    }

    private @Nullable Image getIconImage() {
        switch (this.subView) {
            case ANDROID: {
                return ANDROID_ICON;
            }
            case SSH: {
                return SSH_ICON;
            }
        }
        return null;
    }

    @Override
    protected @NonNull URL getFXMLFileURL() {
        return this.getClass().getResource("/resources/fxml/error-dialog-running-gatord.fxml");
    }

    @Override
    protected @NonNull String getTitle() {
        return this.title;
    }

    @Override
    protected void onDispose() {
    }

    @Override
    protected void setFocus() {
        this.dialogPane.requestFocus();
    }
}

